/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.runner;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.runner.LogMessageDialog;
import com.savvytest.eclipse.runner.RunTestsuiteOperation;
import com.savvytest.eclipse.runner.RunnerInformation;
import com.savvytest.eclipse.runner.SavvytestRunnerException;
import com.savvytest.eclipse.runner.SavvytestRunnerPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressConstants;

public class RunTestsuiteJob
extends Job {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.runner.RunTestsuiteJob.";
    private final IFile testsuiteFile;
    private final RunnerInformation information;
    private IFile outputFile;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = SavvytestRunnerPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public RunTestsuiteJob(IFile file, RunnerInformation information) {
        this(file, information, RunTestsuiteJob.getClassString("jobname", file.getName(), "", ""));
    }

    public RunTestsuiteJob(IFile testsuiteFile, RunnerInformation information, String name) {
        super(name);
        this.testsuiteFile = testsuiteFile;
        this.information = information;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        block9: {
            status = new Status(0, "com.savvytest.eclipse.runner", RunTestsuiteJob.getClassString("okstatus", new Object[0]));
            if (this.testsuiteFile != null) {
                this.setProperty(IProgressConstants.ICON_PROPERTY, ImageDescriptor.createFromURL((URL)SavvytestRunnerPlugin.INSTANCE.getImage("TestsuiteModelFile")));
                RunTestsuiteOperation operation = new RunTestsuiteOperation(this.testsuiteFile, this.information);
                try {
                    operation.run(monitor);
                    this.outputFile = operation.getOutputFile();
                    if (this.isModal()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RunTestsuiteJob.this.openEditor();
                                }
                                catch (PartInitException e) {
                                    SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                                }
                            }
                        });
                        break block9;
                    }
                    this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                    this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(){

                        @Override
                        public void run() {
                            try {
                                RunTestsuiteJob.this.openEditor();
                            }
                            catch (PartInitException e) {
                                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                            }
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    SavvytestSettings.INSTANCE.getLogger().log(ex, (Object)this);
                    if (this.isModal()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                RunTestsuiteJob.this.showErrorDialog(shell, ex, false);
                            }
                        });
                    } else {
                        this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                        this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, Boolean.TRUE);
                        this.setProperty(IProgressConstants.ACTION_PROPERTY, new Action(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                RunTestsuiteJob.this.showErrorDialog(shell, ex, true);
                            }
                        });
                    }
                    monitor.setTaskName(RunTestsuiteJob.getClassString("defaulterrortitle", this.information.connection.getName()));
                    status = new Status(4, "com.savvytest.eclipse.runner", this.getErrorMessage(ex), ex.getCause());
                }
                catch (OperationCanceledException operationCanceledException) {
                    status = Status.CANCEL_STATUS;
                }
            } else {
                SavvytestSettings.INSTANCE.getLogger().log("No file was given to run.", LogLevel.WARNING, this);
                status = new Status(2, "com.savvytest.eclipse.runner", RunTestsuiteJob.getClassString("nofile", new Object[0]));
            }
        }
        if (status.isOK()) {
            SavvytestSettings.INSTANCE.getLogger().log("Testsuite " + this.testsuiteFile + " run successfully.", LogLevel.INFO, this);
        }
        return status;
    }

    private void openEditor() throws PartInitException {
        IWorkbenchWindow window;
        SavvytestSettings.INSTANCE.getLogger().log("Opening result editor on file: " + this.outputFile, LogLevel.DEBUG, this);
        if (this.outputFile != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            window.getActivePage().openEditor(new FileEditorInput(this.outputFile), "com.savvytest.eclipse.editor.result.SavvytestResultEditorID");
        }
    }

    private void showErrorDialog(Shell parentShell, InvocationTargetException ex, boolean force) {
        List<SavvytestRunnerException.LogMessage> messages;
        String msg = this.getErrorMessage(ex);
        if (ex.getCause() instanceof SavvytestRunnerException && (messages = ((SavvytestRunnerException)ex.getCause()).getLogMessages()) != null && !messages.isEmpty()) {
            String connectionName = this.information.connection.getName();
            LogMessageDialog.open(parentShell, RunTestsuiteJob.getClassString("defaulterrortitle", connectionName), RunTestsuiteJob.getClassString("defaulterrormessage", connectionName, ex.getCause().getLocalizedMessage()), messages);
            return;
        }
        if (force) {
            this.showDefaultErrorDialog(parentShell, msg);
        }
    }

    private void showDefaultErrorDialog(Shell parentShell, String msg) {
        Shell shell = null;
        shell = parentShell == null || parentShell.isDisposed() ? new Shell(Display.getDefault(), 32768) : new Shell(parentShell, parentShell.getStyle() | 0x8000);
        String connectionName = this.information.connection.getName();
        MessageDialog.openError(shell, RunTestsuiteJob.getClassString("defaulterrortitle", connectionName), msg);
    }

    private String getErrorMessage(InvocationTargetException e) {
        String connectionName = this.information.connection.getName();
        return RunTestsuiteJob.getClassString("defaulterrormessage", connectionName, e.getCause().getLocalizedMessage());
    }

    private boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }
}

