/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.context.ContextManager;
import org.eclipse.help.internal.extension.ContentExtensionManager;
import org.eclipse.help.internal.index.IndexManager;
import org.eclipse.help.internal.toc.TocManager;
import org.osgi.framework.BundleContext;

public class HelpPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help";
    public static final String HELP_DATA_KEY = "HELP_DATA";
    public static final String BASE_TOCS_KEY = "baseTOCS";
    public static final String IGNORED_TOCS_KEY = "ignoredTOCS";
    public static final String IGNORED_INDEXES_KEY = "ignoredIndexes";
    private static HelpPlugin plugin;
    private static Object tocManagerCreateLock;
    private TocManager tocManager;
    private ContextManager contextManager;
    private ContentExtensionManager contentExtensionManager;
    private IndexManager indexManager;
    private IHelpProvider helpProvider;

    static {
        tocManagerCreateLock = new Object();
    }

    public static void logWarning(String message) {
        Status errorStatus = new Status(2, PLUGIN_ID, 0, message, null);
        HelpPlugin.logStatus(errorStatus);
    }

    public static void logError(String message) {
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, null);
        HelpPlugin.logStatus(errorStatus);
    }

    public static void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.logStatus(errorStatus);
    }

    private static synchronized void logStatus(IStatus errorStatus) {
        HelpPlugin.getDefault().getLog().log(errorStatus);
    }

    public static HelpPlugin getDefault() {
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TocManager getTocManager() {
        if (HelpPlugin.getDefault().tocManager == null) {
            Object object = tocManagerCreateLock;
            synchronized (object) {
                if (HelpPlugin.getDefault().tocManager == null) {
                    HelpPlugin.getDefault().tocManager = new TocManager();
                }
            }
        }
        return HelpPlugin.getDefault().tocManager;
    }

    public static ContextManager getContextManager() {
        if (HelpPlugin.getDefault().contextManager == null) {
            HelpPlugin.getDefault().contextManager = new ContextManager();
        }
        return HelpPlugin.getDefault().contextManager;
    }

    public static ContentExtensionManager getContentExtensionManager() {
        if (HelpPlugin.getDefault().contentExtensionManager == null) {
            HelpPlugin.getDefault().contentExtensionManager = new ContentExtensionManager();
        }
        return HelpPlugin.getDefault().contentExtensionManager;
    }

    public static IndexManager getIndexManager() {
        if (HelpPlugin.getDefault().indexManager == null) {
            HelpPlugin.getDefault().indexManager = new IndexManager();
        }
        return HelpPlugin.getDefault().indexManager;
    }

    public IHelpProvider getHelpProvider() {
        return this.helpProvider;
    }

    public void setHelpProvider(IHelpProvider helpProvider) {
        this.helpProvider = helpProvider;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static interface IHelpProvider {
        public InputStream getHelpContent(String var1, String var2);
    }
}

