/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class CloseResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.CloseResourceAction";
    private String[] modelProviderIds;

    public CloseResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseResourceAction_text);
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    protected CloseResourceAction(Shell shell, String text) {
        super(shell, text);
    }

    List getDirtyEditors(List projects) {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>(0);
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorPart[] editors = page.getDirtyEditors();
                int k = 0;
                while (k < editors.length) {
                    IEditorPart editor = editors[k];
                    IFile inputFile = ResourceUtil.getFile(editor.getEditorInput());
                    if (inputFile != null && projects.contains(inputFile.getProject())) {
                        dirtyEditors.add(editor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return dirtyEditors;
    }

    List getEditorsToSave(List dirtyEditors) {
        if (dirtyEditors.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<IEditorPart> saveEditors = new ArrayList<IEditorPart>(0);
        ArrayList<IFile> dirtyInputs = new ArrayList<IFile>(0);
        Iterator iter = dirtyEditors.iterator();
        while (iter.hasNext()) {
            IEditorPart editor = (IEditorPart)iter.next();
            IFile inputFile = ResourceUtil.getFile(editor.getEditorInput());
            if (inputFile == null || dirtyInputs.contains(inputFile)) continue;
            dirtyInputs.add(inputFile);
            saveEditors.add(editor);
        }
        AdaptableList input = new AdaptableList(saveEditors);
        ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), input, new WorkbenchContentProvider(), new WorkbenchPartLabelProvider(), IDEWorkbenchMessages.EditorManager_saveResourcesMessage);
        dlg.setInitialSelections(saveEditors.toArray(new Object[saveEditors.size()]));
        dlg.setTitle(IDEWorkbenchMessages.EditorManager_saveResourcesTitle);
        int result = dlg.open();
        if (result == 1) {
            return null;
        }
        return Arrays.asList(dlg.getResult());
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.CloseResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.CloseResourceAction_title;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).close(monitor);
    }

    public void run() {
        if (!this.saveDirtyEditors()) {
            return;
        }
        if (!this.validateClose()) {
            return;
        }
        ISchedulingRule rule = null;
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject project = (IProject)resources.next();
            rule = MultiRule.combine(rule, factory.modifyRule(project));
        }
        this.runInBackground(rule);
    }

    boolean saveDirtyEditors() {
        List projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        final List dirtyEditors = this.getDirtyEditors(projects);
        final List saveEditors = this.getEditorsToSave(dirtyEditors);
        if (saveEditors == null) {
            return false;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Iterator iter = dirtyEditors.iterator();
                while (iter.hasNext()) {
                    IEditorPart editor = (IEditorPart)iter.next();
                    IWorkbenchPage page = editor.getEditorSite().getPage();
                    if (saveEditors.contains(editor)) {
                        editor.doSave(new NullProgressMonitor());
                    }
                    page.closeEditor(editor, false);
                }
            }
        });
        return true;
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (!currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }

    private boolean validateClose() {
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        List resources = this.getActionResources();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            if (!(resource instanceof IProject)) continue;
            IProject project = (IProject)resource;
            factory.close(project);
        }
        String message = resources.size() == 1 ? NLS.bind(IDEWorkbenchMessages.CloseResourceAction_warningForOne, ((IResource)resources.get(0)).getName()) : IDEWorkbenchMessages.CloseResourceAction_warningForMultiple;
        return IDE.promptToConfirm(this.getShell(), IDEWorkbenchMessages.CloseResourceAction_confirm, message, factory.getDelta(), this.getModelProviderIds(), false);
    }
}

