/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.menus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ICommandImageService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public final class CommandContributionItem
extends ContributionItem {
    public static final int STYLE_PUSH = 8;
    public static final int STYLE_CHECK = 32;
    public static final int STYLE_RADIO = 16;
    public static final int STYLE_PULLDOWN = 4;
    private LocalResourceManager localResourceManager;
    private Listener menuItemListener;
    private Widget widget;
    private IMenuService menuService;
    private ICommandService commandService;
    private IHandlerService handlerService;
    private IBindingService bindingService;
    private ParameterizedCommand command;
    private ImageDescriptor icon;
    private String label;
    private String tooltip;
    private ImageDescriptor disabledIcon;
    private ImageDescriptor hoverIcon;
    private String mnemonic;
    private IElementReference elementRef;
    private boolean checkedState;
    private int style;
    private ICommandListener commandListener;
    private String dropDownMenuOverride;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public CommandContributionItem(IServiceLocator serviceLocator, String id, String commandId, Map parameters, ImageDescriptor icon, ImageDescriptor disabledIcon, ImageDescriptor hoverIcon, String label, String mnemonic, String tooltip, int style) {
        super(id);
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.hoverIcon = hoverIcon;
        this.label = label;
        this.mnemonic = mnemonic;
        this.tooltip = tooltip;
        this.style = style;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.menuService = (IMenuService)serviceLocator.getService(clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.commandService = (ICommandService)serviceLocator.getService(clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.handlerService = (IHandlerService)serviceLocator.getService(clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bindingService = (IBindingService)serviceLocator.getService(clazz4);
        this.createCommand(commandId, parameters);
        if (this.command != null) {
            try {
                UIElement callback = new UIElement(serviceLocator){

                    public void setChecked(boolean checked) {
                        CommandContributionItem.this.setChecked(checked);
                    }

                    public void setDisabledIcon(ImageDescriptor desc) {
                        CommandContributionItem.this.setDisabledIcon(desc);
                    }

                    public void setHoverIcon(ImageDescriptor desc) {
                        CommandContributionItem.this.setHoverIcon(desc);
                    }

                    public void setIcon(ImageDescriptor desc) {
                        CommandContributionItem.this.setIcon(desc);
                    }

                    public void setText(String text) {
                        CommandContributionItem.this.setText(text);
                    }

                    public void setTooltip(String text) {
                        CommandContributionItem.this.setTooltip(text);
                    }

                    public void setDropDownId(String id) {
                        CommandContributionItem.this.dropDownMenuOverride = id;
                    }
                };
                this.elementRef = this.commandService.registerElementForCommand(this.command, callback);
                this.command.getCommand().addCommandListener(this.getCommandListener());
                this.setImages(serviceLocator);
            }
            catch (NotDefinedException notDefinedException) {
                WorkbenchPlugin.log("Unable to register menu item \"" + this.getId() + "\", command \"" + commandId + "\" not defined");
            }
        }
    }

    private void setImages(IServiceLocator locator) {
        if (this.icon == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ui.internal.commands.ICommandImageService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICommandImageService service = (ICommandImageService)locator.getService(clazz);
            this.icon = service.getImageDescriptor(this.command.getId(), ICommandImageService.TYPE_DEFAULT);
            this.disabledIcon = service.getImageDescriptor(this.command.getId(), ICommandImageService.TYPE_DISABLED);
            this.hoverIcon = service.getImageDescriptor(this.command.getId(), ICommandImageService.TYPE_HOVER);
        }
    }

    private ICommandListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new ICommandListener(){

                public void commandChanged(CommandEvent commandEvent) {
                    if (commandEvent.isHandledChanged() || commandEvent.isEnabledChanged() || commandEvent.isDefinedChanged()) {
                        if (commandEvent.isHandledChanged()) {
                            CommandContributionItem.this.dropDownMenuOverride = null;
                        }
                        if (commandEvent.getCommand().isDefined()) {
                            CommandContributionItem.this.update(null);
                        }
                    }
                }
            };
        }
        return this.commandListener;
    }

    ParameterizedCommand getCommand() {
        return this.command;
    }

    void createCommand(String commandId, Map parameters) {
        if (commandId == null) {
            WorkbenchPlugin.log("Unable to create menu item \"" + this.getId() + "\", no command id");
            return;
        }
        Command cmd = this.commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            WorkbenchPlugin.log("Unable to create menu item \"" + this.getId() + "\", command \"" + commandId + "\" not defined");
            return;
        }
        if (parameters == null || parameters.size() == 0) {
            this.command = new ParameterizedCommand(cmd, null);
            return;
        }
        try {
            ArrayList<Parameterization> parmList = new ArrayList<Parameterization>();
            Iterator i = parameters.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String parmName = (String)entry.getKey();
                IParameter parm = cmd.getParameter(parmName);
                if (parm == null) {
                    WorkbenchPlugin.log("Unable to create menu item \"" + this.getId() + "\", parameter \"" + parmName + "\" for command \"" + commandId + "\" is not defined");
                    return;
                }
                parmList.add(new Parameterization(parm, (String)entry.getValue()));
            }
            this.command = new ParameterizedCommand(cmd, parmList.toArray(new Parameterization[parmList.size()]));
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log("Failed to create menu item " + this.getId(), e);
        }
    }

    public void fill(Menu parent, int index) {
        if (this.command == null) {
            return;
        }
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(parent, tmpStyle, index) : new MenuItem(parent, tmpStyle);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
    }

    public void fill(ToolBar parent, int index) {
        if (this.command == null) {
            return;
        }
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, this.style, index) : new ToolItem(parent, this.style);
        item.setData((Object)this);
        item.addListener(13, this.getItemListener());
        item.addListener(12, this.getItemListener());
        this.widget = item;
        this.update(null);
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.widget != null) {
            if (this.widget instanceof MenuItem) {
                TriggerSequence[] bindings;
                MenuItem item = (MenuItem)this.widget;
                String text = this.label;
                if (text == null && this.command != null) {
                    try {
                        text = this.command.getCommand().getName();
                    }
                    catch (NotDefinedException e) {
                        WorkbenchPlugin.log("Update item failed " + this.getId(), e);
                    }
                }
                text = this.updateMnemonic(text);
                String keyBindingText = null;
                if (this.command != null && (bindings = this.bindingService.getActiveBindingsFor(this.command)).length > 0) {
                    keyBindingText = bindings[0].format();
                }
                if (text != null) {
                    if (keyBindingText == null) {
                        item.setText(text);
                    } else {
                        item.setText(String.valueOf(text) + '\t' + keyBindingText);
                    }
                }
                this.updateIcons();
                if (item.getSelection() != this.checkedState) {
                    item.setSelection(this.checkedState);
                }
                boolean shouldBeEnabled = this.isEnabled();
                if (item.getEnabled() != shouldBeEnabled) {
                    item.setEnabled(shouldBeEnabled);
                }
            } else if (this.widget instanceof ToolItem) {
                ToolItem item = (ToolItem)this.widget;
                if (this.icon != null) {
                    this.updateIcons();
                } else if (this.label != null) {
                    item.setText(this.label);
                }
                if (this.tooltip != null) {
                    item.setToolTipText(this.tooltip);
                } else {
                    String text = this.label;
                    if (text == null && this.command != null) {
                        try {
                            text = this.command.getCommand().getName();
                        }
                        catch (NotDefinedException e) {
                            WorkbenchPlugin.log("Update item failed " + this.getId(), e);
                        }
                    }
                    if (text != null) {
                        item.setToolTipText(text);
                    }
                }
                if (item.getSelection() != this.checkedState) {
                    item.setSelection(this.checkedState);
                }
                boolean shouldBeEnabled = this.isEnabled();
                if (item.getEnabled() != shouldBeEnabled) {
                    item.setEnabled(shouldBeEnabled);
                }
            }
        }
    }

    private String updateMnemonic(String s) {
        if (this.mnemonic == null || s == null) {
            return s;
        }
        int idx = s.indexOf(this.mnemonic);
        if (idx == -1) {
            return s;
        }
        return String.valueOf(s.substring(0, idx)) + '&' + s.substring(idx);
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.elementRef != null) {
            this.commandService.unregisterElement(this.elementRef);
            this.elementRef = null;
        }
        if (this.commandListener != null) {
            this.command.getCommand().removeCommandListener(this.commandListener);
            this.commandListener = null;
        }
        this.command = null;
        this.commandService = null;
        this.disposeOldImages();
        super.dispose();
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            CommandContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            CommandContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetSelection(Event event) {
        if (this.openDropDownMenu(event)) {
            return;
        }
        if ((this.style & 0x22) != 0) {
            if (event.widget instanceof ToolItem) {
                this.checkedState = ((ToolItem)event.widget).getSelection();
            } else if (event.widget instanceof MenuItem) {
                this.checkedState = ((MenuItem)event.widget).getSelection();
            }
        }
        try {
            this.handlerService.executeCommand(this.command, event);
        }
        catch (ExecutionException e) {
            WorkbenchPlugin.log("Failed to execute item " + this.getId(), e);
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log("Failed to execute item " + this.getId(), e);
        }
        catch (NotEnabledException e) {
            WorkbenchPlugin.log("Failed to execute item " + this.getId(), e);
        }
        catch (NotHandledException e) {
            WorkbenchPlugin.log("Failed to execute item " + this.getId(), e);
        }
    }

    private boolean openDropDownMenu(Event event) {
        int style;
        Widget item = event.widget;
        if (item != null && ((style = item.getStyle()) & 4) != 0 && event.detail == 4) {
            ToolItem ti = (ToolItem)item;
            final MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)ti.getParent());
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    String id = CommandContributionItem.this.getId();
                    if (CommandContributionItem.this.dropDownMenuOverride != null) {
                        id = CommandContributionItem.this.dropDownMenuOverride;
                    }
                    CommandContributionItem.this.menuService.populateContributionManager(menuManager, "menu:" + id);
                }
            });
            menu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    System.out.println("dispose menu");
                }
            });
            Rectangle b = ti.getBounds();
            Point p = ti.getParent().toDisplay(new Point(b.x, b.y + b.height));
            menu.setLocation(p.x, p.y);
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    private void setIcon(ImageDescriptor desc) {
        this.icon = desc;
        this.updateIcons();
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            item.setImage(this.icon == null ? null : m.createImage(this.icon));
            this.disposeOldImages();
            this.localResourceManager = m;
        } else if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            item.setDisabledImage(this.disabledIcon == null ? null : m.createImage(this.disabledIcon));
            item.setHotImage(this.hoverIcon == null ? null : m.createImage(this.hoverIcon));
            item.setImage(this.icon == null ? null : m.createImage(this.icon));
            this.disposeOldImages();
            this.localResourceManager = m;
        }
    }

    private void setText(String text) {
        this.label = text;
        this.update(null);
    }

    private void setChecked(boolean checked) {
        if (this.checkedState == checked) {
            return;
        }
        this.checkedState = checked;
        if (this.widget instanceof MenuItem) {
            ((MenuItem)this.widget).setSelection(this.checkedState);
        } else if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setSelection(this.checkedState);
        }
    }

    private void setTooltip(String text) {
        this.tooltip = text;
        if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setToolTipText(text);
        }
    }

    private void setDisabledIcon(ImageDescriptor desc) {
        this.disabledIcon = desc;
        this.updateIcons();
    }

    private void setHoverIcon(ImageDescriptor desc) {
        this.hoverIcon = desc;
        this.updateIcons();
    }

    public boolean isEnabled() {
        if (this.command != null) {
            return this.command.getCommand().isEnabled();
        }
        return false;
    }
}

