/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.statushandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchErrorHandlerProxy;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.internal.statushandlers.StatusHandlerRegistry;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;

public class StatusManager {
    public static final int NONE = 0;
    public static final int LOG = 1;
    public static final int SHOW = 2;
    public static final int BLOCK = 4;
    private static StatusManager MANAGER;
    private AbstractStatusHandler workbenchHandler;
    private List loggedStatuses = new ArrayList();

    public static StatusManager getManager() {
        if (MANAGER == null) {
            MANAGER = new StatusManager();
        }
        return MANAGER;
    }

    private StatusManager() {
        Platform.addLogListener(new StatusManagerLogListener());
    }

    private AbstractStatusHandler getWorkbenchHandler() {
        if (this.workbenchHandler == null) {
            this.workbenchHandler = new WorkbenchErrorHandlerProxy();
        }
        return this.workbenchHandler;
    }

    public void handle(StatusAdapter statusAdapter, int style) {
        try {
            if (!PlatformUI.isWorkbenchRunning()) {
                if (style != 0) {
                    this.logError(statusAdapter.getStatus());
                }
                return;
            }
            if (StatusHandlerRegistry.getDefault().getDefaultHandlerDescriptor() != null) {
                try {
                    StatusHandlerRegistry.getDefault().getDefaultHandlerDescriptor().getStatusHandler().handle(statusAdapter, style);
                    if (((style & 2) == 2 || (style & 4) == 4) && statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != Boolean.TRUE) {
                        FinishedJobs.getInstance().removeErrorJobs();
                        StatusAdapterHelper.getInstance().clear();
                    }
                    return;
                }
                catch (CoreException ex) {
                    this.logError("Errors during the default handler creating", ex);
                }
            }
            this.getWorkbenchHandler().handle(statusAdapter, style);
            if (((style & 2) == 2 || (style & 4) == 4) && statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) != Boolean.TRUE) {
                FinishedJobs.getInstance().removeErrorJobs();
            }
        }
        catch (Throwable ex) {
            this.logError(statusAdapter.getStatus());
            this.logError("Error occurred during status handling", ex);
        }
    }

    public void handle(StatusAdapter statusAdapter) {
        this.handle(statusAdapter, 1);
    }

    public void handle(IStatus status, int style) {
        StatusAdapter statusAdapter = new StatusAdapter(status);
        this.handle(statusAdapter, style);
    }

    public void handle(IStatus status) {
        this.handle(status, 1);
    }

    public void addLoggedStatus(IStatus status) {
        this.loggedStatuses.add(status);
    }

    private void logError(String message, Throwable ex) {
        IStatus status = StatusUtil.newStatus(WorkbenchPlugin.PI_WORKBENCH, message, ex);
        this.addLoggedStatus(status);
        WorkbenchPlugin.log(status);
    }

    private void logError(IStatus status) {
        this.addLoggedStatus(status);
        WorkbenchPlugin.log(status);
    }

    private class StatusManagerLogListener
    implements ILogListener {
        private StatusManagerLogListener() {
        }

        public void logging(IStatus status, String plugin) {
            if (!StatusManager.this.loggedStatuses.contains(status)) {
                StatusManager.this.handle(status, 0);
            } else {
                StatusManager.this.loggedStatuses.remove(status);
            }
        }
    }
}

