/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.tasklist.TaskList;

abstract class TaskAction
extends Action {
    private TaskList taskList;

    protected TaskAction(TaskList tasklist, String id) {
        this.taskList = tasklist;
        this.setId(id);
    }

    protected Shell getShell() {
        return this.taskList.getSite().getShell();
    }

    protected TaskList getTaskList() {
        return this.taskList;
    }

    protected void storeValue() {
        IDialogSettings workbenchSettings = TaskList.getPlugin().getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection("TaskAction");
        if (settings == null) {
            settings = workbenchSettings.addNewSection("TaskAction");
        }
        settings.put(this.getId(), this.isChecked());
    }

    void execute(IUndoableOperation operation, String title, IProgressMonitor monitor, IAdaptable uiInfo) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(operation, monitor, uiInfo);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CoreException) {
                ErrorDialog.openError(WorkspaceUndoUtil.getShell(uiInfo), title, null, ((CoreException)e.getCause()).getStatus());
            }
            IDEWorkbenchPlugin.log(title, e);
        }
    }
}

