/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.operations.UpdateUtils;

public class InstallLogParser {
    private IPath logPath;
    private BufferedReader buffRead;
    private InstallConfiguration currentConfiguration;
    private HashMap installConfigMap;
    private Comparator comparator;
    private static final String FEATURE_INSTALL = "feature-install";
    private static final String FEATURE_REMOVE = "feature-remove";
    private static final String SITE_INSTALL = "site-install";
    private static final String SITE_REMOVE = "site-remove";
    private static final String UNCONFIGURE = "feature-disable";
    private static final String CONFIGURE = "feature-enable";
    private static final String REVERT = "revert";
    private static final String RECONCILIATION = "reconciliation";
    private static final String PRESERVED = "preserve-configuration";
    private static final String ACTIVITY = "!ACTIVITY";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";

    public InstallLogParser() {
        String loc = ConfiguratorUtils.getCurrentPlatformConfiguration().getConfigurationLocation().getFile();
        this.logPath = new Path(loc).removeLastSegments(1).append("install.log");
        this.installConfigMap = new HashMap();
        try {
            InstallConfiguration[] configs = (InstallConfiguration[])SiteManager.getLocalSite().getConfigurationHistory();
            int i = 0;
            while (i < configs.length) {
                if (!configs[i].isCurrent()) {
                    this.installConfigMap.put(new Long(configs[i].getCreationDate().getTime()), configs[i]);
                }
                ++i;
            }
            InstallConfiguration config = this.getConfigCopy((InstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration());
            this.installConfigMap.put(new Long(config.getCreationDate().getTime()), config);
        }
        catch (CoreException e) {
            UpdateCore.log(e);
        }
        catch (MalformedURLException e) {
            UpdateCore.log(e);
        }
        this.comparator = new Comparator(){

            public int compare(Object e1, Object e2) {
                Date date2;
                Date date1 = ((InstallConfiguration)e1).getCreationDate();
                return date1.before(date2 = ((InstallConfiguration)e2).getCreationDate()) ? 1 : -1;
            }
        };
    }

    private InstallConfiguration getConfigCopy(InstallConfiguration origConfig) throws CoreException, MalformedURLException {
        InstallConfiguration config = new InstallConfiguration(origConfig, origConfig.getURL(), origConfig.getLabel());
        config.setCreationDate(origConfig.getCreationDate());
        return config;
    }

    public void parseInstallationLog() {
        try {
            try {
                this.openLog();
                this.parseLog();
            }
            catch (CoreException e) {
                UpdateUtils.logException(e);
                this.closeLog();
            }
        }
        finally {
            this.closeLog();
        }
    }

    private void openLog() throws CoreException {
        try {
            FileInputStream is = new FileInputStream(this.logPath.toOSString());
            InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
            this.buffRead = new BufferedReader(isr);
        }
        catch (Exception e) {
            this.throwCoreException(e);
        }
    }

    private void throwCoreException(Throwable e) throws CoreException {
        throw new CoreException(new Status(4, UpdateUtils.getPluginId(), 4, Messages.InstallLogParser_errors, e));
    }

    private void parseLog() throws CoreException {
        try {
            while (this.buffRead.ready()) {
                CharSequence date;
                String time;
                StringTokenizer htmlCode = new StringTokenizer(this.buffRead.readLine());
                while (!htmlCode.hasMoreElements()) {
                    if (!this.buffRead.ready()) {
                        return;
                    }
                    htmlCode = new StringTokenizer(this.buffRead.readLine());
                }
                String type = htmlCode.nextToken().trim();
                if (type.equals(ACTIVITY)) {
                    time = htmlCode.nextToken();
                    StringBuffer target = new StringBuffer();
                    date = htmlCode.nextToken(".");
                    htmlCode.nextToken(" ");
                    while (htmlCode.countTokens() > 2) {
                        target.append(" ");
                        target.append(htmlCode.nextToken());
                    }
                    String action = htmlCode.nextToken();
                    String status = htmlCode.nextToken();
                    this.createActivity(action, time, (String)date, status, target.toString(), this.currentConfiguration);
                    continue;
                }
                time = htmlCode.nextToken();
                date = new StringBuffer();
                while (htmlCode.countTokens() > 0) {
                    if (((StringBuffer)date).length() != 0) {
                        ((StringBuffer)date).append(" ");
                    }
                    ((StringBuffer)date).append(htmlCode.nextToken());
                }
                this.currentConfiguration = (InstallConfiguration)this.installConfigMap.get(new Long(time));
            }
        }
        catch (Exception e) {
            this.throwCoreException(e);
        }
    }

    private void closeLog() {
        try {
            try {
                if (this.buffRead != null) {
                    this.buffRead.close();
                }
            }
            catch (IOException iOException) {
                this.buffRead = null;
            }
        }
        finally {
            this.buffRead = null;
        }
    }

    private IActivity createActivity(String action, String time, String date, String status, String target, InstallConfiguration config) {
        ConfigurationActivity a = new ConfigurationActivity();
        int code = 0;
        if (FEATURE_INSTALL.equals(action)) {
            code = 1;
        } else if (FEATURE_REMOVE.equals(action)) {
            code = 2;
        } else if (SITE_INSTALL.equals(action)) {
            code = 3;
        } else if (SITE_REMOVE.equals(action)) {
            code = 4;
        } else if (UNCONFIGURE.equals(action)) {
            code = 5;
        } else if (CONFIGURE.equals(action)) {
            code = 6;
        } else if (REVERT.equals(action)) {
            code = 7;
        } else if (RECONCILIATION.equals(action)) {
            code = 8;
        } else if (PRESERVED.equals(action)) {
            code = 9;
        }
        a.setAction(code);
        try {
            long activityTime = Long.parseLong(time);
            a.setDate(new Date(activityTime));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                a.setDate(new SimpleDateFormat().parse(date));
            }
            catch (ParseException parseException) {}
        }
        a.setStatus(SUCCESS.equals(status) ? 0 : 1);
        a.setLabel(target);
        a.setInstallConfigurationModel(config);
        if (config != null && !this.configContainsActivity(config, a)) {
            config.addActivity(a);
        }
        return a;
    }

    private boolean configContainsActivity(InstallConfiguration c, IActivity a) {
        IActivity[] activities = c.getActivities();
        int i = 0;
        while (i < activities.length) {
            if (a.equals(activities[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public InstallConfiguration[] getConfigurations() {
        Collection configSet = this.installConfigMap.values();
        InstallConfiguration[] configs = configSet.toArray(new InstallConfiguration[configSet.size()]);
        Arrays.sort(configs, this.comparator);
        return configs;
    }
}

