/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.ui.wizards.ReplaceFeatureVersionWizard;
import org.eclipse.update.operations.OperationsManager;

public class ReplaceVersionAction
extends Action {
    private IFeature currentFeature;
    private IFeature[] features;
    private Shell shell;

    public ReplaceVersionAction(Shell shell, String text) {
        super(text);
        this.shell = shell;
    }

    public void setCurrentFeature(IFeature feature) {
        this.currentFeature = feature;
    }

    public void setFeatures(IFeature[] features) {
        this.features = features;
    }

    public void run() {
        if (this.currentFeature == null || this.features == null || this.features.length < 2) {
            return;
        }
        IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
        if (status != null) {
            ErrorDialog.openError(this.shell, null, null, status);
            return;
        }
        ReplaceFeatureVersionWizard wizard = new ReplaceFeatureVersionWizard(this.currentFeature, this.features);
        WizardDialog dialog = new WizardDialog(this.shell, wizard);
        dialog.create();
        dialog.getShell().setText(this.shell.getText());
        dialog.getShell().setSize(400, 400);
        dialog.open();
    }
}

