/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.cli.resultchecker;

import com.savvytest.cli.resultchecker.ResultChecker;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Main {
    private static final Pattern archiveFilePattern = Pattern.compile("^(?:-a=|-archive=)?([^-].*)$", 2);
    private static final Pattern outputFilePattern = Pattern.compile("^(?:-o=|-output=)(.*)$", 2);
    private static final Pattern resultFilePattern = Pattern.compile("^(?:-rs=|-result=)(.*)$", 2);
    private static final Pattern reportFilePattern = Pattern.compile("^(?:-rp=|-report=)(.*)$", 2);
    private static final Pattern junitFilePattern = Pattern.compile("^(?:-ju=|-junit=)(.*)$", 2);
    private static final Pattern fileEncodingPattern = Pattern.compile("^(?:-fe=|-fileencoding=)(.*)$", 2);
    private static final Pattern targetEncodingPattern = Pattern.compile("^(?:-te=|-targetencoding=)(.*)$", 2);
    private static final Pattern projectPattern = Pattern.compile("^(?:-p=|-project=)(.*)$", 2);
    private static final Pattern saveArchivePattern = Pattern.compile("^(?:-s=|-save=)(true|false)$", 2);
    private static final Pattern helpPattern = Pattern.compile("^(?:-h|-help|-\\?|\\/\\?)$", 2);

    public static void main(String[] args) {
        File archiveFile = null;
        File outputFile = null;
        File resultFile = null;
        File reportFile = null;
        File junitFile = null;
        File projectFolder = null;
        String fileEncoding = null;
        String targetEncoding = null;
        boolean saveArchive = true;
        if (args.length == 0) {
            Main.printHelp();
            System.exit(0);
        }
        for (String arg : args) {
            Matcher matcher = archiveFilePattern.matcher(arg);
            if (matcher.matches()) {
                archiveFile = new File(matcher.group(1));
                continue;
            }
            matcher = outputFilePattern.matcher(arg);
            if (matcher.matches()) {
                outputFile = new File(matcher.group(1));
                continue;
            }
            matcher = resultFilePattern.matcher(arg);
            if (matcher.matches()) {
                resultFile = new File(matcher.group(1));
                continue;
            }
            matcher = reportFilePattern.matcher(arg);
            if (matcher.matches()) {
                reportFile = new File(matcher.group(1));
                continue;
            }
            matcher = junitFilePattern.matcher(arg);
            if (matcher.matches()) {
                junitFile = new File(matcher.group(1));
                continue;
            }
            matcher = fileEncodingPattern.matcher(arg);
            if (matcher.matches()) {
                fileEncoding = matcher.group(1);
                continue;
            }
            matcher = targetEncodingPattern.matcher(arg);
            if (matcher.matches()) {
                targetEncoding = matcher.group(1);
                continue;
            }
            matcher = projectPattern.matcher(arg);
            if (matcher.matches()) {
                projectFolder = new File(matcher.group(1));
                continue;
            }
            matcher = saveArchivePattern.matcher(arg);
            if (matcher.matches()) {
                saveArchive = Boolean.parseBoolean(matcher.group(1));
                continue;
            }
            matcher = helpPattern.matcher(arg);
            if (matcher.matches()) {
                Main.printHelp();
                System.exit(0);
                continue;
            }
            SavvytestSettings.INSTANCE.getLogger().log("Unrecognized command line option skipped: " + arg, LogLevel.WARNING, Main.class);
        }
        if (projectFolder != null && archiveFile != null) {
            String fileSeparator = System.getProperty("file.separator");
            String basePath = projectFolder.getPath() + fileSeparator;
            String baseFileName = archiveFile.getName();
            baseFileName = baseFileName.endsWith("." + SavvytestTypeEnum.ARCHIVE.fileextension) ? baseFileName.substring(0, baseFileName.length() - SavvytestTypeEnum.ARCHIVE.fileextension.length()) : baseFileName + ".";
            outputFile = new File(basePath + SavvytestTypeEnum.OUTPUT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.OUTPUT.fileextension);
            resultFile = new File(basePath + SavvytestTypeEnum.RESULT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.RESULT.fileextension);
            reportFile = new File(basePath + SavvytestTypeEnum.REPORT.foldername + fileSeparator + baseFileName + SavvytestTypeEnum.REPORT.fileextension);
        }
        ResultChecker checker = new ResultChecker(archiveFile);
        checker.setOutputFile(outputFile);
        checker.setResultFile(resultFile);
        checker.setReportFile(reportFile);
        checker.setJunitReportFile(junitFile);
        checker.setFileEncoding(fileEncoding);
        checker.setHexEncoding(targetEncoding);
        checker.setSaveArchive(saveArchive);
        checker.check();
    }

    private static void printHelp() {
        System.out.println("Usage: java -jar jarfile [-options] archivefile");
        System.out.println("Options:");
        System.out.println("\t-a=<archivefile> | -archive=<archivefile>");
        System.out.println("\t\tThe archive file to parse. Same as if just the archive file is given.");
        System.out.println("\t-fe=<encoding> | -fileencoding=<encoding>");
        System.out.println("\t\tThe encoding used to store the output of this program. Default is UTF-8.");
        System.out.println("\t-h | -help | -? | /?");
        System.out.println("\t\tPrints this help.");
        System.out.println("\t-te=<encoding> | -targetencoding=<encoding>");
        System.out.println("\t\tThe encoding used by the target. Usually not needed as this information is stored in the archive.");
        System.out.println("\t-o=<archivefile> | -output=<archivefile>");
        System.out.println("\t\tWill write a new archive file instead of storing the results in the input archive file.");
        System.out.println("\t-p=<projectfolder> | -project=<projectfolder>");
        System.out.println("\t\tSpecifies the location of the savvytest project the archive resides in. Convinience option to write the output, result and report in the corresponding folders of the savvytest project. Options -o/-rp/-rs, don't need to be supplied, as they will be infered.");
        System.out.println("\t-rp=<file> | -report=<file>");
        System.out.println("\t\tTo write the report to the given file. It is a HTML document describing the results, intended for humans.");
        System.out.println("\t-ju=<file> | -junit=<file>");
        System.out.println("\t\tTo write the junit report to the given file. It is a JUnit xml file to display the test results.");
        System.out.println("\t-rs=<file> | -result=<file>");
        System.out.println("\t\tTo write the result to the given file. It is a XML document describing the results, intended for further processing.");
        System.out.println("\t-s=(true|false) | -save=(true|false)");
        System.out.println("\t\tWhether to store the output at all. If false, neither an output file will be written, nor the archive file updated an option '-o' will be ignored. Default is true.");
    }
}

