/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ToolTipHandler {
    private final Shell tipShell;
    private final Label tipLabelImage;
    private final Label tipLabelText;
    private Widget tipWidget;
    private Point tipPosition;
    private Rectangle bounds;
    private Control control;
    private final MouseMoveListener moveMouse = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (ToolTipHandler.this.bounds != null && !ToolTipHandler.this.control.isDisposed()) {
                if (ToolTipHandler.this.bounds.contains(e.x, e.y)) {
                    ToolTipHandler.this.tipPosition = ToolTipHandler.this.control.toDisplay(e.x, e.y);
                    ToolTipHandler.this.setHoverLocation(ToolTipHandler.this.tipShell, ToolTipHandler.this.tipPosition);
                } else {
                    ToolTipHandler.this.deactivate();
                }
            }
        }
    };

    public ToolTipHandler(Shell parent) {
        Display display = parent.getDisplay();
        this.tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipLabelImage = new Label((Composite)this.tipShell, 0);
        this.tipLabelImage.setForeground(display.getSystemColor(28));
        this.tipLabelImage.setBackground(display.getSystemColor(29));
        this.tipLabelImage.setLayoutData((Object)new GridData(772));
        this.tipLabelText = new Label((Composite)this.tipShell, 0);
        this.tipLabelText.setForeground(display.getSystemColor(28));
        this.tipLabelText.setBackground(display.getSystemColor(29));
        this.tipLabelText.setLayoutData((Object)new GridData(772));
    }

    public void activateHoverHelp(Control theControl) {
        this.control = theControl;
        this.control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!ToolTipHandler.this.tipShell.isDisposed() && ToolTipHandler.this.tipShell.isVisible()) {
                    ToolTipHandler.this.tipShell.setVisible(false);
                }
            }
        });
        this.control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent event) {
                ToolTipHandler.this.deactivate();
            }

            public void mouseHover(MouseEvent event) {
                Tree tree;
                TreeItem treeItem;
                int i;
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                ToolItem item = null;
                ToolTipHandler.this.bounds = null;
                int column = -1;
                if (widget instanceof ToolBar) {
                    ToolBar toolBar = (ToolBar)widget;
                    ToolItem toolItem = toolBar.getItem(pt);
                    if (toolItem != null) {
                        ToolTipHandler.this.bounds = toolItem.getBounds();
                        item = toolItem;
                    }
                } else if (widget instanceof Table) {
                    Table table = (Table)widget;
                    TableItem tableItem = table.getItem(pt);
                    if (tableItem != null) {
                        i = 0;
                        while (i < table.getColumnCount()) {
                            if (tableItem.getBounds(i).contains(pt)) {
                                column = i;
                                ToolTipHandler.this.bounds = tableItem.getBounds(column);
                            }
                            ++i;
                        }
                        item = tableItem;
                    }
                } else if (widget instanceof Tree && (treeItem = (tree = (Tree)widget).getItem(pt)) != null) {
                    i = 0;
                    while (i < tree.getColumnCount()) {
                        if (treeItem.getBounds(i).contains(pt)) {
                            column = i;
                            ToolTipHandler.this.bounds = treeItem.getBounds(column);
                        }
                        ++i;
                    }
                    item = treeItem;
                }
                if (item == null) {
                    ToolTipHandler.this.deactivate();
                    return;
                }
                if (item == ToolTipHandler.this.tipWidget) {
                    return;
                }
                Object data = item.getData();
                String text = ToolTipHandler.this.getHoverText(data, column);
                Image image = ToolTipHandler.this.getHoverImage(data, column);
                if (text == null && image == null) {
                    return;
                }
                ToolTipHandler.this.tipWidget = (Widget)item;
                ToolTipHandler.this.tipLabelText.setText(text != null ? text : "");
                ToolTipHandler.this.tipLabelImage.setImage(image);
                ToolTipHandler.this.tipShell.pack();
                ToolTipHandler.this.tipPosition = ToolTipHandler.this.control.toDisplay(pt);
                ToolTipHandler.this.setHoverLocation(ToolTipHandler.this.tipShell, ToolTipHandler.this.tipPosition);
                ToolTipHandler.this.tipShell.setVisible(true);
                ToolTipHandler.this.control.addMouseMoveListener(ToolTipHandler.this.moveMouse);
            }
        });
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolTipHandler.this.deactivate();
                ToolTipHandler.this.tipShell.dispose();
            }
        });
    }

    protected void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = Math.max(Math.min(position.x, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }

    protected void deactivate() {
        if (!this.tipShell.isDisposed() && this.tipShell.isVisible()) {
            this.tipShell.setVisible(false);
        }
        this.tipWidget = null;
        this.control.removeMouseMoveListener(this.moveMouse);
    }

    public String getHoverText(Object object, int column) {
        return null;
    }

    public Image getHoverImage(Object object, int column) {
        return null;
    }
}

