/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.testcase.util;

import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.data.util.AbstractFillDataStructureVisitor;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.core.model.xml.testcase.Argument;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testcase.util.TestcaseElementMigrationInfo;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class TestcaseFillDataStructureVisitor
extends AbstractFillDataStructureVisitor {
    private final Argument testcaseArgument;
    private Testcase[] siblingTestcases;
    private Pattern argumentIndexPatter;

    public TestcaseFillDataStructureVisitor(com.savvytest.eclipse.core.model.xml.iface.Argument interfaceArgument, java.lang.String prefix, TestcaseElementMigrationInfo info, Argument testcaseArgument) {
        super(interfaceArgument, prefix, info);
        this.testcaseArgument = testcaseArgument;
        this.init();
    }

    public TestcaseFillDataStructureVisitor(com.savvytest.eclipse.core.model.xml.iface.Argument interfaceArgument, Argument testcaseArgument) {
        this(interfaceArgument, null, null, testcaseArgument);
    }

    @Override
    protected void init() {
        super.init();
        this.argumentIndexPatter = Pattern.compile("arg([0-9]+)");
    }

    @Override
    public Object visit(Array array) throws Exception {
        Object returnValue = super.visit(array);
        if (array.getPersistentData() != null && PropertiesUtils.hasProperty(array.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION)) {
            this.setVolatileAssignation(array);
        }
        return returnValue;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        Object returnValue = super.visit(struct);
        if (struct.getPersistentData() != null && PropertiesUtils.hasProperty(struct.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION)) {
            this.setVolatileAssignation(struct);
        }
        return returnValue;
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        Object returnValue = super.visit(bool);
        if (bool.getPersistentData() != null && PropertiesUtils.hasProperty(bool.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION)) {
            this.setVolatileAssignation(bool);
        }
        return returnValue;
    }

    @Override
    public Object visit(Number number) throws Exception {
        Object returnValue = super.visit(number);
        if (number.getPersistentData() != null && PropertiesUtils.hasProperty(number.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION)) {
            this.setVolatileAssignation(number);
        }
        return returnValue;
    }

    @Override
    public Object visit(String string) throws Exception {
        Object returnValue = super.visit(string);
        if (string.getPersistentData() != null && PropertiesUtils.hasProperty(string.getPersistentData().getProperties(), PropertiesUtils.PropertyEnum.ASSIGNATION)) {
            this.setVolatileAssignation(string);
        }
        return returnValue;
    }

    @Override
    protected EList<PersistentData> getPersistentDatas() {
        return this.testcaseArgument.getDatas();
    }

    private void setVolatileAssignation(Data data) {
        Properties properties = data.getPersistentData().getProperties();
        java.lang.String assignationID = PropertiesUtils.getPropertyValue(properties, PropertiesUtils.PropertyEnum.ASSIGNATION);
        java.lang.String[] tokenizedID = assignationID.split("\\.", 4);
        if (tokenizedID.length < 4) {
            System.err.println("Assignation ID is insufficient: " + assignationID);
            return;
        }
        java.lang.String testcaseName = tokenizedID[0];
        Testcase[] testcaseArray = this.getSiblingTestcases();
        int n = testcaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            Testcase testcase = testcaseArray[n2];
            if (testcase.getName().equals(testcaseName)) {
                Matcher matcher = this.argumentIndexPatter.matcher(tokenizedID[2]);
                if (matcher.matches()) {
                    int argumentIndex = Integer.parseInt(matcher.group(1));
                    if (argumentIndex < testcase.getInput().size()) {
                        java.lang.String persistentDataID = "input." + tokenizedID[2] + "." + tokenizedID[3];
                        for (PersistentData persistentData : ((Argument)testcase.getInput().get(argumentIndex)).getDatas()) {
                            if (!persistentDataID.equals(persistentData.getId())) continue;
                            data.setAssignationVolatileData(persistentData.getVolatileData());
                            break;
                        }
                        if (data.getAssignationVolatileData() != null) break;
                        System.err.println("Didn't find a persistent data element with id '" + persistentDataID + "' in argument " + argumentIndex + " in testcase '" + testcaseName + "'.");
                        break;
                    }
                    System.err.println("Assignation ID's argument index is out of bounds: " + assignationID);
                    break;
                }
                System.err.println("Assignation ID doesn't specify the argument index properly: " + assignationID);
                break;
            }
            ++n2;
        }
    }

    public void setSiblingTestcases(Testcase ... siblingTestcases) {
        this.siblingTestcases = siblingTestcases;
    }

    private Testcase[] getSiblingTestcases() {
        if (this.siblingTestcases != null) {
            return this.siblingTestcases;
        }
        Testcase testcase = null;
        EObject parent = this.testcaseArgument;
        while (parent != null && !(parent instanceof Testscenario)) {
            if (parent instanceof Testcase) {
                testcase = (Testcase)parent;
            }
            parent = parent.eContainer();
        }
        if (parent != null && testcase != null) {
            ArrayList<Testcase> siblingTestcases = new ArrayList<Testcase>();
            for (Testcase siblingTestcase : ((Testscenario)parent).getTestcases().getTestcases()) {
                if (testcase == siblingTestcase) break;
                siblingTestcases.add(siblingTestcase);
            }
            this.siblingTestcases = siblingTestcases.toArray(new Testcase[siblingTestcases.size()]);
        }
        return this.siblingTestcases;
    }
}

