/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IPropertyEditorFactory;
import org.osgi.framework.BundleActivator;

public final class EMFEditPlugin
extends EMFPlugin {
    public static final EMFEditPlugin INSTANCE = new EMFEditPlugin();
    private static Implementation plugin;
    private static ComposedAdapterFactory.Descriptor.Registry.Impl composedAdapterFactoryDescriptorRegistry;
    private static IChildCreationExtender.Descriptor.Registry.Impl childCreationExtenderDescriptorRegistry;
    private static PropertyEditorFactoryRegistryImpl propertyEditorFactoryRegistry;

    private EMFEditPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static ComposedAdapterFactory.Descriptor.Registry getComposedAdapterFactoryDescriptorRegistry() {
        if (composedAdapterFactoryDescriptorRegistry == null) {
            composedAdapterFactoryDescriptorRegistry = new ComposedAdapterFactory.Descriptor.Registry.Impl(null){
                private static final long serialVersionUID = 1L;

                @Override
                public ComposedAdapterFactory.Descriptor delegatedGetDescriptor(Collection<?> types) {
                    ArrayList<String> stringTypes = new ArrayList<String>(types.size());
                    for (Object key : types) {
                        if (key instanceof EPackage) {
                            stringTypes.add(((EPackage)key).getNsURI());
                            continue;
                        }
                        if (key instanceof Package) {
                            stringTypes.add(((Package)key).getName());
                            continue;
                        }
                        if (key instanceof Class) {
                            stringTypes.add(((Class)key).getName());
                            continue;
                        }
                        return null;
                    }
                    ComposedAdapterFactory.Descriptor descriptor = (ComposedAdapterFactory.Descriptor)this.get(stringTypes);
                    if (descriptor != null) {
                        this.put(types, descriptor);
                        return descriptor;
                    }
                    return super.delegatedGetDescriptor(types);
                }
            };
            if (INSTANCE.getPluginResourceLocator() instanceof EMFPlugin.EclipsePlugin) {
                RegistryReader registryReader = new RegistryReader(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), "itemProviderAdapterFactories"){

                    protected boolean readElement(IConfigurationElement element, boolean add) {
                        if (element.getName().equals("factory")) {
                            String packageURI = element.getAttribute("uri");
                            String className = element.getAttribute("class");
                            String supportedTypes = element.getAttribute("supportedTypes");
                            if (packageURI == null) {
                                this.logMissingAttribute(element, "uri");
                            } else if (className == null) {
                                this.logMissingAttribute(element, "class");
                            } else if (supportedTypes == null) {
                                this.logMissingAttribute(element, "supportedTypes");
                            }
                            StringTokenizer stringTokenizer = new StringTokenizer(supportedTypes);
                            while (stringTokenizer.hasMoreTokens()) {
                                String supportedType = stringTokenizer.nextToken();
                                ArrayList<String> key = new ArrayList<String>();
                                key.add(packageURI);
                                key.add(supportedType);
                                if (add) {
                                    class PluginAdapterFactoryDescriptor
                                    extends RegistryReader.PluginClassDescriptor
                                    implements ComposedAdapterFactory.Descriptor {
                                        public PluginAdapterFactoryDescriptor(IConfigurationElement element, String attributeName) {
                                            super(element, attributeName);
                                        }

                                        public AdapterFactory createAdapterFactory() {
                                            return (AdapterFactory)this.createInstance();
                                        }
                                    }
                                    composedAdapterFactoryDescriptorRegistry.put(key, new PluginAdapterFactoryDescriptor(element, "class"));
                                    continue;
                                }
                                composedAdapterFactoryDescriptorRegistry.remove(key);
                            }
                            return true;
                        }
                        return false;
                    }
                };
                registryReader.readRegistry();
            }
        }
        return composedAdapterFactoryDescriptorRegistry;
    }

    public static IChildCreationExtender.Descriptor.Registry getChildCreationExtenderDescriptorRegistry() {
        if (childCreationExtenderDescriptorRegistry == null) {
            childCreationExtenderDescriptorRegistry = new IChildCreationExtender.Descriptor.Registry.Impl(null){
                private static final long serialVersionUID = 1L;

                @Override
                public Collection<IChildCreationExtender.Descriptor> delegatedGetDescriptors(String namespace) {
                    Collection<IChildCreationExtender.Descriptor> descriptors = (Collection<IChildCreationExtender.Descriptor>)this.get(namespace);
                    return descriptors != null ? descriptors : super.delegatedGetDescriptors(namespace);
                }
            };
            if (INSTANCE.getPluginResourceLocator() instanceof EMFPlugin.EclipsePlugin) {
                RegistryReader registryReader = new RegistryReader(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), "childCreationExtenders"){

                    protected boolean readElement(IConfigurationElement element, boolean add) {
                        if (element.getName().equals("extender")) {
                            String packageURI = element.getAttribute("uri");
                            String className = element.getAttribute("class");
                            if (packageURI == null) {
                                this.logMissingAttribute(element, "uri");
                            } else if (className == null) {
                                this.logMissingAttribute(element, "class");
                            }
                            class PluginChildCreationExtenderDescriptor
                            extends RegistryReader.PluginClassDescriptor
                            implements IChildCreationExtender.Descriptor {
                                protected String contributor;

                                public PluginChildCreationExtenderDescriptor(IConfigurationElement element, String attributeName) {
                                    super(element, attributeName);
                                    this.contributor = element.getContributor().getName();
                                }

                                public IChildCreationExtender createChildCreationExtender() {
                                    return (IChildCreationExtender)this.createInstance();
                                }

                                public boolean matches(IConfigurationElement element) {
                                    return element.getContributor().getName().equals(this.contributor);
                                }
                            }
                            ArrayList<PluginChildCreationExtenderDescriptor> collection = (ArrayList<PluginChildCreationExtenderDescriptor>)childCreationExtenderDescriptorRegistry.get(packageURI);
                            if (add) {
                                if (collection == null) {
                                    collection = new ArrayList<PluginChildCreationExtenderDescriptor>();
                                    childCreationExtenderDescriptorRegistry.put(packageURI, collection);
                                }
                                collection.add(new PluginChildCreationExtenderDescriptor(element, "class"));
                            } else if (collection != null) {
                                for (IChildCreationExtender.Descriptor descriptor : collection) {
                                    if (!(descriptor instanceof PluginChildCreationExtenderDescriptor) || !((PluginChildCreationExtenderDescriptor)descriptor).matches(element)) continue;
                                    collection.remove(descriptor);
                                    break;
                                }
                            }
                            return true;
                        }
                        return false;
                    }
                };
                registryReader.readRegistry();
            }
        }
        return childCreationExtenderDescriptorRegistry;
    }

    public static IPropertyEditorFactory.Registry getPropertyEditorFactoryRegistry() {
        if (propertyEditorFactoryRegistry == null) {
            propertyEditorFactoryRegistry = new PropertyEditorFactoryRegistryImpl();
            if (INSTANCE.getPluginResourceLocator() instanceof EMFPlugin.EclipsePlugin) {
                RegistryReader registryReader = new RegistryReader(Platform.getExtensionRegistry(), INSTANCE.getSymbolicName(), "propertyEditorFactories"){

                    protected boolean readElement(IConfigurationElement element, boolean add) {
                        if (element.getName().equals("factory")) {
                            String propertyEditorFactoryValue = element.getAttribute("uri");
                            String className = element.getAttribute("class");
                            if (propertyEditorFactoryValue == null) {
                                this.logMissingAttribute(element, "uri");
                            } else if (className == null) {
                                this.logMissingAttribute(element, "class");
                            }
                            if (propertyEditorFactoryValue != null && className != null) {
                                URI propertyEditorFactoryURI = URI.createURI(propertyEditorFactoryValue);
                                Object propertyEditorFactoryDescriptor = propertyEditorFactoryRegistry.get(propertyEditorFactoryURI);
                                if (add) {
                                    class PluginPropertyEditorFactoryDescriptor
                                    extends RegistryReader.PluginClassDescriptor
                                    implements IPropertyEditorFactory.Descriptor {
                                        public PluginPropertyEditorFactoryDescriptor(IConfigurationElement element) {
                                            super(element, "class");
                                        }

                                        public IPropertyEditorFactory getPropertyEditorFactory() {
                                            return (IPropertyEditorFactory)this.createInstance();
                                        }

                                        public IConfigurationElement getElement() {
                                            return this.element;
                                        }
                                    }
                                    PluginPropertyEditorFactoryDescriptor previous = propertyEditorFactoryRegistry.put(propertyEditorFactoryURI, new PluginPropertyEditorFactoryDescriptor(element));
                                    if (previous instanceof PluginPropertyEditorFactoryDescriptor) {
                                        PluginPropertyEditorFactoryDescriptor descriptor = previous;
                                        INSTANCE.log("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a property editor factory for '" + propertyEditorFactoryURI + "'");
                                    }
                                } else if (propertyEditorFactoryDescriptor != null) {
                                    propertyEditorFactoryRegistry.remove(propertyEditorFactoryURI);
                                }
                                return true;
                            }
                        }
                        return false;
                    }
                };
                registryReader.readRegistry();
            }
        }
        return propertyEditorFactoryRegistry;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public static class Activator
        extends EMFPlugin.OSGiDelegatingBundleActivator {
            protected BundleActivator createBundle() {
                return new Implementation();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PropertyEditorFactoryRegistryImpl
    extends CommonPlugin.SimpleTargetPlatformRegistryImpl<URI, Object>
    implements IPropertyEditorFactory.Registry {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<URI> getTargetPlatformFactories() {
            return this.getTargetPlatformValues("org.eclipse.emf.edit.propertyEditorFactories", "uri");
        }

        @Override
        protected URI createKey(String attribute) {
            return URI.createURI(attribute);
        }

        protected IPropertyEditorFactory basicGetPropertyEditorFactory(Object key) {
            Object propertyEditorFactory = super.get(key);
            if (propertyEditorFactory instanceof IPropertyEditorFactory.Descriptor) {
                IPropertyEditorFactory.Descriptor propertyEditoFactoryDescriptor = (IPropertyEditorFactory.Descriptor)propertyEditorFactory;
                propertyEditorFactory = propertyEditoFactoryDescriptor.getPropertyEditorFactory();
                this.put((URI)key, propertyEditorFactory);
                return (IPropertyEditorFactory)propertyEditorFactory;
            }
            return (IPropertyEditorFactory)propertyEditorFactory;
        }

        @Override
        public IPropertyEditorFactory getPropertyEditorFactory(URI propertyEditorSpecification) {
            IPropertyEditorFactory result = null;
            if (propertyEditorSpecification != null) {
                URI baseURI = propertyEditorSpecification.trimQuery().trimFragment();
                int i = 0;
                int count = baseURI.segmentCount();
                while (i <= count && result == null) {
                    URI uri = baseURI.trimSegments(i);
                    result = this.basicGetPropertyEditorFactory(uri);
                    ++i;
                }
            }
            return result;
        }

        @Override
        public IPropertyEditorFactory getPropertyEditorFactory(Object propertyEditorSpecification) {
            if (propertyEditorSpecification instanceof URI) {
                return this.getPropertyEditorFactory((URI)propertyEditorSpecification);
            }
            if (propertyEditorSpecification instanceof IPropertyEditorFactory) {
                return (IPropertyEditorFactory)propertyEditorSpecification;
            }
            if (propertyEditorSpecification instanceof String) {
                return this.getPropertyEditorFactory(URI.createURI(propertyEditorSpecification.toString()));
            }
            return null;
        }
    }
}

