/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public final class ObservableSetContentProvider
implements IStructuredContentProvider {
    private IObservableSet readableSet;
    private Viewer viewer;
    private KnownElementsSet knownElements;
    private ISetChangeListener listener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            boolean wasStale = ObservableSetContentProvider.this.knownElements.isStale();
            if (ObservableSetContentProvider.this.isDisposed()) {
                return;
            }
            ObservableSetContentProvider.this.doDiff(event.diff.getAdditions(), event.diff.getRemovals(), true);
            if (!wasStale && event.getObservableSet().isStale()) {
                ObservableSetContentProvider.this.knownElements.doFireStale(true);
            }
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent event) {
            ObservableSetContentProvider.this.knownElements.doFireStale(event.getObservable().isStale());
        }
    };
    static /* synthetic */ Class class$0;

    public ObservableSetContentProvider() {
        Realm realm = SWTObservables.getRealm(Display.getDefault());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.readableSet = new ObservableSet(realm, Collections.EMPTY_SET, clazz){};
        this.knownElements = new KnownElementsSet(this, this.readableSet);
    }

    public void dispose() {
        this.setInput(null);
    }

    private void doDiff(Set added, Set removed, boolean updateViewer) {
        this.knownElements.doFireDiff(added, Collections.EMPTY_SET);
        if (updateViewer) {
            Object[] toAdd = added.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.add(toAdd);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.add(toAdd);
            }
            Object[] toRemove = removed.toArray();
            if (this.viewer instanceof TableViewer) {
                TableViewer tv = (TableViewer)this.viewer;
                tv.remove(toRemove);
            } else if (this.viewer instanceof AbstractListViewer) {
                AbstractListViewer lv = (AbstractListViewer)this.viewer;
                lv.remove(toRemove);
            }
        }
        this.knownElements.doFireDiff(Collections.EMPTY_SET, removed);
    }

    public Object[] getElements(Object inputElement) {
        return this.readableSet.toArray();
    }

    public IObservableSet getKnownElements() {
        return this.knownElements;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(viewer instanceof TableViewer) && !(viewer instanceof AbstractListViewer)) {
            Class<?> abstractTableViewerClass = null;
            try {
                abstractTableViewerClass = Class.forName("org.eclipse.jface.viewers.AbstractTableViewer");
            }
            catch (Exception exception) {}
            if (abstractTableViewerClass == null || !abstractTableViewerClass.isInstance(viewer)) {
                throw new IllegalArgumentException("This content provider only works with (Abstract)TableViewer or AbstractListViewer");
            }
        }
        if (newInput != null && !(newInput instanceof IObservableSet)) {
            throw new IllegalArgumentException("This content provider only works with input of type IReadableSet");
        }
        this.setInput((IObservableSet)newInput);
    }

    private boolean isDisposed() {
        return this.viewer.getControl() == null || this.viewer.getControl().isDisposed();
    }

    private void setInput(IObservableSet newSet) {
        boolean isStale;
        boolean updateViewer = true;
        if (newSet == null) {
            Realm realm = SWTObservables.getRealm(Display.getDefault());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            newSet = new ObservableSet(realm, Collections.EMPTY_SET, clazz){};
            updateViewer = false;
        }
        boolean wasStale = false;
        if (this.readableSet != null) {
            wasStale = this.readableSet.isStale();
            this.readableSet.removeSetChangeListener(this.listener);
            this.readableSet.removeStaleListener(this.staleListener);
        }
        HashSet additions = new HashSet();
        HashSet removals = new HashSet();
        additions.addAll(newSet);
        additions.removeAll(this.readableSet);
        removals.addAll(this.readableSet);
        removals.removeAll(newSet);
        this.readableSet = newSet;
        this.doDiff(additions, removals, updateViewer);
        if (this.readableSet != null) {
            this.readableSet.addSetChangeListener(this.listener);
            this.readableSet.addStaleListener(this.staleListener);
        }
        boolean bl = isStale = this.readableSet != null && this.readableSet.isStale();
        if (isStale != wasStale) {
            this.knownElements.doFireStale(isStale);
        }
    }

    private class KnownElementsSet
    extends ObservableSet {
        final /* synthetic */ ObservableSetContentProvider this$0;

        KnownElementsSet(ObservableSetContentProvider observableSetContentProvider, Set wrappedSet) {
            Realm realm = SWTObservables.getRealm(Display.getDefault());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            super(realm, wrappedSet, clazz);
            this.this$0 = observableSetContentProvider;
        }

        void doFireDiff(Set added, Set removed) {
            this.fireSetChange(Diffs.createSetDiff(added, removed));
        }

        void doFireStale(boolean isStale) {
            if (isStale) {
                this.fireStale();
            } else {
                this.fireChange();
            }
        }
    }
}

