/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.branding.IProductConstants;
import org.eclipse.ui.internal.BrandingProperties;

public class ProductProperties
extends BrandingProperties
implements IProductConstants {
    private final IProduct product;
    private String appName;
    private String aboutText;
    private ImageDescriptor aboutImageDescriptor;
    private ImageDescriptor[] windowImageDescriptors;
    private URL welcomePageUrl;
    private String productName;
    private String productId;
    private static final String ABOUT_MAPPINGS = "$nl$/about.mappings";
    private static String[] systemPropertiesKeys = new String[0];
    private static String[] mappings = ProductProperties.loadMappings();

    private static String[] loadMappings() {
        PropertyResourceBundle bundle;
        block21: {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return new String[0];
            }
            URL location = Platform.find(product.getDefiningBundle(), new Path(ABOUT_MAPPINGS));
            bundle = null;
            if (location != null) {
                InputStream is = null;
                try {
                    try {
                        is = location.openStream();
                        bundle = new PropertyResourceBundle(is);
                    }
                    catch (IOException iOException) {
                        bundle = null;
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block21;
                        }
                        catch (IOException iOException2) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        ArrayList<String> mappingsList = new ArrayList<String>();
        if (bundle != null) {
            boolean found = true;
            int i = 0;
            ArrayList<String> systemPropertiesKeysList = new ArrayList<String>();
            while (found) {
                try {
                    String nextString = bundle.getString(Integer.toString(i));
                    int length = nextString.length();
                    if (length > 2 && nextString.indexOf(36) == 0 && nextString.lastIndexOf(36) == length - 1) {
                        int newIndex = systemPropertiesKeysList.size();
                        systemPropertiesKeysList.add(nextString.substring(1, length - 1));
                        nextString = "{" + newIndex + "}";
                    }
                    mappingsList.add(nextString);
                }
                catch (MissingResourceException missingResourceException) {
                    found = false;
                }
                ++i;
            }
            systemPropertiesKeys = systemPropertiesKeysList.toArray(new String[systemPropertiesKeysList.size()]);
        }
        return mappingsList.toArray(new String[mappingsList.size()]);
    }

    public ProductProperties(IProduct product) {
        if (product == null) {
            throw new IllegalArgumentException();
        }
        this.product = product;
    }

    public String getAppName() {
        if (this.appName == null) {
            this.appName = ProductProperties.getAppName(this.product);
        }
        return this.appName;
    }

    public String getAboutText() {
        if (this.aboutText == null) {
            this.aboutText = ProductProperties.getAboutText(this.product);
        }
        return this.aboutText;
    }

    public ImageDescriptor getAboutImage() {
        if (this.aboutImageDescriptor == null) {
            this.aboutImageDescriptor = ProductProperties.getAboutImage(this.product);
        }
        return this.aboutImageDescriptor;
    }

    public ImageDescriptor[] getWindowImages() {
        if (this.windowImageDescriptors == null) {
            this.windowImageDescriptors = ProductProperties.getWindowImages(this.product);
        }
        return this.windowImageDescriptors;
    }

    public URL getWelcomePageUrl() {
        if (this.welcomePageUrl == null) {
            this.welcomePageUrl = ProductProperties.getWelcomePageUrl(this.product);
        }
        return this.welcomePageUrl;
    }

    public String getProductName() {
        if (this.productName == null) {
            this.productName = ProductProperties.getProductName(this.product);
        }
        return this.productName;
    }

    public String getProductId() {
        if (this.productId == null) {
            this.productId = ProductProperties.getProductId(this.product);
        }
        return this.productId;
    }

    public static String getAppName(IProduct product) {
        String property = product.getProperty("appName");
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        return MessageFormat.format((String)property, (Object[])mappings);
    }

    public static String getAboutText(IProduct product) {
        String property = product.getProperty("aboutText");
        if (property == null) {
            return "";
        }
        if (property.indexOf(123) == -1) {
            return property;
        }
        if ((property = MessageFormat.format((String)property, (Object[])mappings)).indexOf(123) == -1) {
            return property;
        }
        if (systemPropertiesKeys.length == 0) {
            return property;
        }
        Object[] systemPropertiesMappings = new String[systemPropertiesKeys.length];
        int i = 0;
        while (i < systemPropertiesKeys.length) {
            String systemProperty = systemPropertiesKeys[i];
            systemPropertiesMappings[i] = System.getProperty(systemProperty, "");
            ++i;
        }
        return MessageFormat.format((String)property, (Object[])systemPropertiesMappings);
    }

    public static ImageDescriptor getAboutImage(IProduct product) {
        return ProductProperties.getImage(product.getProperty("aboutImage"), product.getDefiningBundle());
    }

    public static ImageDescriptor[] getWindowImages(IProduct product) {
        String property = product.getProperty("windowImages");
        if (property == null) {
            property = product.getProperty("windowImage");
        }
        return ProductProperties.getImages(property, product.getDefiningBundle());
    }

    public static URL getWelcomePageUrl(IProduct product) {
        return ProductProperties.getUrl(product.getProperty("welcomePage"), product.getDefiningBundle());
    }

    public static String getProductName(IProduct product) {
        return product.getName();
    }

    public static String getProductId(IProduct product) {
        return product.getId();
    }
}

