/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;

class OverlayCache {
    private Set keys = new HashSet();
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(PlatformUI.getWorkbench().getDisplay()));

    private Image getImageFor(DecorationOverlayIcon icon) {
        this.keys.add(icon);
        return this.resourceManager.createImage(icon);
    }

    void disposeAll() {
        this.keys.clear();
        this.resourceManager.dispose();
    }

    Image applyDescriptors(Image source, ImageDescriptor[] descriptors) {
        Rectangle bounds = source.getBounds();
        Point size = new Point(bounds.width, bounds.height);
        DecorationOverlayIcon icon = new DecorationOverlayIcon(source, descriptors, size);
        return this.getImageFor(icon);
    }
}

