/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class TipsAndTricksAction
extends PartEventAction
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public TipsAndTricksAction(IWorkbenchWindow window) {
        super(IDEWorkbenchMessages.TipsAndTricks_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setToolTipText(IDEWorkbenchMessages.TipsAndTricks_toolTip);
        window.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.ide.tips_and_tricks_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.tipsAndTricksAction");
        this.workbenchWindow.getPartService().addPartListener(this);
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        AboutInfo[] featureInfos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        ArrayList<AboutInfo> tipsAndTricksFeatures = new ArrayList<AboutInfo>(featureInfos.length);
        int i = 0;
        while (i < featureInfos.length) {
            if (featureInfos[i].getTipsAndTricksHref() != null) {
                tipsAndTricksFeatures.add(featureInfos[i]);
            }
            ++i;
        }
        Shell shell = this.workbenchWindow.getShell();
        if (tipsAndTricksFeatures.size() == 0) {
            MessageDialog.openInformation(shell, IDEWorkbenchMessages.TipsAndTricksMessageDialog_title, IDEWorkbenchMessages.TipsAndTricksMessageDialog_message);
            return;
        }
        AboutInfo[] features = new AboutInfo[tipsAndTricksFeatures.size()];
        tipsAndTricksFeatures.toArray(features);
        IProduct product = Platform.getProduct();
        FeatureSelectionDialog d = new FeatureSelectionDialog(shell, features, product == null ? null : product.getId(), IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_title, IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_message, "org.eclipse.ui.ide.tips_and_tricks_page_selection_dialog");
        if (d.open() != 0 || d.getResult().length != 1) {
            return;
        }
        AboutInfo feature = (AboutInfo)d.getResult()[0];
        if (feature != null) {
            final String href = feature.getTipsAndTricksHref();
            if (href != null) {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        TipsAndTricksAction.this.workbenchWindow.getWorkbench().getHelpSystem().displayHelpResource(href);
                    }
                });
            } else {
                Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
                ErrorDialog.openError(shell, IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, status);
            }
        } else {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
            ErrorDialog.openError(shell, IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noFeatures, status);
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.getPartService().removePartListener(this);
        this.workbenchWindow = null;
    }
}

