/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildSetMenu;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.actions.QuickMenuAction;
import org.eclipse.ui.internal.ide.actions.RetargetActionWithDefault;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.eclipse.ui.menus.IMenuService;

public final class WorkbenchActionBuilder
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction newEditorAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction workbookEditorsAction;
    private ActionFactory.IWorkbenchAction quickAccessAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction revertAction;
    private ActionFactory.IWorkbenchAction refreshAction;
    private ActionFactory.IWorkbenchAction propertiesAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction moveAction;
    private ActionFactory.IWorkbenchAction renameAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private ActionFactory.IWorkbenchAction newWizardAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    ActionFactory.IWorkbenchAction buildAllAction;
    private ActionFactory.IWorkbenchAction cleanAction;
    private ActionFactory.IWorkbenchAction toggleAutoBuildAction;
    MenuManager buildWorkingSetMenu;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private QuickMenuAction showInQuickMenu;
    private QuickMenuAction newQuickMenu;
    private ActionFactory.IWorkbenchAction introAction;
    private ActionFactory.IWorkbenchAction addBookmarkAction;
    private ActionFactory.IWorkbenchAction addTaskAction;
    ActionFactory.IWorkbenchAction buildProjectAction;
    private ActionFactory.IWorkbenchAction openProjectAction;
    private ActionFactory.IWorkbenchAction closeProjectAction;
    private NewWizardMenu newWizardMenu;
    private IContributionItem pinEditorContributionItem;
    private StatusLineContributionItem statusLineItem;
    private Preferences.IPropertyChangeListener prefListener;
    private IPropertyChangeListener propPrefListener;
    private IPageListener pageListener;
    private IResourceChangeListener resourceListener;
    private boolean isDisposed = false;
    private MenuManager coolbarPopupMenuManager;
    static /* synthetic */ Class class$0;

    public WorkbenchActionBuilder(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
                BuildAction buildHandler = new BuildAction(page.getWorkbenchWindow().getShell(), 10);
                ((RetargetActionWithDefault)WorkbenchActionBuilder.this.buildProjectAction).setDefaultHandler(buildHandler);
            }
        };
        this.getWindow().addPageListener(this.pageListener);
        this.prefListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (event.getProperty().equals("description.autobuilding")) {
                    WorkbenchActionBuilder.this.updateBuildActions(false);
                }
            }
        };
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.prefListener);
        this.propPrefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && WorkbenchActionBuilder.this.window.getShell() != null && !WorkbenchActionBuilder.this.window.getShell().isDisposed()) {
                    WorkbenchActionBuilder.this.window.getShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            3.access$0(this.this$1).updatePinActionToolbar();
                        }
                    });
                }
            }

            static /* synthetic */ WorkbenchActionBuilder access$0(3 var0) {
                return var0.WorkbenchActionBuilder.this;
            }
        };
        WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propPrefListener);
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                IResourceDelta[] projectDeltas = delta.getAffectedChildren();
                int i = 0;
                while (i < projectDeltas.length) {
                    boolean changed;
                    int kind = projectDeltas[i].getKind();
                    boolean bl = changed = (projectDeltas[i].getFlags() & 0x84000) != 0;
                    if (kind != 4 || changed) {
                        WorkbenchActionBuilder.this.updateBuildActions(false);
                        return;
                    }
                    ++i;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    public void fillActionBars(int flags) {
        super.fillActionBars(flags);
        if ((flags & 1) == 0) {
            this.updateBuildActions(true);
            this.hookListeners();
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        IActionBarConfigurer2 actionBarConfigurer = (IActionBarConfigurer2)this.getActionBarConfigurer();
        this.coolbarPopupMenuManager = new MenuManager();
        this.coolbarPopupMenuManager.add(new ActionContributionItem(this.lockToolBarAction));
        this.coolbarPopupMenuManager.add(new ActionContributionItem(this.editActionSetAction));
        coolBar.setContextMenuManager(this.coolbarPopupMenuManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)this.window.getService(clazz);
        menuService.populateContributionManager(this.coolbarPopupMenuManager, "popup:windowCoolbarContextMenu");
        coolBar.add(new GroupMarker("group.file"));
        IToolBarManager fileToolBar = actionBarConfigurer.createToolBarManager();
        fileToolBar.add(new Separator("new.group"));
        fileToolBar.add(this.newWizardDropDownAction);
        fileToolBar.add(new GroupMarker("new.ext"));
        fileToolBar.add(new GroupMarker("save.group"));
        fileToolBar.add(this.saveAction);
        fileToolBar.add(new GroupMarker("save.ext"));
        fileToolBar.add(this.printAction);
        fileToolBar.add(new GroupMarker("print.ext"));
        fileToolBar.add(new Separator("build.group"));
        fileToolBar.add(new GroupMarker("build.ext"));
        fileToolBar.add(new Separator("additions"));
        coolBar.add(actionBarConfigurer.createToolBarContributionItem(fileToolBar, "org.eclipse.ui.workbench.file"));
        coolBar.add(new GroupMarker("additions"));
        coolBar.add(new GroupMarker("group.nav"));
        IToolBarManager navToolBar = actionBarConfigurer.createToolBarManager();
        navToolBar.add(new Separator("history.group"));
        navToolBar.add(new GroupMarker("group.application"));
        navToolBar.add(this.backwardHistoryAction);
        navToolBar.add(this.forwardHistoryAction);
        navToolBar.add(new Separator("pin.group"));
        navToolBar.add(this.pinEditorContributionItem);
        coolBar.add(actionBarConfigurer.createToolBarContributionItem(navToolBar, "org.eclipse.ui.workbench.navigate"));
        coolBar.add(new GroupMarker("group.editor"));
        coolBar.add(new GroupMarker("group.help"));
        IToolBarManager helpToolBar = actionBarConfigurer.createToolBarManager();
        helpToolBar.add(new Separator("group.help"));
        helpToolBar.add(new GroupMarker("group.application"));
        coolBar.add(actionBarConfigurer.createToolBarContributionItem(helpToolBar, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createNavigateMenu());
        menuBar.add(this.createProjectMenu());
        menuBar.add(new GroupMarker("additions"));
        menuBar.add(this.createWindowMenu());
        menuBar.add(this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        menu.add(new GroupMarker("fileStart"));
        String newText = IDEWorkbenchMessages.Workbench_new;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId){

            public String getMenuText() {
                String result = super.getMenuText();
                if (WorkbenchActionBuilder.this.newQuickMenu == null) {
                    return result;
                }
                String shortCut = WorkbenchActionBuilder.this.newQuickMenu.getShortCutString();
                if (shortCut == null) {
                    return result;
                }
                return String.valueOf(result) + "\t" + shortCut;
            }
        };
        newMenu.add(new Separator(newId));
        this.newWizardMenu = new NewWizardMenu(this.getWindow());
        newMenu.add(this.newWizardMenu);
        newMenu.add(new Separator("additions"));
        menu.add(newMenu);
        menu.add(new GroupMarker("new.ext"));
        menu.add(new Separator());
        menu.add(this.closeAction);
        menu.add(this.closeAllAction);
        menu.add(new GroupMarker("close.ext"));
        menu.add(new Separator());
        menu.add(this.saveAction);
        menu.add(this.saveAsAction);
        menu.add(this.saveAllAction);
        menu.add(this.revertAction);
        menu.add(new Separator());
        menu.add(this.moveAction);
        menu.add(this.renameAction);
        menu.add(this.refreshAction);
        menu.add(new GroupMarker("save.ext"));
        menu.add(new Separator());
        menu.add(this.printAction);
        menu.add(new GroupMarker("print.ext"));
        menu.add(new Separator());
        menu.add(this.openWorkspaceAction);
        menu.add(new GroupMarker("open.ext"));
        menu.add(new Separator());
        menu.add(this.importResourcesAction);
        menu.add(this.exportResourcesAction);
        menu.add(new GroupMarker("import.ext"));
        menu.add(new Separator("additions"));
        menu.add(new Separator());
        menu.add(this.propertiesAction);
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menu.add(new GroupMarker("mru"));
        menu.add(new Separator());
        ActionContributionItem quitItem = new ActionContributionItem(this.quitAction);
        quitItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add(quitItem);
        menu.add(new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        menu.add(new GroupMarker("editStart"));
        menu.add(this.undoAction);
        menu.add(this.redoAction);
        menu.add(new GroupMarker("undo.ext"));
        menu.add(new Separator());
        menu.add(this.cutAction);
        menu.add(this.copyAction);
        menu.add(this.pasteAction);
        menu.add(new GroupMarker("cut.ext"));
        menu.add(new Separator());
        menu.add(this.deleteAction);
        menu.add(this.selectAllAction);
        menu.add(new Separator());
        menu.add(this.findAction);
        menu.add(new GroupMarker("find.ext"));
        menu.add(new Separator());
        menu.add(this.addBookmarkAction);
        menu.add(this.addTaskAction);
        menu.add(new GroupMarker("add.ext"));
        menu.add(new GroupMarker("editEnd"));
        menu.add(new Separator("additions"));
        return menu;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_navigate, "navigate");
        menu.add(new GroupMarker("navStart"));
        menu.add(this.goIntoAction);
        MenuManager goToSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_goTo, "goTo");
        menu.add(goToSubMenu);
        goToSubMenu.add(this.backAction);
        goToSubMenu.add(this.forwardAction);
        goToSubMenu.add(this.upAction);
        goToSubMenu.add(new Separator("additions"));
        menu.add(new Separator("open.ext"));
        int i = 2;
        while (i < 5) {
            menu.add(new Separator("open.ext" + i));
            ++i;
        }
        menu.add(new Separator("show.ext"));
        MenuManager showInSubMenu = new MenuManager(IDEWorkbenchMessages.Workbench_showIn, "showIn"){

            public String getMenuText() {
                String result = super.getMenuText();
                if (WorkbenchActionBuilder.this.showInQuickMenu == null) {
                    return null;
                }
                String shortCut = WorkbenchActionBuilder.this.showInQuickMenu.getShortCutString();
                if (shortCut == null) {
                    return result;
                }
                return String.valueOf(result) + "\t" + shortCut;
            }
        };
        showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getWindow()));
        menu.add(showInSubMenu);
        i = 2;
        while (i < 5) {
            menu.add(new Separator("show.ext" + i));
            ++i;
        }
        menu.add(new Separator());
        menu.add(this.nextAction);
        menu.add(this.previousAction);
        menu.add(new Separator("additions"));
        menu.add(new GroupMarker("navEnd"));
        menu.add(new Separator());
        menu.add(this.backwardHistoryAction);
        menu.add(this.forwardHistoryAction);
        return menu;
    }

    private MenuManager createProjectMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_project, "project");
        menu.add(new Separator("projStart"));
        menu.add(this.openProjectAction);
        menu.add(this.closeProjectAction);
        menu.add(new GroupMarker("open.ext"));
        menu.add(new Separator());
        menu.add(this.buildAllAction);
        menu.add(this.buildProjectAction);
        this.addWorkingSetBuildActions(menu);
        menu.add(this.cleanAction);
        menu.add(this.toggleAutoBuildAction);
        menu.add(new GroupMarker("build.ext"));
        menu.add(new Separator());
        menu.add(new GroupMarker("additions"));
        menu.add(new GroupMarker("projEnd"));
        menu.add(new Separator());
        menu.add(this.projectPropertyDialogAction);
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_window, "window");
        menu.add(this.newWindowAction);
        menu.add(this.newEditorAction);
        menu.add(new Separator());
        this.addPerspectiveActions(menu);
        menu.add(new Separator());
        this.addKeyboardShortcuts(menu);
        menu.add(new Separator("additions"));
        ActionContributionItem openPreferencesItem = new ActionContributionItem(this.openPreferencesAction);
        openPreferencesItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add(openPreferencesItem);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        String openText = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager changePerspMenuMgr = new MenuManager(openText, "openPerspective");
        IContributionItem changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        changePerspMenuMgr.add(changePerspMenuItem);
        menu.add(changePerspMenuMgr);
        MenuManager showViewMenuMgr = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add(showViewMenuMgr);
        menu.add(new Separator());
        menu.add(this.editActionSetAction);
        menu.add(this.savePerspectiveAction);
        menu.add(this.resetPerspectiveAction);
        menu.add(this.closePerspAction);
        menu.add(this.closeAllPerspsAction);
    }

    private void addWorkingSetBuildActions(MenuManager menu) {
        this.buildWorkingSetMenu = new MenuManager(IDEWorkbenchMessages.Workbench_buildSet);
        BuildSetMenu workingSetBuilds = new BuildSetMenu(this.window, this.getActionBarConfigurer());
        this.buildWorkingSetMenu.add(workingSetBuilds);
        menu.add(this.buildWorkingSetMenu);
    }

    private void addKeyboardShortcuts(MenuManager menu) {
        MenuManager subMenu = new MenuManager(IDEWorkbenchMessages.Workbench_shortcuts, "shortcuts");
        menu.add(subMenu);
        subMenu.add(this.showPartPaneMenuAction);
        subMenu.add(this.showViewMenuAction);
        subMenu.add(this.quickAccessAction);
        subMenu.add(new Separator());
        subMenu.add(this.maximizePartAction);
        subMenu.add(this.minimizePartAction);
        subMenu.add(new Separator());
        subMenu.add(this.activateEditorAction);
        subMenu.add(this.nextEditorAction);
        subMenu.add(this.prevEditorAction);
        subMenu.add(this.switchToEditorAction);
        subMenu.add(new Separator());
        subMenu.add(this.nextPartAction);
        subMenu.add(this.prevPartAction);
        subMenu.add(new Separator());
        subMenu.add(this.nextPerspectiveAction);
        subMenu.add(this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(IDEWorkbenchMessages.Workbench_help, "help");
        this.addSeparatorOrGroupMarker(menu, "group.intro");
        if (this.introAction != null) {
            menu.add(this.introAction);
        } else if (this.quickStartAction != null) {
            menu.add(this.quickStartAction);
        }
        menu.add(new GroupMarker("group.intro.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.main");
        menu.add(this.helpContentsAction);
        menu.add(this.helpSearchAction);
        menu.add(this.dynamicHelpAction);
        this.addSeparatorOrGroupMarker(menu, "group.assist");
        if (this.tipsAndTricksAction != null) {
            menu.add(this.tipsAndTricksAction);
        }
        menu.add(new GroupMarker("helpStart"));
        menu.add(new GroupMarker("group.main.ext"));
        this.addSeparatorOrGroupMarker(menu, "group.tutorials");
        this.addSeparatorOrGroupMarker(menu, "group.tools");
        this.addSeparatorOrGroupMarker(menu, "group.updates");
        menu.add(new GroupMarker("helpEnd"));
        this.addSeparatorOrGroupMarker(menu, "additions");
        menu.add(new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem(this.aboutAction);
        aboutItem.setVisible(!"carbon".equals(SWT.getPlatform()));
        menu.add(aboutItem);
        menu.add(new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addSeparatorOrGroupMarker(MenuManager menu, String groupId) {
        String prefId = "useSeparator." + menu.getId() + "." + groupId;
        boolean addExtraSeparators = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(prefId);
        if (addExtraSeparators) {
            menu.add(new Separator(groupId));
        } else {
            menu.add(new GroupMarker(groupId));
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService menuService = (IMenuService)this.window.getService(clazz);
        menuService.releaseContributions(this.coolbarPopupMenuManager);
        this.coolbarPopupMenuManager.dispose();
        this.getActionBarConfigurer().getStatusLineManager().remove(this.statusLineItem);
        if (this.pageListener != null) {
            this.window.removePageListener(this.pageListener);
            this.pageListener = null;
        }
        if (this.prefListener != null) {
            ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        if (this.propPrefListener != null) {
            WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propPrefListener);
            this.propPrefListener = null;
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resourceListener = null;
        }
        this.pinEditorContributionItem.dispose();
        this.showInQuickMenu.dispose();
        this.newQuickMenu.dispose();
        this.closeAction = null;
        this.closeAllAction = null;
        this.closeAllSavedAction = null;
        this.closeOthersAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.newWindowAction = null;
        this.newEditorAction = null;
        this.helpContentsAction = null;
        this.helpSearchAction = null;
        this.dynamicHelpAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.saveAsAction = null;
        this.hideShowEditorAction = null;
        this.savePerspectiveAction = null;
        this.resetPerspectiveAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.lockToolBarAction = null;
        this.closeAllPerspsAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.activateEditorAction = null;
        this.maximizePartAction = null;
        this.minimizePartAction = null;
        this.switchToEditorAction = null;
        this.quickAccessAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.cutAction = null;
        this.copyAction = null;
        this.pasteAction = null;
        this.deleteAction = null;
        this.selectAllAction = null;
        this.findAction = null;
        this.printAction = null;
        this.revertAction = null;
        this.refreshAction = null;
        this.propertiesAction = null;
        this.quitAction = null;
        this.moveAction = null;
        this.renameAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.openWorkspaceAction = null;
        this.projectPropertyDialogAction = null;
        this.newWizardAction = null;
        this.newWizardDropDownAction = null;
        this.importResourcesAction = null;
        this.exportResourcesAction = null;
        this.buildAllAction = null;
        this.cleanAction = null;
        this.toggleAutoBuildAction = null;
        this.buildWorkingSetMenu = null;
        this.quickStartAction = null;
        this.tipsAndTricksAction = null;
        this.showInQuickMenu = null;
        this.newQuickMenu = null;
        this.addBookmarkAction = null;
        this.addTaskAction = null;
        this.buildProjectAction = null;
        this.openProjectAction = null;
        this.closeProjectAction = null;
        this.newWizardMenu = null;
        this.pinEditorContributionItem = null;
        this.statusLineItem = null;
        this.prefListener = null;
        this.propPrefListener = null;
        this.introAction = null;
        super.dispose();
    }

    void updateModeLine(String text) {
        this.statusLineItem.setText(text);
    }

    public boolean isApplicationMenu(String menuId) {
        if (menuId.equals("file")) {
            return true;
        }
        return menuId.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String id) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(id)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(id);
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        statusLine.add(this.statusLineItem);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.newWizardAction = ActionFactory.NEW.create(window);
        this.register(this.newWizardAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(window);
        this.register(this.newWizardDropDownAction);
        this.importResourcesAction = ActionFactory.IMPORT.create(window);
        this.register(this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(window);
        this.register(this.exportResourcesAction);
        this.buildAllAction = IDEActionFactory.BUILD.create(window);
        this.register(this.buildAllAction);
        this.cleanAction = IDEActionFactory.BUILD_CLEAN.create(window);
        this.register(this.cleanAction);
        this.toggleAutoBuildAction = IDEActionFactory.BUILD_AUTOMATICALLY.create(window);
        this.register(this.toggleAutoBuildAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register(this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.register(this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register(this.saveAllAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText(IDEWorkbenchMessages.Workbench_openNewWindow);
        this.register(this.newWindowAction);
        this.newEditorAction = ActionFactory.NEW_EDITOR.create(window);
        this.register(this.newEditorAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register(this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register(this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register(this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register(this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register(this.pasteAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register(this.printAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register(this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register(this.findAction);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register(this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register(this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(window);
        this.register(this.closeOthersAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(window);
        this.register(this.closeAllSavedAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register(this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register(this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register(this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.register(this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register(this.openPreferencesAction);
        this.addBookmarkAction = IDEActionFactory.BOOKMARK.create(window);
        this.register(this.addBookmarkAction);
        this.addTaskAction = IDEActionFactory.ADD_TASK.create(window);
        this.register(this.addTaskAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register(this.deleteAction);
        this.makeFeatureDependentActions(window);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(window);
        this.register(this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(window);
        this.register(this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(window);
        this.register(this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(window);
        this.register(this.prevEditorAction);
        ActionFactory.linkCycleActionPair(this.nextEditorAction, this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(window);
        this.register(this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(window);
        this.register(this.prevPartAction);
        ActionFactory.linkCycleActionPair(this.nextPartAction, this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(window);
        this.register(this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(window);
        this.register(this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair(this.nextPerspectiveAction, this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(window);
        this.register(this.activateEditorAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(window);
        this.register(this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(window);
        this.register(this.minimizePartAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(window);
        this.register(this.switchToEditorAction);
        this.workbookEditorsAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(window);
        this.register(this.workbookEditorsAction);
        this.quickAccessAction = ActionFactory.SHOW_QUICK_ACCESS.create(window);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(window);
        this.register(this.hideShowEditorAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(window);
        this.register(this.savePerspectiveAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register(this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(window);
        this.register(this.lockToolBarAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(window);
        this.register(this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(window);
        this.register(this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(window);
        this.register(this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(window);
        this.register(this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(window);
        this.register(this.backwardHistoryAction);
        this.revertAction = ActionFactory.REVERT.create(window);
        this.register(this.revertAction);
        this.refreshAction = ActionFactory.REFRESH.create(window);
        this.register(this.refreshAction);
        this.propertiesAction = ActionFactory.PROPERTIES.create(window);
        this.register(this.propertiesAction);
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register(this.quitAction);
        this.moveAction = ActionFactory.MOVE.create(window);
        this.register(this.moveAction);
        this.renameAction = ActionFactory.RENAME.create(window);
        this.register(this.renameAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(window);
        this.register(this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(window);
        this.register(this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(window);
        this.register(this.forwardAction);
        this.upAction = ActionFactory.UP.create(window);
        this.register(this.upAction);
        this.nextAction = ActionFactory.NEXT.create(window);
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_NEXT_NAV"));
        this.register(this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(window);
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_PREVIOUS_NAV"));
        this.register(this.previousAction);
        this.buildProjectAction = IDEActionFactory.BUILD_PROJECT.create(window);
        this.register(this.buildProjectAction);
        this.openProjectAction = IDEActionFactory.OPEN_PROJECT.create(window);
        this.register(this.openProjectAction);
        this.closeProjectAction = IDEActionFactory.CLOSE_PROJECT.create(window);
        this.register(this.closeProjectAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(window);
        this.register(this.openWorkspaceAction);
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(window);
        this.register(this.projectPropertyDialogAction);
        if (window.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register(this.introAction);
        }
        String showInQuickMenuId = "org.eclipse.ui.navigate.showInQuickMenu";
        this.showInQuickMenu = new QuickMenuAction(showInQuickMenuId){

            protected void fillMenu(IMenuManager menu) {
                menu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(window));
            }
        };
        this.register(this.showInQuickMenu);
        this.newQuickMenu = new QuickMenuAction("org.eclipse.ui.file.newQuickMenu"){

            protected void fillMenu(IMenuManager menu) {
                menu.add(new NewWizardMenu(window));
            }
        };
        this.register(this.newQuickMenu);
        this.pinEditorContributionItem = ContributionItemFactory.PIN_EDITOR.create(window);
    }

    private void makeFeatureDependentActions(IWorkbenchWindow window) {
        AboutInfo[] infos = null;
        IPreferenceStore prefs = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String stateKey = "platformState";
        String prevState = prefs.getString(stateKey);
        String currentState = String.valueOf(Platform.getStateStamp());
        boolean sameState = currentState.equals(prevState);
        if (!sameState) {
            prefs.putValue(stateKey, currentState);
        }
        String quickStartKey = IDEActionFactory.QUICK_START.getId();
        String showQuickStart = prefs.getString(quickStartKey);
        if (sameState && "true".equals(showQuickStart)) {
            this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
            this.register(this.quickStartAction);
        } else if (!sameState || !"false".equals(showQuickStart)) {
            infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            boolean found = this.hasWelcomePage(infos);
            prefs.setValue(quickStartKey, found);
            if (found) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(window);
                this.register(this.quickStartAction);
            }
        }
        String tipsAndTricksKey = IDEActionFactory.TIPS_AND_TRICKS.getId();
        String showTipsAndTricks = prefs.getString(tipsAndTricksKey);
        if (sameState && "true".equals(showTipsAndTricks)) {
            this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
            this.register(this.tipsAndTricksAction);
        } else if (!sameState || !"false".equals(showTipsAndTricks)) {
            if (infos == null) {
                infos = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            }
            boolean found = this.hasTipsAndTricks(infos);
            prefs.setValue(tipsAndTricksKey, found);
            if (found) {
                this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(window);
                this.register(this.tipsAndTricksAction);
            }
        }
    }

    private boolean hasWelcomePage(AboutInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getWelcomePageURL() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTipsAndTricks(AboutInfo[] infos) {
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getTipsAndTricksHref() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void updateBuildActions(boolean immediately) {
        Runnable update = new Runnable(){

            public void run() {
                boolean found;
                if (WorkbenchActionBuilder.this.isDisposed) {
                    return;
                }
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                boolean enabled = BuildUtilities.isEnabled(projects, 10);
                WorkbenchActionBuilder.this.buildAllAction.setEnabled(enabled);
                WorkbenchActionBuilder.this.buildProjectAction.setEnabled(enabled);
                WorkbenchActionBuilder.this.toggleAutoBuildAction.setChecked(workspace.isAutoBuilding());
                WorkbenchActionBuilder.this.cleanAction.setEnabled(BuildUtilities.isEnabled(projects, 15));
                ICoolBarManager coolBarManager = WorkbenchActionBuilder.this.getActionBarConfigurer().getCoolBarManager();
                IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.file");
                if (!(cbItem instanceof IToolBarContributionItem)) {
                    IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
                    return;
                }
                IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
                IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
                if (toolBarManager == null) {
                    IDEWorkbenchPlugin.log("File toolbar is missing");
                    return;
                }
                boolean bl = found = toolBarManager.find(WorkbenchActionBuilder.this.buildAllAction.getId()) != null;
                if (enabled && !found) {
                    toolBarManager.appendToGroup("build.group", WorkbenchActionBuilder.this.buildAllAction);
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                } else if (WorkbenchActionBuilder.this.buildAllAction != null && found && !enabled) {
                    toolBarManager.remove(WorkbenchActionBuilder.this.buildAllAction.getId());
                    toolBarManager.update(false);
                    toolBarItem.update("size");
                }
            }
        };
        if (immediately) {
            update.run();
        } else {
            Shell shell = this.window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(update);
            }
        }
    }

    void updatePinActionToolbar() {
        ICoolBarManager coolBarManager = this.getActionBarConfigurer().getCoolBarManager();
        IContributionItem cbItem = coolBarManager.find("org.eclipse.ui.workbench.navigate");
        if (!(cbItem instanceof IToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("Navigation toolbar contribution item is missing");
            return;
        }
        IToolBarContributionItem toolBarItem = (IToolBarContributionItem)cbItem;
        IToolBarManager toolBarManager = toolBarItem.getToolBarManager();
        if (toolBarManager == null) {
            IDEWorkbenchPlugin.log("Navigate toolbar is missing");
            return;
        }
        toolBarManager.update(false);
        toolBarItem.update("size");
    }
}

