/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.JobsViewPreferenceDialog;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.VirtualProgressViewer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ViewPreferencesAction;

public class VirtualProgressView
extends ViewPart
implements IViewPart {
    VirtualProgressViewer viewer;
    Action cancelAction;
    Action clearAllAction;

    public void createPartControl(Composite parent) {
        this.viewer = new VirtualProgressViewer(parent, 2);
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.responsive_ui_context");
        this.initContentProvider();
        this.createClearAllAction();
        this.createCancelAction();
        this.initContextMenu();
        this.initPulldownMenu();
        this.initToolBar();
        this.getSite().setSelectionProvider(this.viewer);
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    protected void initContentProvider() {
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, true, true);
        this.viewer.setContentProvider(provider);
        this.viewer.setInput(ProgressManager.getInstance());
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add(this.cancelAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobInfo info = VirtualProgressView.this.getSelectedInfo();
                if (info == null) {
                    return;
                }
            }
        });
        menuMgr.add(new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, this.viewer);
        this.viewer.getControl().setMenu(menu);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add(this.clearAllAction);
        menuMgr.add(new ViewPreferencesAction(){

            public void openViewPreferencesDialog() {
                new JobsViewPreferenceDialog(VirtualProgressView.this.viewer.getControl().getShell()).open();
            }
        });
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add(this.clearAllAction);
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection currentSelection = provider.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return null;
    }

    JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()).isJobInfo()) {
            return (JobInfo)element;
        }
        return null;
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.ProgressView_CancelAction){

            public void run() {
                VirtualProgressView.this.viewer.cancelSelection();
            }
        };
    }

    private void createClearAllAction() {
        this.clearAllAction = new Action(ProgressMessages.ProgressView_ClearAllAction){

            public void run() {
                FinishedJobs.getInstance().clearAll();
            }
        };
        this.clearAllAction.setToolTipText(ProgressMessages.NewProgressView_RemoveAllJobsToolTip);
        ImageDescriptor id = WorkbenchImages.getWorkbenchImageDescriptor("/elcl16/progress_remall.gif");
        if (id != null) {
            this.clearAllAction.setImageDescriptor(id);
        }
        if ((id = WorkbenchImages.getWorkbenchImageDescriptor("/dlcl16/progress_remall.gif")) != null) {
            this.clearAllAction.setDisabledImageDescriptor(id);
        }
    }
}

