/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class NavigatorFrameSource
extends TreeViewerFrameSource {
    private ResourceNavigator navigator;

    public NavigatorFrameSource(ResourceNavigator navigator) {
        super(navigator.getTreeViewer());
        this.navigator = navigator;
    }

    protected TreeFrame createFrame(Object input) {
        TreeFrame frame = super.createFrame(input);
        frame.setName(this.navigator.getFrameName(input));
        frame.setToolTipText(this.navigator.getFrameToolTipText(input));
        return frame;
    }

    protected void frameChanged(TreeFrame frame) {
        IResource resource = (IResource)frame.getInput();
        IProject project = resource.getProject();
        if (project != null && !project.isOpen()) {
            MessageDialog.openInformation(this.navigator.getViewSite().getShell(), ResourceNavigatorMessages.NavigatorFrameSource_closedProject_title, NLS.bind(ResourceNavigatorMessages.NavigatorFrameSource_closedProject_message, project.getName()));
            this.navigator.getFrameList().back();
        } else {
            super.frameChanged(frame);
            this.navigator.updateTitle();
        }
    }
}

