/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.properties;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.IFeatureAdapter;

public class FeatureGeneralPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    public FeatureGeneralPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        try {
            IFeatureAdapter adapter = (IFeatureAdapter)((Object)this.getElement());
            IFeature feature = adapter.getFeature(null);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.addGeneralSection(feature, composite);
            this.addSupportedPlatformsSection(feature, composite);
            this.addDescription(feature, composite);
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void addGeneralSection(IFeature feature, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Composite fieldComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        fieldComposite.setLayout((Layout)layout);
        Label imageLabel = new Label(composite, 131072);
        imageLabel.setLayoutData((Object)new GridData(768));
        if (feature.getImage() != null) {
            ImageDescriptor desc = ImageDescriptor.createFromURL(feature.getImage());
            imageLabel.setImage(UpdateUI.getDefault().getLabelProvider().get(desc));
        } else {
            imageLabel.setImage(UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_PROVIDER));
        }
        this.addField(fieldComposite, UpdateUIMessages.FeatureGeneralPropertyPage_name, feature.getLabel());
        this.addField(fieldComposite, UpdateUIMessages.FeatureGeneralPropertyPage_id, feature.getVersionedIdentifier().getIdentifier());
        this.addField(fieldComposite, UpdateUIMessages.FeatureGeneralPropertyPage_version, feature.getVersionedIdentifier().getVersion().toString());
        this.addField(fieldComposite, UpdateUIMessages.FeatureGeneralPropertyPage_provider, feature.getProvider());
        long size = feature.getInstallSize();
        if (size != -1L) {
            this.addField(fieldComposite, UpdateUIMessages.FeatureGeneralPropertyPage_size, String.valueOf(new Long(size).toString()) + " " + UpdateUIMessages.FeatureGeneralPropertyPage_Kilobytes);
        }
    }

    private void addSupportedPlatformsSection(IFeature feature, Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(UpdateUIMessages.FeatureGeneralPropertyPage_platforms);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(String.valueOf(UpdateUIMessages.FeatureGeneralPropertyPage_os) + this.extractValue(feature.getOS()));
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(UpdateUIMessages.FeatureGeneralPropertyPage_ws) + this.extractValue(feature.getWS()));
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(UpdateUIMessages.FeatureGeneralPropertyPage_arch) + this.extractValue(feature.getOSArch()));
        label = new Label((Composite)group, 0);
        label.setText(String.valueOf(UpdateUIMessages.FeatureGeneralPropertyPage_nl) + this.extractValue(feature.getNL()));
    }

    private void addField(Composite parent, String property, String value) {
        if (value != null && value.length() > 0) {
            Label label = new Label(parent, 0);
            label.setText(property);
            label = new Label(parent, 0);
            label.setText(this.getEscapedString(value));
        }
    }

    private String extractValue(String value) {
        if (value == null || value.equals("*")) {
            return UpdateUIMessages.FeatureGeneralPropertyPage_all;
        }
        return value;
    }

    private void addDescription(IFeature feature, Composite parent) {
        String annotation;
        IURLEntry description = feature.getDescription();
        if (description != null && (annotation = description.getAnnotation()) != null && annotation.length() > 0) {
            Group group = new Group(parent, 0);
            group.setText(UpdateUIMessages.FeatureGeneralPropertyPage_desc);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(1808));
            Text text = new Text((Composite)group, 66);
            GridData gd = new GridData(1808);
            gd.heightHint = 200;
            gd.widthHint = 350;
            text.setEditable(false);
            text.setText(annotation);
            text.setLayoutData((Object)gd);
        }
    }

    private String getEscapedString(String value) {
        StringBuffer result = new StringBuffer(value.length() + 10);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if ('&' == c) {
                result.append("&&");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

