/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.util;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public abstract class DeepAdapter {
    private final Adapter adapter = new Adapter();

    public void addToObject(EObject object) {
        if (object == null) {
            return;
        }
        TreeIterator<EObject> iterator = object.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            if (!this.adapt(next)) continue;
            next.eAdapters().add(this.adapter);
        }
        object.eAdapters().add(this.adapter);
    }

    public void removeFromObject(EObject object) {
        if (object == null) {
            return;
        }
        TreeIterator<EObject> iterator = object.eAllContents();
        while (iterator.hasNext()) {
            EObject next = (EObject)iterator.next();
            next.eAdapters().remove(this.adapter);
        }
        object.eAdapters().remove(this.adapter);
    }

    protected abstract void notifyChanged(Notification var1);

    protected boolean adapt(EObject object) {
        return true;
    }

    private class Adapter
    extends AdapterImpl {
        private Adapter() {
        }

        @Override
        public void notifyChanged(Notification msg) {
            switch (msg.getEventType()) {
                case 3: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 5: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 4: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 6: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 1: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                case 2: {
                    System.out.println("Unsetting: " + msg);
                    break;
                }
                case 7: {
                    break;
                }
                case 10: {
                    System.out.println("EventTypeCount: " + msg);
                    break;
                }
                case -1: {
                    System.out.println("NoFeatureID: " + msg);
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    this.setAdapter(msg.getOldValue(), msg.getNewValue());
                    break;
                }
                default: {
                    System.err.println("Unknown notification type in notification: " + msg);
                }
            }
            DeepAdapter.this.notifyChanged(msg);
        }

        private void setAdapter(Object oldObject, Object newObject) {
            if (oldObject instanceof EObject) {
                ((Notifier)oldObject).eAdapters().remove(this);
            } else if (oldObject instanceof Collection) {
                for (Object obj : (Collection)oldObject) {
                    this.setAdapter(obj, null);
                }
            }
            if (newObject instanceof EObject) {
                if (DeepAdapter.this.adapt((EObject)newObject)) {
                    ((Notifier)newObject).eAdapters().add(this);
                }
            } else if (newObject instanceof Collection) {
                for (Object obj : (Collection)newObject) {
                    this.setAdapter(null, obj);
                }
            }
        }
    }
}

