/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.data.impl;

import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.impl.DataImpl;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import org.eclipse.emf.ecore.EClass;

public abstract class AtomicImpl
extends DataImpl
implements Atomic {
    protected static final Object EFFECTIVE_VALUE_EDEFAULT = null;
    protected static final Object INITIAL_VALUE_EDEFAULT = null;
    protected static final Object FIXED_VALUE_EDEFAULT = null;
    protected static final Object INPUT_VALUE_EDEFAULT = null;
    protected static final Object OUTPUT_VALUE_EDEFAULT = null;

    protected AtomicImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DataPackage.Literals.ATOMIC;
    }

    @Override
    public Object getInitialValue() {
        if (this.getBaseType() != null) {
            return this.getBaseType().getInitial();
        }
        return INITIAL_VALUE_EDEFAULT;
    }

    @Override
    public Object getFixedValue() {
        if (this.getBaseTypeExtension() != null) {
            return PropertiesUtils.getPropertyValue(this.getBaseTypeExtension().getProperties(), PropertiesUtils.PropertyEnum.VALUE);
        }
        return FIXED_VALUE_EDEFAULT;
    }

    @Override
    public Object getEffectiveValue() {
        if (this.getBaseTypeExtension() == null) {
            return this.getInputValue(null);
        }
        UsageType usage = PropertiesUtils.getUsage(this.getBaseTypeExtension().getProperties());
        switch (usage) {
            case IN: 
            case INOUT: 
            case FIX: {
                return this.getInputValue(usage);
            }
            case OUT: {
                return this.getOutputValue(usage);
            }
            case NONE: {
                return EFFECTIVE_VALUE_EDEFAULT;
            }
        }
        throw new IllegalArgumentException("UsagetType " + usage + " is not recognized.");
    }

    @Override
    public Object getInputValue() {
        UsageType usage = null;
        if (this.getBaseTypeExtension() != null) {
            usage = PropertiesUtils.getUsage(this.getBaseTypeExtension().getProperties());
        }
        return this.getInputValue(usage);
    }

    @Override
    public Object getOutputValue() {
        UsageType usage = null;
        if (this.getBaseTypeExtension() != null) {
            usage = PropertiesUtils.getUsage(this.getBaseTypeExtension().getProperties());
        }
        return this.getOutputValue(usage);
    }

    private Object getInputValue(UsageType usage) {
        Object effectiveValue;
        if (usage == null) {
            return this.getInitialValue();
        }
        switch (usage) {
            case IN: 
            case INOUT: {
                effectiveValue = this.getValue();
                if (this.isEmptyValue(effectiveValue)) {
                    effectiveValue = this.getFixedValue();
                }
                if (!this.isEmptyValue(effectiveValue)) break;
                effectiveValue = this.getInitialValue();
                break;
            }
            case FIX: {
                effectiveValue = this.getFixedValue();
                if (!this.isEmptyValue(effectiveValue)) break;
                effectiveValue = this.getInitialValue();
                break;
            }
            case OUT: 
            case NONE: {
                effectiveValue = EFFECTIVE_VALUE_EDEFAULT;
                break;
            }
            default: {
                throw new IllegalArgumentException("UsageType " + usage + " is not recognized.");
            }
        }
        return effectiveValue;
    }

    private Object getOutputValue(UsageType usage) {
        Object effectiveValue;
        if (usage == null) {
            return this.getInitialValue();
        }
        switch (usage) {
            case OUT: 
            case INOUT: {
                effectiveValue = this.getValue();
                if (effectiveValue == null) {
                    effectiveValue = this.getFixedValue();
                }
                if (effectiveValue != null) break;
                effectiveValue = this.getInitialValue();
                break;
            }
            case FIX: {
                effectiveValue = this.getFixedValue();
                if (effectiveValue != null) break;
                effectiveValue = this.getInitialValue();
                break;
            }
            case IN: 
            case NONE: {
                effectiveValue = EFFECTIVE_VALUE_EDEFAULT;
                break;
            }
            default: {
                throw new IllegalArgumentException("UsageType " + usage + " is not recognized.");
            }
        }
        return effectiveValue;
    }

    protected boolean isEmptyValue(Object object) {
        return object == null;
    }

    @Override
    public boolean isEmpty() {
        Object effectiveValue;
        if (this.getBaseType() == null) {
            return false;
        }
        Boolean isFiller = PropertiesUtils.getBooleanProperty(this.getBaseType().getProperties(), PropertiesUtils.PropertyEnum.FILLER);
        if (isFiller != null && isFiller.booleanValue()) {
            return true;
        }
        Object initialValue = this.getInitialValue();
        if (initialValue == (effectiveValue = this.getEffectiveValue())) {
            return true;
        }
        if (effectiveValue != null && initialValue != null && initialValue.equals(effectiveValue)) {
            return true;
        }
        Object fixedValue = this.getFixedValue();
        if (fixedValue == effectiveValue) {
            return true;
        }
        return effectiveValue != null && fixedValue != null && fixedValue.equals(effectiveValue);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getInitialValue();
            }
            case 9: {
                return this.getFixedValue();
            }
            case 10: {
                return this.getInputValue();
            }
            case 11: {
                return this.getOutputValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return INITIAL_VALUE_EDEFAULT == null ? this.getInitialValue() != null : !INITIAL_VALUE_EDEFAULT.equals(this.getInitialValue());
            }
            case 9: {
                return FIXED_VALUE_EDEFAULT == null ? this.getFixedValue() != null : !FIXED_VALUE_EDEFAULT.equals(this.getFixedValue());
            }
            case 10: {
                return INPUT_VALUE_EDEFAULT == null ? this.getInputValue() != null : !INPUT_VALUE_EDEFAULT.equals(this.getInputValue());
            }
            case 11: {
                return OUTPUT_VALUE_EDEFAULT == null ? this.getOutputValue() != null : !OUTPUT_VALUE_EDEFAULT.equals(this.getOutputValue());
            }
        }
        return super.eIsSet(featureID);
    }
}

