/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.listructure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UsageType implements Enumerator
{
    IN(0, "in", "in"),
    OUT(1, "out", "out"),
    INOUT(2, "inout", "inout"),
    FIX(3, "fix", "fix"),
    NONE(4, "none", "none");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    public static final int FIX_VALUE = 3;
    public static final int NONE_VALUE = 4;
    private static final UsageType[] VALUES_ARRAY;
    public static final List<UsageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UsageType[]{IN, OUT, INOUT, FIX, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UsageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UsageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UsageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UsageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UsageType get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
            case 3: {
                return FIX;
            }
            case 4: {
                return NONE;
            }
        }
        return null;
    }

    private UsageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

