/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.core.model.xml.testcase.util;

import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Atomic;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.Data;
import com.savvytest.eclipse.core.model.xml.data.DataFactory;
import com.savvytest.eclipse.core.model.xml.data.DataVisitor;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.PersistentData;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.util.FeatureMap;

public class BuildTestcaseDataVisitor
implements DataVisitor {
    private java.lang.String currentPrefix = "";
    private final Argument dataArgument;
    private List<PersistentData> testcaseData = new ArrayList<PersistentData>();
    private boolean doSetValues = false;
    private int currentArrayIndex = -1;

    public BuildTestcaseDataVisitor(Argument arg, java.lang.String prefix) {
        this(arg);
        this.currentPrefix = prefix;
    }

    public BuildTestcaseDataVisitor(Argument arg, java.lang.String prefix, boolean doSetValues) {
        this(arg);
        this.currentPrefix = prefix;
        this.doSetValues = doSetValues;
    }

    public BuildTestcaseDataVisitor(Argument arg) {
        this.dataArgument = arg;
    }

    public List<PersistentData> getTestcaseData() throws Exception {
        this.testcaseData = new ArrayList<PersistentData>();
        for (FeatureMap.Entry entry : this.dataArgument.getParameters().getParameters()) {
            Data data = (Data)entry.getValue();
            data.accept(this);
        }
        return this.testcaseData;
    }

    private java.lang.String makeId(BaseType baseType) {
        if (this.currentArrayIndex > -1) {
            return java.lang.String.valueOf(this.currentPrefix) + "[" + this.currentArrayIndex + "]";
        }
        java.lang.String name = baseType.getName();
        if (this.currentPrefix.isEmpty()) {
            return name;
        }
        return java.lang.String.valueOf(this.currentPrefix) + "." + name;
    }

    @Override
    public Object visit(Struct struct) throws Exception {
        int arrayIndex = this.currentArrayIndex;
        java.lang.String structPrefix = this.currentPrefix;
        java.lang.String id = this.makeId(struct.getBaseType());
        this.currentArrayIndex = -1;
        for (FeatureMap.Entry entry : struct.getElements()) {
            this.currentPrefix = id;
            Data data = (Data)entry.getValue();
            data.accept(this);
        }
        this.currentPrefix = structPrefix;
        this.currentArrayIndex = arrayIndex;
        return null;
    }

    @Override
    public Object visit(Array array) throws Exception {
        int arrayIndex = this.currentArrayIndex;
        java.lang.String arrayPrefix = this.currentPrefix;
        java.lang.String id = this.makeId(array.getBaseType());
        int index = 0;
        for (FeatureMap.Entry entry : array.getElements()) {
            this.currentArrayIndex = index++;
            this.currentPrefix = id;
            Data data = (Data)entry.getValue();
            data.accept(this);
        }
        this.currentPrefix = arrayPrefix;
        this.currentArrayIndex = arrayIndex;
        return null;
    }

    @Override
    public Object visit(String string) throws Exception {
        return this.visitAtomic(string, PropertiesUtils.PropertyEnum.VALUE_STRING);
    }

    @Override
    public Object visit(Number number) throws Exception {
        return this.visitAtomic(number, PropertiesUtils.PropertyEnum.VALUE_NUMBER);
    }

    @Override
    public Object visit(Boolean bool) throws Exception {
        return this.visitAtomic(bool, PropertiesUtils.PropertyEnum.VALUE_BOOLEAN);
    }

    private Object visitAtomic(Atomic atomic, PropertiesUtils.PropertyEnum type) {
        BaseType baseType = atomic.getBaseType();
        PersistentData data = DataFactory.eINSTANCE.createPersistentData();
        data.setBaseType(baseType);
        atomic.setPersistentData(data);
        java.lang.String value = null;
        if (this.doSetValues && atomic.getValue() != null) {
            value = atomic.getValue().toString();
        }
        java.lang.String index = this.makeId(baseType);
        Properties properties = PropertiesFactory.eINSTANCE.createProperties();
        properties.getProperties().add(PropertiesUtils.createProperty(type, value));
        properties.getProperties().add(PropertiesUtils.createProperty(PropertiesUtils.PropertyEnum.INDEX, index));
        data.setProperties(properties);
        data.setId(index);
        this.testcaseData.add(data);
        return null;
    }
}

