/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.misc.StatusUtil;

public abstract class ProductInfoDialog
extends TrayDialog {
    private AboutItem item;
    private Cursor handCursor;
    private Cursor busyCursor;
    private boolean mouseDown = false;
    private boolean dragEvent = false;

    public ProductInfoDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void addListeners(StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    return;
                }
                ProductInfoDialog.this.mouseDown = true;
            }

            public void mouseUp(MouseEvent e) {
                ProductInfoDialog.this.mouseDown = false;
                StyledText text = (StyledText)e.widget;
                int offset = text.getCaretOffset();
                if (ProductInfoDialog.this.dragEvent) {
                    ProductInfoDialog.this.dragEvent = false;
                    if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                        text.setCursor(ProductInfoDialog.this.handCursor);
                    }
                } else if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(ProductInfoDialog.this.busyCursor);
                    ProductInfoDialog.this.openLink(ProductInfoDialog.this.item.getLinkAt(offset));
                    StyleRange selectionRange = ProductInfoDialog.this.getCurrentRange(text);
                    text.setSelectionRange(selectionRange.start, selectionRange.length);
                    text.setCursor(null);
                }
            }
        });
        styledText.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ProductInfoDialog.this.mouseDown) {
                    if (!ProductInfoDialog.this.dragEvent) {
                        StyledText text = (StyledText)e.widget;
                        text.setCursor(null);
                    }
                    ProductInfoDialog.this.dragEvent = true;
                    return;
                }
                StyledText text = (StyledText)e.widget;
                int offset = -1;
                try {
                    offset = text.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (offset == -1) {
                    text.setCursor(null);
                } else if (ProductInfoDialog.this.item != null && ProductInfoDialog.this.item.isLinkAt(offset)) {
                    text.setCursor(ProductInfoDialog.this.handCursor);
                } else {
                    text.setCursor(null);
                }
            }
        });
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                StyledText text = (StyledText)e.widget;
                switch (e.detail) {
                    case 2: {
                        e.doit = true;
                        break;
                    }
                    case 16: {
                        StyleRange nextRange;
                        Point nextSelection = text.getSelection();
                        int charCount = text.getCharCount();
                        if (nextSelection.x == charCount && nextSelection.y == charCount) {
                            text.setSelection(0);
                        }
                        if ((nextRange = ProductInfoDialog.this.findNextRange(text)) == null) {
                            text.setSelection(0);
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(nextRange.start, nextRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                    case 8: {
                        StyleRange previousRange;
                        Point previousSelection = text.getSelection();
                        if (previousSelection.x == 0 && previousSelection.y == 0) {
                            text.setSelection(text.getCharCount());
                        }
                        if ((previousRange = ProductInfoDialog.this.findPreviousRange(text)) == null) {
                            text.setSelection(text.getCharCount());
                            e.doit = true;
                            break;
                        }
                        text.setSelectionRange(previousRange.start, previousRange.length);
                        e.doit = true;
                        e.detail = 0;
                        break;
                    }
                }
            }
        });
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                StyledText text = (StyledText)event.widget;
                if (event.character == ' ' || event.character == '\r') {
                    if (ProductInfoDialog.this.item != null) {
                        int offset = text.getSelection().x + 1;
                        if (ProductInfoDialog.this.item.isLinkAt(offset)) {
                            text.setCursor(ProductInfoDialog.this.busyCursor);
                            ProductInfoDialog.this.openLink(ProductInfoDialog.this.item.getLinkAt(offset));
                            StyleRange selectionRange = ProductInfoDialog.this.getCurrentRange(text);
                            text.setSelectionRange(selectionRange.start, selectionRange.length);
                            text.setCursor(null);
                        }
                    }
                    return;
                }
            }
        });
    }

    protected Cursor getBusyCursor() {
        return this.busyCursor;
    }

    protected void setBusyCursor(Cursor busyCursor) {
        this.busyCursor = busyCursor;
    }

    protected Cursor getHandCursor() {
        return this.handCursor;
    }

    protected void setHandCursor(Cursor handCursor) {
        this.handCursor = handCursor;
    }

    protected AboutItem getItem() {
        return this.item;
    }

    protected void setItem(AboutItem item) {
        this.item = item;
    }

    protected StyleRange getCurrentRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        int currentSelectionStart = text.getSelection().x;
        int i = 0;
        while (i < ranges.length) {
            if (currentSelectionStart >= ranges[i].start && currentSelectionEnd <= ranges[i].start + ranges[i].length) {
                return ranges[i];
            }
            ++i;
        }
        return null;
    }

    protected StyleRange findNextRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionEnd = text.getSelection().y;
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i].start >= currentSelectionEnd) {
                return ranges[i];
            }
            ++i;
        }
        return null;
    }

    protected StyleRange findPreviousRange(StyledText text) {
        StyleRange[] ranges = text.getStyleRanges();
        int currentSelectionStart = text.getSelection().x;
        int i = ranges.length - 1;
        while (i > -1) {
            if (ranges[i].start + ranges[i].length - 1 < currentSelectionStart) {
                return ranges[i];
            }
            --i;
        }
        return null;
    }

    private void openWebBrowserError(String href, Throwable t) {
        String title = WorkbenchMessages.ProductInfoDialog_errorTitle;
        String msg = NLS.bind(WorkbenchMessages.ProductInfoDialog_unableToOpenWebBrowser, href);
        IStatus status = WorkbenchPlugin.getStatus(t);
        StatusUtil.handleStatus(status, String.valueOf(title) + ": " + msg, 2, this.getShell());
    }

    protected void openLink(String href) {
        if (href.startsWith("file:")) {
            href = href.substring(5);
            while (href.startsWith("/")) {
                href = href.substring(1);
            }
            href = "file:///" + href;
        }
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(this.urlEncodeForSpaces(href.toCharArray())));
        }
        catch (MalformedURLException e) {
            this.openWebBrowserError(href, e);
        }
        catch (PartInitException e) {
            this.openWebBrowserError(href, e);
        }
    }

    private String urlEncodeForSpaces(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    protected boolean openBrowser(URL url) {
        if (url != null) {
            try {
                url = Platform.asLocalURL(url);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (url == null) {
            return false;
        }
        this.openLink(url.toString());
        return true;
    }

    protected void setBoldRanges(StyledText styledText, int[][] boldRanges) {
        int i = 0;
        while (i < boldRanges.length) {
            StyleRange r = new StyleRange(boldRanges[i][0], boldRanges[i][1], null, null, 1);
            styledText.setStyleRange(r);
            ++i;
        }
    }

    protected void setLinkRanges(StyledText styledText, int[][] linkRanges) {
        Color fg = JFaceColors.getHyperlinkText(styledText.getShell().getDisplay());
        int i = 0;
        while (i < linkRanges.length) {
            StyleRange r = new StyleRange(linkRanges[i][0], linkRanges[i][1], fg, null);
            styledText.setStyleRange(r);
            ++i;
        }
    }

    protected AboutItem scan(String s) {
        ArrayList<int[]> linkRanges = new ArrayList<int[]>();
        ArrayList<String> links = new ArrayList<String>();
        int urlSeparatorOffset = s.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            char ch;
            boolean startDoubleQuote = false;
            int urlOffset = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffset > -1) {
                    ch = s.charAt(urlOffset);
                }
                boolean bl = startDoubleQuote = ch == '\"';
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffset;
            StringTokenizer tokenizer = new StringTokenizer(s.substring(urlSeparatorOffset + 3), " \t\n\r\f<>", false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            int urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffset;
            if (startDoubleQuote) {
                int endOffset = -1;
                int nextDoubleQuote = s.indexOf(34, urlOffset);
                int nextWhitespace = s.indexOf(32, urlOffset);
                if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                    endOffset = Math.min(nextDoubleQuote, nextWhitespace);
                } else if (nextDoubleQuote != -1) {
                    endOffset = nextDoubleQuote;
                } else if (nextWhitespace != -1) {
                    endOffset = nextWhitespace;
                }
                if (endOffset != -1) {
                    urlLength = endOffset - urlOffset;
                }
            }
            linkRanges.add(new int[]{urlOffset, urlLength});
            links.add(s.substring(urlOffset, urlOffset + urlLength));
            urlSeparatorOffset = s.indexOf("://", urlOffset + urlLength + 1);
        }
        return new AboutItem(s, (int[][])linkRanges.toArray((T[])new int[linkRanges.size()][2]), links.toArray(new String[links.size()]));
    }
}

