/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectReferencePage
extends PropertyPage {
    private IProject project;
    private boolean modified = false;
    private CheckboxTableViewer listViewer;
    private static final int PROJECT_LIST_MULTIPLIER = 30;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.project_reference_property_page_context");
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.initialize();
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)new GridData(4, 128, true, false));
        this.listViewer = CheckboxTableViewer.newCheckList(composite, 2176);
        this.listViewer.getTable().setFont(font);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        if (!this.project.isOpen()) {
            this.listViewer.getControl().setEnabled(false);
        }
        if (DialogUtil.inRegularFontMode(parent)) {
            data.heightHint = ProjectReferencePage.getDefaultFontHeight((Control)this.listViewer.getTable(), 30);
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(font);
        this.listViewer.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.listViewer.setContentProvider(this.getContentProvider(this.project));
        this.listViewer.setComparator(new ViewerComparator());
        this.listViewer.setInput(this.project.getWorkspace());
        try {
            this.listViewer.setCheckedElements(this.project.getDescription().getReferencedProjects());
        }
        catch (CoreException coreException) {}
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectReferencePage.this.modified = true;
            }
        });
        return composite;
    }

    protected IStructuredContentProvider getContentProvider(final IProject project) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (!(o instanceof IWorkspace)) {
                    return new Object[0];
                }
                IProject[] projects = ((IWorkspace)o).getRoot().getProjects();
                ArrayList<IProject> referenced = new ArrayList<IProject>(projects.length);
                boolean found = false;
                int i = 0;
                while (i < projects.length) {
                    if (!found && projects[i].equals(project)) {
                        found = true;
                    } else {
                        referenced.add(projects[i]);
                    }
                    ++i;
                }
                try {
                    projects = project.getDescription().getReferencedProjects();
                    i = 0;
                    while (i < projects.length) {
                        if (!referenced.contains(projects[i])) {
                            referenced.add(projects[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
                return referenced.toArray();
            }
        };
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    protected void handle(InvocationTargetException e) {
        IStatus error;
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            error = ((CoreException)target).getStatus();
        } else {
            String msg = target.getMessage();
            if (msg == null) {
                msg = IDEWorkbenchMessages.Internal_error;
            }
            error = new Status(4, "org.eclipse.ui.ide", 1, msg, target);
        }
        ErrorDialog.openError(this.getControl().getShell(), null, null, error);
    }

    private void initialize() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.project = (IProject)iAdaptable.getAdapter(clazz);
        this.noDefaultAndApplyButton();
        this.setDescription(NLS.bind(IDEWorkbenchMessages.ProjectReferencesPage_label, this.project.getName()));
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        Object[] checked = this.listViewer.getCheckedElements();
        final IProject[] refs = new IProject[checked.length];
        System.arraycopy(checked, 0, refs, 0, checked.length);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IProjectDescription description = ProjectReferencePage.this.project.getDescription();
                    description.setReferencedProjects(refs);
                    ProjectReferencePage.this.project.setDescription(description, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            this.handle(e);
            return false;
        }
        return true;
    }
}

