/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.views.markers.internal.MarkerView;

public class MarkerViewUtil {
    public static final String PATH_ATTRIBUTE = "org.eclipse.ui.views.markers.path";
    public static final String NAME_ATTRIBUTE = "org.eclipse.ui.views.markers.name";

    public static String getViewId(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            return "org.eclipse.ui.views.TaskList";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return "org.eclipse.ui.views.ProblemView";
        }
        if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
            return "org.eclipse.ui.views.BookmarkView";
        }
        return null;
    }

    public static boolean showMarker(IWorkbenchPage page, IMarker marker, boolean showView) {
        try {
            String viewId = MarkerViewUtil.getViewId(marker);
            if (viewId != null) {
                IViewPart view;
                IViewPart iViewPart = view = showView ? page.showView(viewId) : page.findView(viewId);
                if (view instanceof MarkerView) {
                    StructuredSelection selection = new StructuredSelection(marker);
                    MarkerView markerView = (MarkerView)view;
                    markerView.setSelection(selection, true);
                    return true;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

