/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class NavigatorDragAdapter
extends DragSourceAdapter {
    private static final String CHECK_MOVE_TITLE = ResourceNavigatorMessages.DragAdapter_title;
    private static final String CHECK_DELETE_MESSAGE = ResourceNavigatorMessages.DragAdapter_checkDeleteMessage;
    ISelectionProvider selectionProvider;
    private TransferData lastDataType;

    public NavigatorDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dragFinished(DragSourceEvent event) {
        block11: {
            block10: {
                LocalSelectionTransfer.getInstance().setSelection(null);
                if (!event.doit) {
                    return;
                }
                if (event.detail != 2) break block10;
                if (this.lastDataType != null && FileTransfer.getInstance().isSupportedType(this.lastDataType)) {
                    return;
                }
                IResource[] resources = this.getSelectedResources(3);
                DragSource dragSource = (DragSource)event.widget;
                Control control = dragSource.getControl();
                Shell shell = control.getShell();
                if (resources == null || resources.length == 0) {
                    return;
                }
                ReadOnlyStateChecker checker = new ReadOnlyStateChecker(shell, CHECK_MOVE_TITLE, CHECK_DELETE_MESSAGE);
                resources = checker.checkReadOnlyResources(resources);
                int i = 0;
                while (i < resources.length) {
                    try {
                        resources[i].delete(3, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                break block11;
            }
            if (event.detail != 8) break block11;
            IResource[] resources = this.getSelectedResources(3);
            if (resources == null) {
                return;
            }
            int i = 0;
            while (i < resources.length) {
                try {
                    resources[i].refreshLocal(2, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IResource[] resources = this.getSelectedResources(3);
        if (resources == null || resources.length == 0) {
            return;
        }
        this.lastDataType = event.dataType;
        if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = LocalSelectionTransfer.getInstance().getSelection();
            return;
        }
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = resources;
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(event.dataType)) {
            return;
        }
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            ++i;
        }
        if (actualLength == 0) {
            return;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i2 = 0;
            while (i2 < actualLength) {
                fileNames[i2] = tempFileNames[i2];
                ++i2;
            }
        }
        event.data = fileNames;
    }

    public void dragStart(DragSourceEvent event) {
        this.lastDataType = null;
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof IFile || next instanceof IFolder) continue;
            event.doit = false;
            return;
        }
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
        LocalSelectionTransfer.getInstance().setSelection(selection);
        event.doit = true;
    }

    private IResource[] getSelectedResources(int resourceTypes) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] result = new IResource[]{};
        ISelection selection = this.selectionProvider.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator itr = structuredSelection.iterator();
        while (itr.hasNext()) {
            IResource res;
            Object obj = itr.next();
            if (!(obj instanceof IResource) || ((res = (IResource)obj).getType() & resourceTypes) != res.getType()) continue;
            resources.add(res);
        }
        result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }
}

