/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.ConnectionThreadManager;
import org.eclipse.update.internal.core.connection.ConnectionThreadManagerFactory;
import org.eclipse.update.internal.core.connection.IResponse;
import org.eclipse.update.internal.core.connection.TooManyOpenConnectionsException;

public abstract class AbstractResponse
implements IResponse {
    private static final long POLLING_INTERVAL = 200L;
    protected URLConnection connection;

    protected InputStream openStreamWithCancel(URLConnection urlConnection, IProgressMonitor monitor) throws IOException, CoreException, TooManyOpenConnectionsException {
        ConnectionThreadManager.StreamRunnable runnable = new ConnectionThreadManager.StreamRunnable(urlConnection);
        Thread t = ConnectionThreadManagerFactory.getConnectionManager().getConnectionThread(runnable);
        t.start();
        InputStream is = null;
        try {
            while (true) {
                if (monitor.isCanceled()) {
                    runnable.disconnect();
                    this.connection = null;
                    break;
                }
                if (runnable.getInputStream() != null || !t.isAlive()) {
                    is = runnable.getInputStream();
                    break;
                }
                if (runnable.getIOException() != null) {
                    throw runnable.getIOException();
                }
                if (runnable.getException() != null) {
                    throw new CoreException(new Status(4, UpdateCore.getPlugin().getBundle().getSymbolicName(), 0, runnable.getException().getMessage(), runnable.getException()));
                }
                t.join(200L);
            }
        }
        catch (InterruptedException interruptedException) {}
        return is;
    }
}

