/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.preferences;

import com.savvytest.eclipse.common.preferences.PropertyStore;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class FieldEditorOverlayPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    public static final String USEPROJECTSETTINGS = "useProjectSettings";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IAdaptable element;
    private Button useWorkspaceSettingsButton;
    private Button useProjectSettingsButton;
    private Button configureButton;
    private IPreferenceStore overlayStore;
    private ImageDescriptor image;
    private String pageId;

    public FieldEditorOverlayPage(int style) {
        super(style);
    }

    public FieldEditorOverlayPage(String title, int style) {
        super(title, style);
    }

    public FieldEditorOverlayPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    protected abstract String getPageId();

    @Override
    public void setElement(IAdaptable element) {
        this.element = element;
    }

    @Override
    public IAdaptable getElement() {
        return this.element;
    }

    public boolean isPropertyPage() {
        return this.getElement() != null;
    }

    @Override
    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    @Override
    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.pageId = this.getPageId();
            this.overlayStore = new PropertyStore((IResource)this.getElement(), super.getPreferenceStore(), this.pageId);
        }
        super.createControl(parent);
        if (this.showSelectionGroup()) {
            this.updateFieldEditors();
        }
    }

    @Override
    protected Control createContents(Composite parent) {
        if (this.showSelectionGroup()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        Composite radioGroup = new Composite(comp, 0);
        radioGroup.setLayout((Layout)new GridLayout());
        radioGroup.setLayoutData((Object)new GridData(768));
        this.useWorkspaceSettingsButton = this.createRadioButton(radioGroup, "Use Workspace settings");
        this.useProjectSettingsButton = this.createRadioButton(radioGroup, "Use project settings");
        this.configureButton = new Button(comp, 8);
        this.configureButton.setText("Configure workspace settings...");
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureWorkspaceSettings();
            }
        });
        try {
            String use = ((IResource)this.getElement()).getPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS));
            if (TRUE.equals(use)) {
                this.useProjectSettingsButton.setSelection(true);
                this.configureButton.setEnabled(false);
            } else {
                this.useWorkspaceSettingsButton.setSelection(true);
            }
        }
        catch (CoreException coreException) {
            this.useWorkspaceSettingsButton.setSelection(true);
        }
    }

    private Button createRadioButton(Composite parent, String label) {
        final Button button = new Button(parent, 16);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureButton.setEnabled(button == FieldEditorOverlayPage.this.useWorkspaceSettingsButton);
                FieldEditorOverlayPage.this.updateFieldEditors();
            }
        });
        return button;
    }

    @Override
    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    private void updateFieldEditors() {
        boolean enabled = this.useProjectSettingsButton.getSelection();
        this.updateFieldEditors(enabled);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    @Override
    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.showSelectionGroup()) {
            IResource resource = (IResource)this.getElement();
            try {
                String value = this.useProjectSettingsButton.getSelection() ? TRUE : FALSE;
                resource.setPersistentProperty(new QualifiedName(this.pageId, USEPROJECTSETTINGS), value);
            }
            catch (CoreException e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            }
        }
        return result;
    }

    @Override
    protected void performDefaults() {
        if (this.showSelectionGroup()) {
            this.useWorkspaceSettingsButton.setSelection(true);
            this.useProjectSettingsButton.setSelection(false);
            this.configureButton.setEnabled(true);
            this.updateFieldEditors();
        }
        super.performDefaults();
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)this.getClass().newInstance();
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.pageId, page);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        final PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot(targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    protected boolean showSelectionGroup() {
        return this.isPropertyPage();
    }
}

