/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.common.preferences;

import com.savvytest.eclipse.common.Activator;
import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.logging.ConsoleLogging;
import com.savvytest.eclipse.common.logging.EclipseLogging;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import java.text.DateFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SavvytestPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String REPORT_GENERATOR_EXTENSION_POINT_ID = "com.savvytest.extensionpoint.reportgenerator";
    private static final String REPORT_GENERATOR_EXTENSION_ID = "id";
    private static final String REPORT_GENERATOR_EXTENSION_NAME = "name";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.common.preferences.SavvytestPreferencesPage.";
    private Text licenseeText;
    private Text licenseKeyText;
    private Text validUntilText;
    private Text addonsText;

    private static final String getClassString(String key) {
        return Savvytest.getString(TRANSLATION_PREFIX + key, new Object[0]);
    }

    public SavvytestPreferencesPage() {
        super(0);
        SavvytestSettings.INSTANCE.name();
        this.setPreferenceStore(Activator.getPreferenceStore());
        this.setDescription(SavvytestPreferencesPage.getClassString("description"));
    }

    @Override
    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        parent.setLayout((Layout)new GridLayout());
        Composite licenseGroup = this.createSpacingGroup(parent, SavvytestPreferencesPage.getClassString("licenseGroup"));
        StringFieldEditor licenseLocationEditor = new StringFieldEditor("savvytest.licensefile", SavvytestPreferencesPage.getClassString("licenseLocation"), licenseGroup);
        licenseLocationEditor.getLabelControl(licenseGroup).setToolTipText(SavvytestPreferencesPage.getClassString("licenseLocationTooltip"));
        licenseLocationEditor.getTextControl(licenseGroup).setToolTipText(SavvytestPreferencesPage.getClassString("licenseLocationTooltip"));
        this.addField(licenseLocationEditor);
        Label licenseeLabel = new Label(licenseGroup, 0);
        licenseeLabel.setLayoutData((Object)GridDataCreator.normal());
        licenseeLabel.setText(SavvytestPreferencesPage.getClassString("licensee"));
        this.licenseeText = new Text(licenseGroup, 8);
        this.licenseeText.setLayoutData((Object)GridDataCreator.horizontalFill());
        Label licenseKeyLabel = new Label(licenseGroup, 0);
        licenseKeyLabel.setLayoutData((Object)GridDataCreator.normal());
        licenseKeyLabel.setText(SavvytestPreferencesPage.getClassString("licenseKey"));
        this.licenseKeyText = new Text(licenseGroup, 8);
        this.licenseKeyText.setLayoutData((Object)GridDataCreator.horizontalFill());
        Label validUntilLabel = new Label(licenseGroup, 0);
        validUntilLabel.setLayoutData((Object)GridDataCreator.normal());
        validUntilLabel.setText(SavvytestPreferencesPage.getClassString("validUntil"));
        this.validUntilText = new Text(licenseGroup, 8);
        this.validUntilText.setLayoutData((Object)GridDataCreator.horizontalFill());
        Label addonsLabel = new Label(licenseGroup, 0);
        addonsLabel.setLayoutData((Object)GridDataCreator.normal());
        addonsLabel.setText(SavvytestPreferencesPage.getClassString("addons"));
        this.addonsText = new Text(licenseGroup, 8);
        this.addonsText.setLayoutData((Object)GridDataCreator.horizontalFill());
        this.applyLicense(License.getInstance());
        Composite loggingGroup = this.createSpacingGroup(parent, SavvytestPreferencesPage.getClassString("logging"));
        this.addField(new ComboFieldEditor("savvytest.logclass", SavvytestPreferencesPage.getClassString("logging.class"), this.getClasses(), loggingGroup));
        this.addField(new ComboFieldEditor("savvytest.loglevel", SavvytestPreferencesPage.getClassString("logging.level"), this.getLevels(), loggingGroup));
        Composite reportGeneratorGroup = this.createSpacingGroup(parent, SavvytestPreferencesPage.getClassString("reportGeneratorGroup"));
        this.addField(new ComboFieldEditor("ResultReportGenerator", SavvytestPreferencesPage.getClassString("reportGenerator"), this.getReportGenerators(), reportGeneratorGroup));
    }

    @Override
    public void init(IWorkbench workbench) {
    }

    @Override
    protected void performApply() {
        super.performApply();
        this.applyLicense(License.getInstance());
    }

    private void applyLicense(License license) {
        if (this.licenseeText == null || this.licenseeText.isDisposed()) {
            return;
        }
        this.licenseeText.setText(UtilityFunctions.nullToEmpty(license.getLicensee()));
        this.licenseKeyText.setText(UtilityFunctions.nullToEmpty(license.getHumanReadableLicenseKey()));
        if (license.isValid()) {
            DateFormat formatter = DateFormat.getDateInstance(1);
            this.validUntilText.setText(formatter.format(license.getExpireDate()));
            if (license.isOptionExcelIoLicensed()) {
                if (license.isOptionStubsLicensed()) {
                    this.addonsText.setText(SavvytestPreferencesPage.getClassString("addonBoth"));
                } else {
                    this.addonsText.setText(SavvytestPreferencesPage.getClassString("addonExcel"));
                }
            } else if (license.isOptionStubsLicensed()) {
                this.addonsText.setText(SavvytestPreferencesPage.getClassString("addonStubs"));
            } else {
                this.addonsText.setText(SavvytestPreferencesPage.getClassString("addonNeither"));
            }
        } else {
            this.validUntilText.setText("");
            this.addonsText.setText("");
        }
    }

    private String[][] getClasses() {
        return new String[][]{{ConsoleLogging.getDisplayName(), ConsoleLogging.class.getName()}, {EclipseLogging.getDisplayName(), EclipseLogging.class.getName()}};
    }

    private String[][] getLevels() {
        LogLevel[] levels = LogLevel.values();
        String[][] valueLevels = new String[levels.length][2];
        int i = 0;
        while (i < levels.length) {
            valueLevels[i][0] = levels[i].toString();
            valueLevels[i][1] = levels[i].name();
            ++i;
        }
        return valueLevels;
    }

    private String[][] getReportGenerators() {
        IConfigurationElement[] reportGeneratorElements = Platform.getExtensionRegistry().getConfigurationElementsFor(REPORT_GENERATOR_EXTENSION_POINT_ID);
        String[][] generators = new String[reportGeneratorElements.length][2];
        int i = 0;
        while (i < reportGeneratorElements.length) {
            IConfigurationElement element = reportGeneratorElements[i];
            generators[i][0] = element.getAttribute(REPORT_GENERATOR_EXTENSION_NAME);
            generators[i][1] = element.getAttribute(REPORT_GENERATOR_EXTENSION_ID);
            ++i;
        }
        return generators;
    }

    private Composite createSpacingGroup(Composite parent, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        group.setLayoutData((Object)GridDataCreator.horizontalFill());
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }
}

