/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FocusCellOwnerDrawHighlighter
extends FocusCellHighlighter {
    private ViewerCell oldCell;
    private static final boolean WIN_32 = "win32".equals(SWT.getPlatform());

    public FocusCellOwnerDrawHighlighter(ColumnViewer viewer) {
        super(viewer);
        this.hookListener(viewer);
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        Color background = this.getSelectedCellBackgroundColor(cell);
        Color foreground = this.getSelectedCellForegroundColor(cell);
        if (WIN_32 || foreground != null || background != null) {
            GC gc = event.gc;
            if (background == null) {
                background = cell.getItem().getDisplay().getSystemColor(26);
            }
            if (foreground == null) {
                foreground = cell.getItem().getDisplay().getSystemColor(27);
            }
            gc.setBackground(background);
            gc.setForeground(foreground);
            gc.fillRectangle(event.getBounds());
            gc.drawText(" ", cell.getBounds().x, cell.getBounds().y, false);
            event.detail &= 0xFFFFFFFD;
        }
    }

    private void removeSelectionInformation(Event event, ViewerCell cell) {
        GC gc = event.gc;
        gc.setBackground(cell.getViewerRow().getBackground(cell.getColumnIndex()));
        gc.setForeground(cell.getViewerRow().getForeground(cell.getColumnIndex()));
        gc.fillRectangle(cell.getBounds());
        gc.drawText(" ", cell.getBounds().x, cell.getBounds().y, false);
        event.detail &= 0xFFFFFFFD;
    }

    private void hookListener(final ColumnViewer viewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) > 0) {
                    ViewerCell focusCell = FocusCellOwnerDrawHighlighter.this.getFocusCell();
                    ViewerRow row = viewer.getViewerRowFromItem(event.item);
                    Assert.isNotNull(row, "Internal structure invalid. Item without associated row is not possible.");
                    ViewerCell cell = row.getCell(event.index);
                    if (focusCell == null || !cell.equals(focusCell)) {
                        FocusCellOwnerDrawHighlighter.this.removeSelectionInformation(event, cell);
                    } else {
                        FocusCellOwnerDrawHighlighter.this.markFocusedCell(event, cell);
                    }
                }
            }
        };
        viewer.getControl().addListener(40, listener);
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColor(ViewerCell cell) {
        return null;
    }

    protected void focusCellChanged(ViewerCell cell) {
        int width;
        int x;
        Rectangle rect;
        super.focusCellChanged(cell);
        if (cell != null) {
            rect = cell.getBounds();
            x = cell.getColumnIndex() == 0 ? 0 : rect.x;
            width = cell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            cell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
        if (this.oldCell != null) {
            rect = this.oldCell.getBounds();
            x = this.oldCell.getColumnIndex() == 0 ? 0 : rect.x;
            width = this.oldCell.getColumnIndex() == 0 ? rect.x + rect.width : rect.width;
            this.oldCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
        }
        this.oldCell = cell;
    }
}

