/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class IDESelectionConversionService
implements ISelectionConversionService {
    public IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        Iterator elements = originalSelection.iterator();
        while (elements.hasNext()) {
            Object currentElement = elements.next();
            IResource resource = ResourceUtil.getResource(currentElement);
            if (resource == null) {
                ResourceMapping mapping = ResourceUtil.getResourceMapping(currentElement);
                if (mapping == null) continue;
                ResourceTraversal[] traversals = null;
                try {
                    traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, new NullProgressMonitor());
                }
                catch (CoreException e) {
                    IDEWorkbenchPlugin.log(e.getLocalizedMessage(), e.getStatus());
                }
                if (traversals == null) continue;
                ResourceTraversal traversal = null;
                IResource[] resources = null;
                int i = 0;
                while (i < traversals.length) {
                    traversal = traversals[i];
                    resources = traversal.getResources();
                    if (resources != null) {
                        int j = 0;
                        while (j < resources.length) {
                            result.add(resources[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
                continue;
            }
            result.add(resource);
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result.toArray());
    }
}

