/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ResourceFactory
implements IElementFactory,
IPersistableElement {
    private static final String TAG_PATH = "path";
    private static final String TAG_TYPE = "type";
    private static final String FACTORY_ID = "org.eclipse.ui.internal.model.ResourceFactory";
    private IResource res;

    public ResourceFactory() {
    }

    public ResourceFactory(IResource input) {
        this.res = input;
    }

    public IAdaptable createElement(IMemento memento) {
        String fileName = memento.getString(TAG_PATH);
        if (fileName == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String type = memento.getString(TAG_TYPE);
        if (type == null) {
            this.res = root.findMember(new Path(fileName));
        } else {
            int resourceType = Integer.parseInt(type);
            if (resourceType == 8) {
                this.res = root;
            } else if (resourceType == 4) {
                this.res = root.getProject(fileName);
            } else if (resourceType == 2) {
                this.res = root.getFolder(new Path(fileName));
            } else if (resourceType == 1) {
                this.res = root.getFile(new Path(fileName));
            }
        }
        return this.res;
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        memento.putString(TAG_PATH, this.res.getFullPath().toString());
        memento.putString(TAG_TYPE, Integer.toString(this.res.getType()));
    }
}

