/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PrefUtil {
    private static ICallback uiCallback;
    private static IPreferenceStore uiPreferenceStore;

    private PrefUtil() {
    }

    public static final void setUICallback(ICallback callback) {
        Assert.isTrue(uiCallback == null);
        uiCallback = callback;
    }

    public static IPreferenceStore getAPIPreferenceStore() {
        if (uiPreferenceStore == null) {
            Assert.isNotNull(uiCallback);
            uiPreferenceStore = uiCallback.getPreferenceStore();
        }
        return uiPreferenceStore;
    }

    public static IPreferenceStore getInternalPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public static void savePrefs() {
        PrefUtil.saveAPIPrefs();
        PrefUtil.saveInternalPrefs();
    }

    public static void saveAPIPrefs() {
        Assert.isNotNull(uiCallback);
        uiCallback.savePreferences();
    }

    public static void saveInternalPrefs() {
        WorkbenchPlugin.getDefault().savePluginPreferences();
    }

    public static interface ICallback {
        public IPreferenceStore getPreferenceStore();

        public void savePreferences();
    }
}

