/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IResourcePropertyConstants;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.ResourcePropertySource;

public class FilePropertySource
extends ResourcePropertySource {
    private static PropertyDescriptor fileDescriptor = new PropertyDescriptor("org.eclipse.ui.size", IResourcePropertyConstants.P_DISPLAY_SIZE);

    static {
        fileDescriptor.setAlwaysIncompatible(true);
        fileDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
    }

    public FilePropertySource(IFile file) {
        super(file);
    }

    private static PropertyDescriptor getInitialPropertyDescriptor() {
        return fileDescriptor;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] superDescriptors = super.getPropertyDescriptors();
        int superLength = superDescriptors.length;
        IPropertyDescriptor[] fileDescriptors = new IPropertyDescriptor[superLength + 1];
        System.arraycopy(superDescriptors, 0, fileDescriptors, 0, superLength);
        fileDescriptors[superLength] = FilePropertySource.getInitialPropertyDescriptor();
        return fileDescriptors;
    }

    public Object getPropertyValue(Object key) {
        Object returnValue;
        Object object = returnValue = key.equals("org.eclipse.jface.text") ? TextProcessor.process(this.element.getName()) : super.getPropertyValue(key);
        if (returnValue != null) {
            return returnValue;
        }
        if (key.equals("org.eclipse.ui.size")) {
            return IDEResourceInfoUtils.getSizeString((IFile)this.element);
        }
        return null;
    }
}

