/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.operations.FeatureStatus;
import org.eclipse.update.internal.operations.OperationValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIImages;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.FeatureReferenceAdapter;
import org.eclipse.update.internal.ui.model.SimpleFeatureAdapter;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.SiteCategory;
import org.eclipse.update.internal.ui.parts.DefaultContentProvider;
import org.eclipse.update.internal.ui.parts.SWTUtil;
import org.eclipse.update.internal.ui.parts.SharedLabelProvider;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.ContainerCheckedTreeViewer;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IUpdateModelChangedListener;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.search.IUpdateSearchSite;
import org.eclipse.update.search.UpdateSearchRequest;

public class ReviewPage
extends BannerPage {
    private Label label;
    private ArrayList jobs;
    private Label counterLabel;
    private IStatus validationStatus;
    private Collection problematicFeatures = new HashSet();
    private IFeature newlySelectedFeature;
    private FeatureStatus lastDisplayedStatus;
    private PropertyDialogAction propertiesAction;
    private ScrolledFormText descLabel;
    private Button statusButton;
    private Button moreInfoButton;
    private Button propertiesButton;
    private Button selectRequiredFeaturesButton;
    private Button filterCheck;
    private Button filterOlderVersionCheck;
    private ContainmentFilter filter = new ContainmentFilter();
    private LatestVersionFilter olderVersionFilter = new LatestVersionFilter();
    private UpdateSearchRequest searchRequest;
    private ContainerCheckedTreeViewer treeViewer;
    private boolean initialized;
    private boolean isUpdateSearch;

    public ReviewPage(boolean isUpdateSearch, UpdateSearchRequest searchRequest, ArrayList jobs) {
        super("Review");
        this.isUpdateSearch = isUpdateSearch;
        this.jobs = jobs;
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        this.searchRequest = searchRequest;
        this.setTitle(UpdateUIMessages.InstallWizard_ReviewPage_title);
        this.setDescription(UpdateUIMessages.InstallWizard_ReviewPage_desc);
        UpdateUI.getDefault().getLabelProvider().connect(this);
        this.setBannerVisible(false);
    }

    public void dispose() {
        UpdateUI.getDefault().getLabelProvider().disconnect(this);
        super.dispose();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String filterText = this.filterCheck.getText();
        String filterFeatures = UpdateUIMessages.InstallWizard_ReviewPage_filterFeatures;
        String filterPatches = UpdateUIMessages.InstallWizard_ReviewPage_filterPatches;
        if (this.isUpdateSearch && filterText.equals(filterFeatures)) {
            this.filterCheck.setText(filterPatches);
        } else if (!this.isUpdateSearch && filterText.equals(filterPatches)) {
            this.filterCheck.setText(filterFeatures);
        }
        if (visible && !this.initialized) {
            this.initialized = true;
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ReviewPage.this.performPostSearchProcessing();
                }
            });
        }
    }

    private void performPostSearchProcessing() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                int totalCount;
                if (ReviewPage.this.treeViewer != null && ReviewPage.this.isUpdateSearch) {
                    ReviewPage.this.selectTrueUpdates();
                }
                ReviewPage.this.pageChanged();
                int n = totalCount = ReviewPage.this.jobs != null ? ReviewPage.this.jobs.size() : 0;
                if (totalCount > 0) {
                    ReviewPage.this.setDescription(UpdateUIMessages.InstallWizard_ReviewPage_desc);
                    ReviewPage.this.label.setText(UpdateUIMessages.InstallWizard_ReviewPage_label);
                } else {
                    if (ReviewPage.this.isUpdateSearch) {
                        ReviewPage.this.setDescription(UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates);
                    } else {
                        ReviewPage.this.setDescription(UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures);
                    }
                    ReviewPage.this.label.setText("");
                }
            }
        });
    }

    private void selectTrueUpdates() {
        ArrayList<IInstallFeatureOperation> trueUpdates = new ArrayList<IInstallFeatureOperation>();
        int i = 0;
        while (i < this.jobs.size()) {
            IInstallFeatureOperation job = (IInstallFeatureOperation)this.jobs.get(i);
            if (!UpdateUtils.isPatch(job.getFeature())) {
                trueUpdates.add(job);
            }
            ++i;
        }
        this.treeViewer.setCheckedElements(trueUpdates.toArray());
        this.validateSelection(new NullProgressMonitor());
    }

    public Control createContents(Composite parent) {
        Composite client = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        client.setLayout((Layout)layout);
        this.label = new Label(client, 0);
        this.label.setText(UpdateUIMessages.InstallWizard_ReviewPage_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.label.setLayoutData((Object)gd);
        this.createTreeViewer(client);
        Composite comp = new Composite(client, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite buttonContainer = new Composite(comp, 0);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        buttonContainer.setLayoutData((Object)new GridData(1808));
        Button button = new Button(buttonContainer, 8);
        button.setText(UpdateUIMessages.InstallWizard_ReviewPage_deselectAll);
        gd = new GridData(258);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleDeselectAll();
            }
        });
        this.moreInfoButton = new Button(buttonContainer, 8);
        this.moreInfoButton.setText(UpdateUIMessages.InstallWizard_ReviewPage_moreInfo);
        gd = new GridData(258);
        this.moreInfoButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.moreInfoButton);
        this.moreInfoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleMoreInfo();
            }
        });
        this.moreInfoButton.setEnabled(false);
        this.propertiesButton = new Button(buttonContainer, 8);
        this.propertiesButton.setText(UpdateUIMessages.InstallWizard_ReviewPage_properties);
        gd = new GridData(258);
        this.propertiesButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.propertiesButton);
        this.propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.handleProperties();
            }
        });
        this.propertiesButton.setEnabled(false);
        this.selectRequiredFeaturesButton = new Button(buttonContainer, 8);
        this.selectRequiredFeaturesButton.setText(UpdateUIMessages.InstallWizard_ReviewPage_selectRequired);
        gd = new GridData(258);
        this.selectRequiredFeaturesButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.selectRequiredFeaturesButton);
        this.selectRequiredFeaturesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)e.display, (Runnable)new Runnable(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        ReviewPage.access$16(6.access$0(this.this$1));
                        ReviewPage.access$17(6.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ ReviewPage access$0(6 var0) {
                return var0.ReviewPage.this;
            }
        });
        this.statusButton = new Button(buttonContainer, 8);
        this.statusButton.setText(UpdateUIMessages.InstallWizard_ReviewPage_showStatus);
        gd = new GridData(258);
        this.statusButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint(this.statusButton);
        this.statusButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewPage.this.showStatus();
            }
        });
        this.counterLabel = new Label(client, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.counterLabel.setLayoutData((Object)gd);
        this.filterOlderVersionCheck = new Button(client, 32);
        this.filterOlderVersionCheck.setText(UpdateUIMessages.InstallWizard_ReviewPage_filterOlderFeatures);
        this.filterOlderVersionCheck.setSelection(true);
        this.treeViewer.addFilter(this.olderVersionFilter);
        this.filterOlderVersionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IInstallFeatureOperation[] jobs = ReviewPage.this.getSelectedJobs();
                if (ReviewPage.this.filterOlderVersionCheck.getSelection()) {
                    ReviewPage.this.treeViewer.addFilter(ReviewPage.this.olderVersionFilter);
                } else {
                    ReviewPage.this.treeViewer.removeFilter(ReviewPage.this.olderVersionFilter);
                }
                ReviewPage.this.olderVersionFilter.setSelectedJobs(jobs);
                ReviewPage.this.pageChanged(jobs);
            }
        });
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.filterOlderVersionCheck.setLayoutData((Object)gd);
        this.filterCheck = new Button(client, 32);
        this.filterCheck.setText(UpdateUIMessages.InstallWizard_ReviewPage_filterFeatures);
        this.filterCheck.setSelection(false);
        this.filterCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IInstallFeatureOperation[] jobs = ReviewPage.this.getSelectedJobs();
                if (ReviewPage.this.filterCheck.getSelection()) {
                    if (ReviewPage.this.downloadIncludedFeatures()) {
                        ReviewPage.this.treeViewer.addFilter(ReviewPage.this.filter);
                    } else {
                        ReviewPage.this.filterCheck.setSelection(false);
                    }
                } else {
                    ReviewPage.this.treeViewer.removeFilter(ReviewPage.this.filter);
                }
                ReviewPage.this.filter.setSelectedJobs(jobs);
                ReviewPage.this.pageChanged(jobs);
            }
        });
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.filterCheck.setLayoutData((Object)gd);
        this.pageChanged();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, "org.eclipse.update.ui.MultiReviewPage2");
        Dialog.applyDialogFont((Control)parent);
        return client;
    }

    private void createTreeViewer(final Composite parent) {
        SashForm sform = new SashForm(parent, 512);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 100;
        sform.setLayoutData((Object)gd);
        this.treeViewer = new ContainerCheckedTreeViewer((Composite)sform, 2816);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider(new TreeContentProvider());
        this.treeViewer.setLabelProvider(new TreeLabelProvider());
        this.treeViewer.setInput(UpdateUI.getDefault().getUpdateModel());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ReviewPage.this.handleSelectionChanged((IStructuredSelection)e.getSelection());
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                try {
                    ReviewPage.this.getContainer().run(true, true, ReviewPage.this.getCheckStateOperation(event, parent.getDisplay()));
                    ReviewPage.this.getContainer().updateButtons();
                    ReviewPage.this.updateStatusButton();
                }
                catch (InvocationTargetException e) {
                    UpdateUI.logException(e);
                }
                catch (InterruptedException e) {
                    UpdateUI.logException(e);
                }
            }
        });
        this.descLabel = new ScrolledFormText((Composite)sform, true);
        this.descLabel.setText("");
        this.descLabel.setBackground(parent.getBackground());
        HyperlinkSettings settings = new HyperlinkSettings(parent.getDisplay());
        this.descLabel.getFormText().setHyperlinkSettings(settings);
        this.descLabel.getFormText().addHyperlinkListener(new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if (href == null) {
                    return;
                }
                try {
                    URL url = new URL(href.toString());
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                }
                catch (PartInitException ex) {
                    UpdateUI.logException(ex);
                }
                catch (MalformedURLException ex) {
                    UpdateUI.logException(ex);
                }
            }
        });
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        this.descLabel.setLayoutData(gd);
        sform.setWeights(new int[]{10, 2});
    }

    private IRunnableWithProgress getCheckStateOperation(final CheckStateChangedEvent event, final Display display) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(UpdateUIMessages.ReviewPage_validating, -1);
                ReviewPage.this.validateSelection(monitor);
                if (monitor.isCanceled()) {
                    ReviewPage.this.undoStateChange(event);
                    monitor.done();
                    return;
                }
                Object site = ReviewPage.this.getSite(event.getElement());
                ArrayList descendants = new ArrayList();
                ReviewPage.this.collectDescendants(site, descendants, monitor);
                Object[] nodes = new Object[descendants.size()];
                if (monitor.isCanceled()) {
                    ReviewPage.this.undoStateChange(event);
                    monitor.done();
                    return;
                }
                int i = 0;
                while (i < nodes.length) {
                    nodes[i] = descendants.get(i);
                    ++i;
                }
                display.syncExec(new Runnable(this, nodes){
                    final /* synthetic */ 14 this$1;
                    private final /* synthetic */ Object[] val$nodes;
                    {
                        this.this$1 = var1_1;
                        this.val$nodes = objectArray;
                    }

                    public void run() {
                        ReviewPage.access$1(14.access$0(this.this$1)).update(this.val$nodes, (String[])null);
                        ReviewPage.access$17(14.access$0(this.this$1));
                    }
                });
                monitor.done();
            }

            static /* synthetic */ ReviewPage access$0(14 var0) {
                return var0.ReviewPage.this;
            }
        };
    }

    private void undoStateChange(final CheckStateChangedEvent e) {
        this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                ReviewPage.this.treeViewer.setChecked(e.getElement(), !e.getChecked());
            }
        });
    }

    private void handleSelectionChanged(IStructuredSelection ssel) {
        Object item = ssel.getFirstElement();
        String description = null;
        if (item instanceof SiteBookmark) {
            description = ((SiteBookmark)item).getDescription();
        } else if (item instanceof SiteCategory) {
            IURLEntry descEntry = ((SiteCategory)item).getCategory().getDescription();
            if (descEntry != null) {
                description = descEntry.getAnnotation();
            }
        } else if (item instanceof IInstallFeatureOperation) {
            this.jobSelected(ssel);
            return;
        }
        if (description == null) {
            description = "";
        }
        this.updateDescription(description);
        this.propertiesButton.setEnabled(false);
        this.moreInfoButton.setEnabled(false);
    }

    private void jobSelected(IStructuredSelection selection) {
        IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
        IFeature feature = job != null ? job.getFeature() : null;
        IURLEntry descEntry = feature != null ? feature.getDescription() : null;
        String desc = null;
        if (descEntry != null) {
            desc = descEntry.getAnnotation();
        }
        if (desc == null) {
            desc = "";
        }
        this.updateDescription(desc);
        this.propertiesButton.setEnabled(feature != null);
        this.moreInfoButton.setEnabled(job != null && this.getMoreInfoURL(job) != null);
    }

    private void updateDescription(String text) {
        this.descLabel.getFormText().setText(UpdateManagerUtils.getWritableXMLString(text), false, true);
        this.descLabel.reflow(true);
    }

    private void pageChanged() {
        this.pageChanged(this.getSelectedJobs());
    }

    private void pageChanged(IInstallFeatureOperation[] jobsSelected) {
        if (jobsSelected.length == 0) {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
            this.setPageComplete(false);
            this.setValidationStatus(null);
            this.problematicFeatures.clear();
        }
        this.treeViewer.setCheckedElements(jobsSelected);
        this.treeViewer.refresh();
        this.treeViewer.setCheckedElements(jobsSelected);
        this.updateItemCount();
    }

    private void setValidationStatus(IStatus newValidationStatus) {
        this.validationStatus = newValidationStatus;
        this.updateStatusButton();
    }

    private void updateStatusButton() {
        this.statusButton.getDisplay().syncExec(new Runnable(){

            public void run() {
                boolean newState = ReviewPage.this.validationStatus != null && ReviewPage.this.validationStatus.getSeverity() != 0;
                ReviewPage.this.statusButton.setEnabled(newState);
            }
        });
    }

    private void updateItemCount() {
        this.updateItemCount(-1, -1);
    }

    private int getSelectedJobsUniqueCount() {
        IInstallFeatureOperation[] checkedElements = this.getSelectedJobs();
        HashSet<IFeature> set = new HashSet<IFeature>();
        int i = 0;
        while (i < checkedElements.length) {
            IInstallFeatureOperation job = checkedElements[i];
            IFeature feature = job.getFeature();
            if (!set.contains(feature)) {
                set.add(feature);
            }
            ++i;
        }
        return set.size();
    }

    private void updateItemCount(int checkedCount, int totalCount) {
        if (checkedCount == -1) {
            checkedCount = this.getSelectedJobsUniqueCount();
        }
        if (totalCount == -1) {
            totalCount = this.jobs.size();
        }
        String total = "" + totalCount;
        String selected = "" + checkedCount;
        this.counterLabel.setText(NLS.bind(UpdateUIMessages.InstallWizard_ReviewPage_counter, new String[]{selected, total}));
        this.counterLabel.getParent().layout();
    }

    private void handleDeselectAll() {
        IInstallFeatureOperation[] selectedJobs = this.getSelectedJobs();
        int i = 0;
        while (i < selectedJobs.length) {
            this.treeViewer.setChecked(selectedJobs[i], false);
            ++i;
        }
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ReviewPage.this.pageChanged();
            }
        });
    }

    private void handleProperties() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        final IInstallFeatureOperation job = (IInstallFeatureOperation)selection.getFirstElement();
        if (this.propertiesAction == null) {
            this.propertiesAction = new FeaturePropertyDialogAction(this.getShell(), this.treeViewer);
        }
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                SimpleFeatureAdapter adapter = new SimpleFeatureAdapter(job.getFeature());
                ReviewPage.this.propertiesAction.selectionChanged(new StructuredSelection(adapter));
                ReviewPage.this.propertiesAction.run();
            }
        });
    }

    private String getMoreInfoURL(IInstallFeatureOperation job) {
        IURLEntry desc = job.getFeature().getDescription();
        if (desc != null) {
            URL url = desc.getURL();
            return url == null ? null : url.toString();
        }
        return null;
    }

    private void handleMoreInfo() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        final IInstallFeatureOperation selectedJob = (IInstallFeatureOperation)selection.getFirstElement();
        BusyIndicator.showWhile((Display)this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                String urlName = ReviewPage.this.getMoreInfoURL(selectedJob);
                UpdateUI.showURL(urlName);
            }
        });
    }

    private IStatus selectRequiredFeatures() {
        IInstallFeatureOperation[] jobs = this.getSelectedJobs();
        OperationValidator.RequiredFeaturesResult requiredFeaturesResult = ((OperationValidator)OperationsManager.getValidator()).getRequiredFeatures(jobs);
        this.setValidationStatus(requiredFeaturesResult.getStatus());
        Set requiredFeatures = requiredFeaturesResult.getRequiredFeatures();
        this.problematicFeatures.clear();
        Iterator requiredFeaturesIterator = requiredFeatures.iterator();
        ArrayList<IInstallFeatureOperation> toBeInstalled = new ArrayList<IInstallFeatureOperation>();
        while (requiredFeaturesIterator.hasNext()) {
            IImport requiredFeature = ((OperationValidator.InternalImport)requiredFeaturesIterator.next()).getImport();
            IInstallFeatureOperation currentFeatureSelected = null;
            TreeItem[] items = this.treeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem[] siteRootContent = items[i].getItems();
                int j = 0;
                while (j < siteRootContent.length) {
                    if (siteRootContent[j].getData() instanceof SiteCategory) {
                        TreeItem[] features;
                        if (!this.treeViewer.getChecked(siteRootContent[j].getData())) {
                            this.treeViewer.createChildren((Widget)siteRootContent[j]);
                        }
                        if ((features = siteRootContent[j].getItems()).length > 0 && features[0].getData() == null) {
                            this.treeViewer.createChildren((Widget)siteRootContent[j]);
                            this.treeViewer.updateChildrenItems(siteRootContent[j]);
                            features = siteRootContent[j].getItems();
                        }
                        int k = 0;
                        while (k < features.length) {
                            currentFeatureSelected = this.decideOnFeatureSelection(requiredFeature, (IInstallFeatureOperation)features[k].getData(), currentFeatureSelected);
                            ++k;
                        }
                    } else if (siteRootContent[j].getData() instanceof IInstallFeatureOperation) {
                        currentFeatureSelected = this.decideOnFeatureSelection(requiredFeature, (IInstallFeatureOperation)siteRootContent[j].getData(), currentFeatureSelected);
                    }
                    ++j;
                }
                ++i;
            }
            if (currentFeatureSelected == null) continue;
            toBeInstalled.add(currentFeatureSelected);
        }
        if (!toBeInstalled.isEmpty()) {
            Iterator toBeInstalledIterator = toBeInstalled.iterator();
            while (toBeInstalledIterator.hasNext()) {
                IInstallFeatureOperation current = (IInstallFeatureOperation)toBeInstalledIterator.next();
                this.treeViewer.setChecked(current, true);
            }
            return this.selectRequiredFeatures();
        }
        this.problematicFeatures.clear();
        if (this.validationStatus != null) {
            IStatus[] status = this.validationStatus.getChildren();
            int i = 0;
            while (i < status.length) {
                IStatus singleStatus = status[i];
                if (this.isSpecificStatus(singleStatus)) {
                    IFeature f = ((FeatureStatus)singleStatus).getFeature();
                    this.problematicFeatures.add(f);
                }
                ++i;
            }
        }
        this.setPageComplete(this.validationStatus == null || this.validationStatus.getSeverity() == 2);
        this.lastDisplayedStatus = null;
        this.updateWizardMessage();
        this.treeViewer.update(this.getSelectedJobs(), (String[])null);
        return this.validationStatus;
    }

    public IInstallFeatureOperation[] getSelectedJobs() {
        Object[] selected = this.treeViewer.getCheckedElements();
        ArrayList<Object> selectedJobs = new ArrayList<Object>(selected.length);
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IInstallFeatureOperation) {
                selectedJobs.add(selected[i]);
            }
            ++i;
        }
        return selectedJobs.toArray(new IInstallFeatureOperation[selectedJobs.size()]);
    }

    public void validateSelection(IProgressMonitor monitor) {
        final IInstallFeatureOperation[][] bag = new IInstallFeatureOperation[1][];
        this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                bag[0] = ReviewPage.this.getSelectedJobs();
            }
        });
        if (monitor.isCanceled()) {
            return;
        }
        IInstallFeatureOperation[] jobs = bag[0];
        this.setValidationStatus(OperationsManager.getValidator().validatePendingChanges(jobs));
        this.problematicFeatures.clear();
        if (monitor.isCanceled()) {
            return;
        }
        if (this.validationStatus != null) {
            IStatus[] status = this.validationStatus.getChildren();
            int i = 0;
            while (i < status.length) {
                IStatus singleStatus = status[i];
                if (this.isSpecificStatus(singleStatus)) {
                    IFeature f = ((FeatureStatus)singleStatus).getFeature();
                    this.problematicFeatures.add(f);
                }
                ++i;
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                ReviewPage.this.setPageComplete(ReviewPage.this.validationStatus == null || ReviewPage.this.validationStatus.getSeverity() == 2);
                ReviewPage.this.updateWizardMessage();
            }
        });
    }

    private void showStatus() {
        if (this.validationStatus != null) {
            new StatusDialog().open();
        }
    }

    private boolean isSpecificStatus(IStatus status) {
        if (!(status instanceof FeatureStatus)) {
            return false;
        }
        if (status.getSeverity() != 4) {
            return false;
        }
        FeatureStatus featureStatus = (FeatureStatus)status;
        if (featureStatus.getFeature() == null) {
            return false;
        }
        return (featureStatus.getCode() & 0x3F) != 0;
    }

    private void updateWizardMessage() {
        if (this.validationStatus == null) {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
        } else if (this.validationStatus.getSeverity() == 2) {
            this.lastDisplayedStatus = null;
            this.setErrorMessage(null);
            this.setMessage(this.validationStatus.getMessage(), 2);
        } else {
            int s;
            IStatus[] status;
            if (this.newlySelectedFeature != null) {
                status = this.validationStatus.getChildren();
                s = 0;
                while (s < status.length) {
                    FeatureStatus featureStatus;
                    if (this.isSpecificStatus(status[s]) && this.newlySelectedFeature.equals((featureStatus = (FeatureStatus)status[s]).getFeature())) {
                        this.lastDisplayedStatus = featureStatus;
                        this.setErrorMessage(featureStatus.getMessage());
                        return;
                    }
                    ++s;
                }
            }
            if (this.lastDisplayedStatus != null) {
                status = this.validationStatus.getChildren();
                int i = 0;
                while (i < status.length) {
                    if (this.lastDisplayedStatus.equals(status[i])) {
                        return;
                    }
                    ++i;
                }
                this.lastDisplayedStatus = null;
            }
            status = this.validationStatus.getChildren();
            s = 0;
            while (s < status.length) {
                if (this.isSpecificStatus(status[s])) {
                    this.lastDisplayedStatus = (FeatureStatus)status[s];
                    this.setErrorMessage(status[s].getMessage());
                    return;
                }
                ++s;
            }
            if (status.length > 0) {
                IStatus singleStatus = status[0];
                this.setErrorMessage(singleStatus.getMessage());
            } else {
                this.setErrorMessage(UpdateUIMessages.InstallWizard_ReviewPage_invalid_long);
            }
        }
    }

    private boolean downloadIncludedFeatures() {
        try {
            Downloader downloader = new Downloader(this.jobs);
            this.getContainer().run(true, true, downloader);
            return !downloader.isCanceled();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private IInstallFeatureOperation findJob(FeatureReferenceAdapter feature) throws CoreException {
        if (this.jobs == null) {
            return null;
        }
        int i = 0;
        while (i < this.jobs.size()) {
            if (((IInstallFeatureOperation)this.jobs.get(i)).getFeature().getVersionedIdentifier().equals(feature.getFeatureReference().getVersionedIdentifier())) {
                return (IInstallFeatureOperation)this.jobs.get(i);
            }
            ++i;
        }
        return null;
    }

    private Object getSite(Object object) {
        ITreeContentProvider provider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        while (object != null && !(object instanceof SiteBookmark)) {
            object = provider.getParent(object);
        }
        return object;
    }

    private void collectDescendants(Object root, ArrayList list, IProgressMonitor monitor) {
        ITreeContentProvider provider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] children = provider.getChildren(root);
        if (children != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                if (monitor.isCanceled()) {
                    return;
                }
                list.add(children[i]);
                this.collectDescendants(children[i], list, monitor);
                ++i;
            }
        }
    }

    public boolean isFeatureGood(IImport requiredFeature, IFeature feature) {
        return this.isFeatureGood(requiredFeature, feature, new ArrayList());
    }

    public boolean isFeatureGood(IImport prereq, IFeature feature, List visitedFeatures) {
        if (prereq.getKind() == 1) {
            if (!prereq.getVersionedIdentifier().getIdentifier().equals(feature.getVersionedIdentifier().getIdentifier())) {
                IIncludedFeatureReference[] iifr = null;
                try {
                    iifr = feature.getIncludedFeatureReferences();
                }
                catch (CoreException e) {
                    UpdateUI.logException(e);
                    return false;
                }
                if (iifr == null) {
                    return false;
                }
                int i = 0;
                while (i < iifr.length) {
                    block17: {
                        IFeature current;
                        try {
                            current = UpdateUtils.getIncludedFeature(feature, iifr[i]);
                        }
                        catch (CoreException e) {
                            UpdateUI.logException(e);
                            break block17;
                        }
                        if (!visitedFeatures.contains(current)) {
                            visitedFeatures.add(current);
                            if (this.isFeatureGood(prereq, current, visitedFeatures)) {
                                return true;
                            }
                        }
                    }
                    ++i;
                }
                return false;
            }
            int rule = prereq.getRule() != 0 ? prereq.getRule() : 3;
            switch (rule) {
                case 1: {
                    return feature.getVersionedIdentifier().getVersion().isPerfect(prereq.getVersionedIdentifier().getVersion());
                }
                case 2: {
                    return feature.getVersionedIdentifier().getVersion().isEquivalentTo(prereq.getVersionedIdentifier().getVersion());
                }
                case 3: {
                    return feature.getVersionedIdentifier().getVersion().isCompatibleWith(prereq.getVersionedIdentifier().getVersion());
                }
                case 4: {
                    return feature.getVersionedIdentifier().getVersion().isGreaterOrEqualTo(prereq.getVersionedIdentifier().getVersion());
                }
            }
            return false;
        }
        if (prereq.getKind() == 0) {
            return this.checkIfFeatureHasPlugin(prereq, feature);
        }
        return false;
    }

    private boolean checkIfFeatureHasPlugin(IImport requiredFeature, IFeature feature) {
        IPluginEntry[] plugins = feature.getPluginEntries();
        try {
            List includedPlugins = this.getPluginEntriesFromIncludedFeatures(feature, new ArrayList(), new ArrayList());
            includedPlugins.addAll(Arrays.asList(plugins));
            plugins = includedPlugins.toArray(new IPluginEntry[includedPlugins.size()]);
        }
        catch (CoreException ce) {
            UpdateUI.logException(ce);
        }
        if (plugins == null) {
            return false;
        }
        int i = 0;
        while (i < plugins.length) {
            if (this.isMatch(plugins[i].getVersionedIdentifier(), requiredFeature.getVersionedIdentifier(), requiredFeature.getIdRule())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getPluginEntriesFromIncludedFeatures(IFeature feature, List plugins, List visitedFeatures) throws CoreException {
        IIncludedFeatureReference[] iifr = feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < iifr.length) {
            IFeature current = UpdateUtils.getIncludedFeature(feature, iifr[i]);
            if (!visitedFeatures.contains(current)) {
                IPluginEntry[] pluginEntries = current.getPluginEntries();
                plugins.addAll(Arrays.asList(pluginEntries));
                visitedFeatures.add(current);
                this.getPluginEntriesFromIncludedFeatures(current, plugins, visitedFeatures);
            }
            ++i;
        }
        return plugins;
    }

    private boolean isMatch(VersionedIdentifier vid1, VersionedIdentifier vid2, int rule) {
        if (!vid1.getIdentifier().equals(vid2.getIdentifier())) {
            return false;
        }
        if (vid2.getVersion().getMajorComponent() == 0 && vid2.getVersion().getMinorComponent() == 0 && vid2.getVersion().getServiceComponent() == 0) {
            return true;
        }
        switch (rule) {
            case 1: {
                return vid1.getVersion().isPerfect(vid2.getVersion());
            }
            case 2: {
                return vid1.getVersion().isEquivalentTo(vid2.getVersion());
            }
            case 3: {
                return vid1.getVersion().isCompatibleWith(vid2.getVersion());
            }
            case 4: {
                return vid1.getVersion().isGreaterOrEqualTo(vid2.getVersion());
            }
        }
        return false;
    }

    public boolean isFeatureBetter(IInstallFeatureOperation feature, IInstallFeatureOperation currentFeatureSelected) {
        if (currentFeatureSelected == null) {
            return true;
        }
        if (currentFeatureSelected.getFeature().getVersionedIdentifier().getIdentifier().equals(feature.getFeature().getVersionedIdentifier().getIdentifier())) {
            return !currentFeatureSelected.getFeature().getVersionedIdentifier().getVersion().isGreaterOrEqualTo(feature.getFeature().getVersionedIdentifier().getVersion());
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        int currentNumber = this.getTotalNumberOfPluginEntries(currentFeatureSelected.getFeature(), monitor);
        int newNumber = this.getTotalNumberOfPluginEntries(feature.getFeature(), monitor);
        return newNumber < currentNumber;
    }

    private int getTotalNumberOfPluginEntries(IFeature feature, IProgressMonitor monitor) {
        int count = 0;
        try {
            count = feature.getPluginEntryCount();
            IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < irefs.length) {
                IFeature child = irefs[i].getFeature(monitor);
                count += this.getTotalNumberOfPluginEntries(child, monitor);
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return count;
    }

    public IInstallFeatureOperation decideOnFeatureSelection(IImport requiredFeature, IInstallFeatureOperation feature, IInstallFeatureOperation currentFeatureSelected) {
        if (this.isFeatureGood(requiredFeature, feature.getFeature()) && this.isFeatureBetter(feature, currentFeatureSelected)) {
            return feature;
        }
        return currentFeatureSelected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFeatureProblematic(IFeature feature) {
        Iterator problematicFeatures;
        if (this.problematicFeatures.contains(feature)) {
            return true;
        }
        IImport[] iimports = feature.getImports();
        int i = 0;
        while (i < iimports.length) {
            problematicFeatures = this.problematicFeatures.iterator();
            while (problematicFeatures.hasNext()) {
                if (!iimports[i].getVersionedIdentifier().equals(((IFeature)problematicFeatures.next()).getVersionedIdentifier())) continue;
                return true;
            }
            ++i;
        }
        try {
            Iterator includedFeatures = OperationValidator.computeFeatureSubtree(feature, null, null, false, new ArrayList(), null).iterator();
            block4: while (true) {
                VersionedIdentifier currentProblematicFeaturesVI;
                Object currentProblematicFeatures;
                if (!includedFeatures.hasNext()) {
                    return false;
                }
                problematicFeatures = this.problematicFeatures.iterator();
                VersionedIdentifier currentIncludedFeaturesVI = ((IFeature)includedFeatures.next()).getVersionedIdentifier();
                do {
                    if (!problematicFeatures.hasNext()) continue block4;
                } while (!((currentProblematicFeatures = problematicFeatures.next()) instanceof IFeature) || !(currentProblematicFeaturesVI = ((IFeature)currentProblematicFeatures).getVersionedIdentifier()).equals(currentIncludedFeaturesVI));
                break;
            }
            return true;
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean isSelected(IInstallFeatureOperation[] selectedJobs, IInstallFeatureOperation iInstallFeatureOperation) {
        if (selectedJobs == null) {
            return false;
        }
        int i = 0;
        while (i < selectedJobs.length) {
            if (iInstallFeatureOperation.getFeature().getVersionedIdentifier().equals(selectedJobs[i].getFeature().getVersionedIdentifier()) && iInstallFeatureOperation.getFeature().getSite().getURL().equals(selectedJobs[i].getFeature().getSite().getURL())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ IStatus access$16(ReviewPage reviewPage) {
        return reviewPage.selectRequiredFeatures();
    }

    static /* synthetic */ void access$17(ReviewPage reviewPage) {
        reviewPage.updateItemCount();
    }

    class ContainmentFilter
    extends ViewerFilter {
        private IInstallFeatureOperation[] selectedJobs;

        ContainmentFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IInstallFeatureOperation) {
                return !this.isContained((IInstallFeatureOperation)element) || ReviewPage.this.isSelected(this.selectedJobs, (IInstallFeatureOperation)element);
            }
            if (element instanceof SiteCategory || element instanceof SiteBookmark) {
                Object[] children = ((ITreeContentProvider)((ContainerCheckedTreeViewer)viewer).getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select(viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private boolean isContained(IInstallFeatureOperation job) {
            VersionedIdentifier vid = job.getFeature().getVersionedIdentifier();
            int i = 0;
            while (i < ReviewPage.this.jobs.size()) {
                IFeature feature;
                IInstallFeatureOperation candidate = (IInstallFeatureOperation)ReviewPage.this.jobs.get(i);
                if (!candidate.equals(job) && this.includes(feature = candidate.getFeature(), vid, null)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean includes(IFeature feature, VersionedIdentifier vid, ArrayList cycleCandidates) {
            try {
                if (cycleCandidates == null) {
                    cycleCandidates = new ArrayList();
                }
                if (cycleCandidates.contains(feature)) {
                    throw Utilities.newCoreException(NLS.bind(UpdateUIMessages.InstallWizard_ReviewPage_cycle, feature.getVersionedIdentifier().toString()), null);
                }
                cycleCandidates.add(feature);
                IIncludedFeatureReference[] irefs = feature.getIncludedFeatureReferences();
                int i = 0;
                while (true) {
                    if (i >= irefs.length) {
                        return false;
                    }
                    IIncludedFeatureReference iref = irefs[i];
                    IFeature ifeature = UpdateUtils.getIncludedFeature(feature, iref);
                    VersionedIdentifier ivid = ifeature.getVersionedIdentifier();
                    if (ivid.equals(vid)) {
                        return true;
                    }
                    if (this.includes(ifeature, vid, cycleCandidates)) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                return false;
            }
            finally {
                cycleCandidates.remove(feature);
            }
        }

        public IInstallFeatureOperation[] getSelectedJobs() {
            return this.selectedJobs;
        }

        public void setSelectedJobs(IInstallFeatureOperation[] selectedJobs) {
            this.selectedJobs = selectedJobs;
        }
    }

    class Downloader
    implements IRunnableWithProgress {
        boolean canceled = false;
        ArrayList operations;

        public Downloader(ArrayList installOperations) {
            this.operations = installOperations;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int i = 0;
            while (i < this.operations.size()) {
                IInstallFeatureOperation candidate = (IInstallFeatureOperation)this.operations.get(i);
                IFeature feature = candidate.getFeature();
                try {
                    IIncludedFeatureReference[] irefs = feature.getRawIncludedFeatureReferences();
                    int f = 0;
                    while (f < irefs.length) {
                        if (monitor.isCanceled()) {
                            this.canceled = true;
                            return;
                        }
                        IIncludedFeatureReference iref = irefs[f];
                        iref.getFeature(monitor);
                        ++f;
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            if (monitor.isCanceled()) {
                this.canceled = true;
            }
        }
    }

    class FeaturePropertyDialogAction
    extends PropertyDialogAction {
        private IStructuredSelection selection;

        public FeaturePropertyDialogAction(Shell shell, ISelectionProvider provider) {
            super(shell, provider);
        }

        public IStructuredSelection getStructuredSelection() {
            return this.selection;
        }

        public void selectionChanged(IStructuredSelection selection) {
            this.selection = selection;
        }
    }

    class LatestVersionFilter
    extends ViewerFilter {
        private IInstallFeatureOperation[] selectedJobs;

        LatestVersionFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IInstallFeatureOperation) {
                return this.isLatestVersion((IInstallFeatureOperation)element) || ReviewPage.this.isSelected(this.selectedJobs, (IInstallFeatureOperation)element);
            }
            if (element instanceof SiteCategory || element instanceof SiteBookmark) {
                Object[] children = ((ITreeContentProvider)((ContainerCheckedTreeViewer)viewer).getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select(viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private boolean isLatestVersion(IInstallFeatureOperation job) {
            IFeature feature = job.getFeature();
            int i = 0;
            while (i < ReviewPage.this.jobs.size()) {
                IInstallFeatureOperation candidateJob = (IInstallFeatureOperation)ReviewPage.this.jobs.get(i);
                if (!candidateJob.equals(job)) {
                    IFeature candidate = candidateJob.getFeature();
                    if (feature.getSite() == job.getFeature().getSite() && feature.getVersionedIdentifier().getIdentifier().equals(candidate.getVersionedIdentifier().getIdentifier()) && !feature.getVersionedIdentifier().getVersion().isGreaterOrEqualTo(candidate.getVersionedIdentifier().getVersion())) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public IInstallFeatureOperation[] getSelectedJobs() {
            return this.selectedJobs;
        }

        public void setSelectedJobs(IInstallFeatureOperation[] selectedJobs) {
            this.selectedJobs = selectedJobs;
        }
    }

    class ModelListener
    implements IUpdateModelChangedListener {
        ModelListener() {
        }

        public void objectChanged(Object object, String property) {
            ReviewPage.this.treeViewer.refresh();
            this.checkItems();
        }

        public void objectsAdded(Object parent, Object[] children) {
            ReviewPage.this.treeViewer.refresh();
            this.checkItems();
        }

        public void objectsRemoved(Object parent, Object[] children) {
            ReviewPage.this.treeViewer.refresh();
            this.checkItems();
        }

        private void checkItems() {
            TreeItem[] items = ReviewPage.this.treeViewer.getTree().getItems();
            int i = 0;
            while (i < items.length) {
                SiteBookmark bookmark = (SiteBookmark)items[i].getData();
                ReviewPage.this.treeViewer.setChecked(bookmark, bookmark.isSelected());
                String[] ignoredCats = bookmark.getIgnoredCategories();
                ReviewPage.this.treeViewer.setGrayed(bookmark, ignoredCats.length > 0 && bookmark.isSelected());
                ++i;
            }
        }
    }

    class StatusDialog
    extends ErrorDialog {
        public StatusDialog() {
            super(ReviewPage.this.getContainer().getShell(), UpdateUIMessages.InstallWizard_ReviewPage_invalid_short, null, ReviewPage.this.validationStatus, 7);
        }

        public void create() {
            super.create();
            this.buttonPressed(13);
        }
    }

    class TreeContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return this.getSites();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof SiteBookmark) {
                SiteBookmark bookmark = (SiteBookmark)parent;
                bookmark.getSite(null);
                Object[] children = bookmark.getCatalog(true, null);
                ArrayList<Object> nonEmptyCategories = new ArrayList<Object>(children.length);
                int i = 0;
                while (i < children.length) {
                    if (this.hasChildren(children[i])) {
                        nonEmptyCategories.add(children[i]);
                    }
                    ++i;
                }
                return nonEmptyCategories.toArray();
            }
            if (parent instanceof SiteCategory) {
                SiteCategory category = (SiteCategory)parent;
                Object[] children = category.getChildren();
                ArrayList<IInstallFeatureOperation> list = new ArrayList<IInstallFeatureOperation>(children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof FeatureReferenceAdapter) {
                        try {
                            IInstallFeatureOperation job = ReviewPage.this.findJob((FeatureReferenceAdapter)children[i]);
                            if (job != null) {
                                list.add(job);
                            }
                        }
                        catch (CoreException e) {
                            UpdateCore.log(e.getStatus());
                        }
                    }
                    ++i;
                }
                return list.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof SiteCategory) {
                return ((SiteCategory)element).getBookmark();
            }
            if (element instanceof IInstallFeatureOperation) {
                IFeature f = ((IInstallFeatureOperation)element).getFeature();
                ISiteFeatureReference fr = f.getSite().getFeatureReference(f);
                ICategory[] categories = fr.getCategories();
                SiteBookmark[] sites = (SiteBookmark[])((ITreeContentProvider)ReviewPage.this.treeViewer.getContentProvider()).getElements(null);
                int i = 0;
                while (i < sites.length) {
                    block10: {
                        block9: {
                            try {
                                ExtendedSite site;
                                IURLEntry siteMirror;
                                if (sites[i].getSite(false, null).getURL() == f.getSite().getSiteContentProvider().getURL() || sites[i].getSite(false, null) instanceof ExtendedSite && (siteMirror = (site = (ExtendedSite)sites[i].getSite(false, null)).getSelectedMirror()) != null && siteMirror.getURL().toExternalForm().equals(f.getSite().getSiteContentProvider().getURL().toExternalForm())) break block9;
                                break block10;
                            }
                            catch (CoreException coreException) {
                                return null;
                            }
                        }
                        Object[] children = sites[i].getCatalog(true, null);
                        int j = 0;
                        while (j < children.length) {
                            if (children[j] instanceof SiteCategory) {
                                int c = 0;
                                while (c < categories.length) {
                                    if (categories[c].getName().equals(((SiteCategory)children[j]).getName())) {
                                        return children[j];
                                    }
                                    ++c;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SiteBookmark || element instanceof SiteCategory && this.getChildren(element).length > 0;
        }

        private SiteBookmark[] getSites() {
            if (ReviewPage.this.searchRequest == null) {
                return new SiteBookmark[0];
            }
            if (ReviewPage.this.searchRequest.getScope().getSearchSites() == null || ReviewPage.this.searchRequest.getScope().getSearchSites().length == 0) {
                if (ReviewPage.this.jobs != null) {
                    ArrayList<SiteBookmark> sitesList = new ArrayList<SiteBookmark>(ReviewPage.this.jobs.size());
                    int i = 0;
                    while (i < ReviewPage.this.jobs.size()) {
                        SiteBookmark bookmark;
                        IInstallFeatureOperation op = (IInstallFeatureOperation)ReviewPage.this.jobs.get(i);
                        String label = null;
                        IFeature[] existingFeatures = UpdateUtils.getInstalledFeatures(op.getFeature(), true);
                        if (existingFeatures != null && existingFeatures.length > 0) {
                            IURLEntry entry = op.getFeature().getUpdateSiteEntry();
                            label = entry.getAnnotation();
                        }
                        if (label == null) {
                            label = op.getFeature().getSite().getURL().toExternalForm();
                        }
                        if (!sitesList.contains(bookmark = new SiteBookmark(label, op.getFeature().getSite().getURL(), false))) {
                            sitesList.add(bookmark);
                        }
                        ++i;
                    }
                    if (!sitesList.isEmpty()) {
                        return sitesList.toArray(new SiteBookmark[sitesList.size()]);
                    }
                }
                return new SiteBookmark[0];
            }
            IUpdateSearchSite[] sites = ReviewPage.this.searchRequest.getScope().getSearchSites();
            SiteBookmark[] siteBookmarks = new SiteBookmark[sites.length];
            int i = 0;
            while (i < sites.length) {
                siteBookmarks[i] = new SiteBookmark(sites[i].getLabel(), sites[i].getURL(), false);
                ++i;
            }
            return siteBookmarks;
        }
    }

    class TreeLabelProvider
    extends SharedLabelProvider {
        TreeLabelProvider() {
        }

        public Image getImage(Object obj) {
            if (obj instanceof SiteBookmark) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_SITE_OBJ);
            }
            if (obj instanceof SiteCategory) {
                return UpdateUI.getDefault().getLabelProvider().get(UpdateUIImages.DESC_CATEGORY_OBJ);
            }
            if (obj instanceof IInstallFeatureOperation) {
                boolean problematic;
                IFeature feature = ((IInstallFeatureOperation)obj).getFeature();
                boolean patch = feature.isPatch();
                boolean featureIsProblematic = ReviewPage.this.isFeatureProblematic(feature);
                boolean bl = problematic = ReviewPage.this.treeViewer.getChecked(obj) && featureIsProblematic;
                if (!problematic && featureIsProblematic) {
                    Object parent = ((TreeContentProvider)ReviewPage.this.treeViewer.getContentProvider()).getParent(obj);
                    boolean bl2 = problematic = ReviewPage.this.treeViewer.getChecked(parent) && !ReviewPage.this.treeViewer.getGrayed(parent);
                }
                if (patch) {
                    return this.get(UpdateUIImages.DESC_EFIX_OBJ, problematic ? 1 : 0);
                }
                return this.get(UpdateUIImages.DESC_FEATURE_OBJ, problematic ? 1 : 0);
            }
            return super.getImage(obj);
        }

        public String getText(Object obj) {
            if (obj instanceof SiteBookmark) {
                return ((SiteBookmark)obj).getLabel();
            }
            if (obj instanceof IInstallFeatureOperation) {
                IInstallFeatureOperation job = (IInstallFeatureOperation)obj;
                IFeature feature = job.getFeature();
                return String.valueOf(feature.getLabel()) + " " + feature.getVersionedIdentifier().getVersion().toString();
            }
            return super.getText(obj);
        }
    }
}

