/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.resultchecker;

import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.data.Argument;
import com.savvytest.eclipse.core.model.xml.data.Array;
import com.savvytest.eclipse.core.model.xml.data.Boolean;
import com.savvytest.eclipse.core.model.xml.data.DataPackage;
import com.savvytest.eclipse.core.model.xml.data.InputOutputDualism;
import com.savvytest.eclipse.core.model.xml.data.Number;
import com.savvytest.eclipse.core.model.xml.data.String;
import com.savvytest.eclipse.core.model.xml.data.Struct;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.testcase.Checkcondition;
import com.savvytest.eclipse.core.model.xml.testcase.Testcase;
import com.savvytest.eclipse.core.model.xml.testsuite.Testsuite;
import com.savvytest.eclipse.resultchecker.ResultCheckerValidationException;
import com.savvytest.eclipse.resultchecker.ResultcheckerException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class JexlTestcase {
    private static final Pattern NUMBERS_PATTERN = Pattern.compile("(^|[ \\t])([-+]?(\\d+|\\.\\d+|\\d+\\.\\d*))($|[^+-.])");
    private Map<java.lang.String, Object> properties;
    private final Map<java.lang.String, Object> vars;
    private final Testcase testcase;
    private final Map<java.lang.String, Object> input;
    private final Map<java.lang.String, Object> output;
    private Map<java.lang.String, Object> result;
    private InputOutputDualism currentSelection;

    public JexlTestcase(Testcase testcase) throws ResultcheckerException {
        this(testcase, null);
    }

    public JexlTestcase(Testcase testscenarioDef, Testsuite suite) throws ResultcheckerException {
        this.testcase = testscenarioDef;
        this.input = new HashMap<java.lang.String, Object>();
        this.output = new HashMap<java.lang.String, Object>();
        this.result = new HashMap<java.lang.String, Object>();
        this.vars = this.buildPropertiesMap(this.testcase.getProperties());
        if (suite != null) {
            this.properties = this.buildPropertiesMap(suite.getProperties());
        }
    }

    public static JexlTestcase getJexlTestcaseFromFirstStruct(Testcase testcase) throws ResultcheckerException {
        JexlTestcase jexlTestcase = new JexlTestcase(testcase);
        jexlTestcase.initWirhFirstStruct();
        return jexlTestcase;
    }

    public static JexlTestcase getJexlTestcaseFromArgument(Testcase testcase) throws ResultcheckerException {
        JexlTestcase jexlTestcase = new JexlTestcase(testcase);
        jexlTestcase.initWithArgument();
        return jexlTestcase;
    }

    private void initWirhFirstStruct() throws ResultcheckerException {
        FeatureMap.Entry firstEntry;
        Struct firstStruct;
        Argument firstArgument = (Argument)this.testcase.getInputUi().get(0);
        FeatureMap.Entry firstEntry2 = (FeatureMap.Entry)firstArgument.getParameters().getParameters().get(0);
        if (firstEntry2.getValue() instanceof Struct) {
            firstStruct = (Struct)firstEntry2.getValue();
            this.currentSelection = InputOutputDualism.INPUT;
            this.input.put(firstStruct.getName(), this.getStructValue(firstStruct));
        }
        if ((firstEntry2 = (FeatureMap.Entry)(firstArgument = (Argument)this.testcase.getOutputUi(true).get(0)).getParameters().getParameters().get(0)).getValue() instanceof Struct) {
            firstStruct = (Struct)firstEntry2.getValue();
            this.currentSelection = InputOutputDualism.OUTPUT;
            this.output.put(firstStruct.getName(), this.getStructValue(firstStruct));
        }
        if (this.testcase.getResultUi() != null && (firstEntry = (FeatureMap.Entry)this.testcase.getResultUi().getParameters().getParameters().get(0)).getValue() instanceof Struct) {
            Struct firstStruct2 = (Struct)firstEntry.getValue();
            this.result.put(firstStruct2.getName(), this.getStructValue(firstStruct2));
        }
    }

    private void initWithArgument() throws ResultcheckerException {
        Argument arg;
        int i = 0;
        while (i < this.testcase.getInputUi().size()) {
            arg = (Argument)this.testcase.getInputUi().get(i);
            this.currentSelection = InputOutputDualism.INPUT;
            this.input.put("arg" + i, this.getMapForArgument(arg));
            ++i;
        }
        i = 0;
        while (i < this.testcase.getOutputUi().size()) {
            arg = (Argument)this.testcase.getOutputUi().get(i);
            this.currentSelection = InputOutputDualism.OUTPUT;
            this.output.put("arg" + i, this.getMapForArgument(arg));
            ++i;
        }
        if (this.testcase.getResult() != null) {
            this.currentSelection = null;
            this.result = this.getMapForArgument(this.testcase.getResultUi());
        }
    }

    private Map<java.lang.String, Object> getMapForArgument(Argument argument) throws ResultCheckerValidationException {
        HashMap<java.lang.String, Object> map = new HashMap<java.lang.String, Object>();
        for (Number number : argument.getParameters().getNumber()) {
            map.put(number.getName(), this.getNumberValue(number));
        }
        for (String string : argument.getParameters().getString()) {
            map.put(string.getName(), this.getStringValue(string));
        }
        for (Array array : argument.getParameters().getArray()) {
            map.put(array.getName(), this.getArrayValue(array));
        }
        for (Struct struct : argument.getParameters().getStruct()) {
            map.put(struct.getName(), this.getStructValue(struct));
        }
        return map;
    }

    private List<? extends Object> getArrayValue(Array array) throws ResultCheckerValidationException {
        if (!array.getElements().isEmpty()) {
            EStructuralFeature feature = array.getElements().getEStructuralFeature(0);
            if (DataPackage.Literals.CONTAINER_DATA__STRING.equals(feature)) {
                return this.getStringList((List<? extends String>)array.getString());
            }
            if (DataPackage.Literals.CONTAINER_DATA__NUMBER.equals(feature)) {
                return this.getNumberList((List<? extends Number>)array.getNumber());
            }
            if (DataPackage.Literals.CONTAINER_DATA__STRUCT.equals(feature)) {
                ArrayList<Object> list = new ArrayList<Object>(array.getStruct().size());
                ListIterator iterator = array.getStruct().listIterator();
                while (iterator.hasNext()) {
                    Struct struct = (Struct)iterator.next();
                    list.add(this.getStructValue(struct));
                }
                return list;
            }
            if (DataPackage.Literals.CONTAINER_DATA__ARRAY.equals(feature)) {
                ArrayList<List<? extends Object>> list = new ArrayList<List<? extends Object>>(array.getArray().size());
                ListIterator iterator = array.getArray().listIterator();
                while (iterator.hasNext()) {
                    Array innerArray = (Array)iterator.next();
                    list.add(this.getArrayValue(innerArray));
                }
                return list;
            }
            throw new ResultCheckerValidationException("unknown Array type " + array.getClass());
        }
        return Collections.emptyList();
    }

    private List<? extends Object> getStringList(List<? extends String> list) throws ResultCheckerValidationException {
        ArrayList<java.lang.String> l = new ArrayList<java.lang.String>(list.size());
        for (String string : list) {
            l.add(this.getStringValue(string));
        }
        return l;
    }

    private List<? extends Object> getNumberList(List<? extends Number> list) throws ResultCheckerValidationException {
        ArrayList<BigDecimal> l = new ArrayList<BigDecimal>(list.size());
        for (Number number : list) {
            l.add(this.getNumberValue(number));
        }
        return l;
    }

    private Object getStructValue(Struct struct) throws ResultCheckerValidationException {
        HashMap<java.lang.String, Object> map = new HashMap<java.lang.String, Object>();
        for (FeatureMap.Entry entry : struct.getElements()) {
            EStructuralFeature feature = entry.getEStructuralFeature();
            if (DataPackage.Literals.CONTAINER_DATA__STRING.equals(feature)) {
                String string = (String)entry.getValue();
                map.put(string.getName(), this.getStringValue(string));
                continue;
            }
            if (DataPackage.Literals.CONTAINER_DATA__NUMBER.equals(feature)) {
                Number number = (Number)entry.getValue();
                map.put(number.getName(), this.getNumberValue(number));
                continue;
            }
            if (DataPackage.Literals.CONTAINER_DATA__BOOLEAN.equals(feature)) {
                Boolean bool = (Boolean)entry.getValue();
                map.put(bool.getName(), this.getBooleanValue(bool));
                continue;
            }
            if (DataPackage.Literals.CONTAINER_DATA__STRUCT.equals(feature)) {
                Struct s = (Struct)entry.getValue();
                map.put(s.getName(), this.getStructValue(s));
                continue;
            }
            if (DataPackage.Literals.CONTAINER_DATA__ARRAY.equals(feature)) {
                Array array = (Array)entry.getValue();
                map.put(array.getName(), this.getArrayValue(array));
                continue;
            }
            throw new ResultCheckerValidationException("unknown Struct element type " + entry.getValue());
        }
        return map;
    }

    private java.lang.Boolean getBooleanValue(Boolean bool) {
        if (InputOutputDualism.INPUT.equals((Object)this.currentSelection)) {
            return bool.getEffectiveValue();
        }
        return bool.getValue();
    }

    private BigDecimal getNumberValue(Number number) {
        if (InputOutputDualism.INPUT.equals((Object)this.currentSelection)) {
            return number.getEffectiveValue();
        }
        return number.getValue();
    }

    private java.lang.String getStringValue(String string) {
        if (InputOutputDualism.INPUT.equals((Object)this.currentSelection)) {
            return string.getEffectiveValue();
        }
        return string.getValue();
    }

    public java.lang.String getName() {
        return this.testcase.getName();
    }

    private Map<java.lang.String, Object> buildPropertiesMap(Properties properties) throws ResultCheckerValidationException {
        HashMap<java.lang.String, Object> map = new HashMap<java.lang.String, Object>();
        if (properties != null && properties.getProperties() != null) {
            for (Property property : properties.getProperties()) {
                java.lang.String name = property.getName();
                Object value = null;
                if ("number".equalsIgnoreCase(property.getType())) {
                    value = this.convertToNumber(property.getValue());
                    if (value == null) {
                        throw new ResultCheckerValidationException("property '" + name + "' of type '" + property.getType() + "' has an invalid value of '" + property.getValue());
                    }
                } else if ("boolean".equalsIgnoreCase(property.getType())) {
                    value = this.convertToBoolean(property.getValue());
                    if (value == null) {
                        throw new ResultCheckerValidationException("property '" + name + "' of type '" + property.getType() + "' has an invalid value of '" + property.getValue());
                    }
                } else {
                    value = property.getValue();
                }
                map.put(name, value);
            }
        }
        return map;
    }

    private java.lang.Boolean convertToBoolean(java.lang.String number) {
        if ("true".equalsIgnoreCase(number)) {
            return java.lang.Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(number)) {
            return java.lang.Boolean.FALSE;
        }
        return null;
    }

    private BigDecimal convertToNumber(java.lang.String number) {
        Matcher m = NUMBERS_PATTERN.matcher(number);
        boolean matches = m.matches();
        if (matches) {
            return new BigDecimal(number);
        }
        return null;
    }

    public JexlContext getJexlContext() {
        JexlContext context = JexlHelper.createContext();
        context.getVars().put("input", this.input);
        context.getVars().put("output", this.output);
        context.getVars().put("properties", this.properties);
        context.getVars().put("result", this.result);
        return context;
    }

    public List<Expression> getJexlExpressions() throws ResultCheckerValidationException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (FeatureMap.Entry entry : this.testcase.getCheckconditions().getCheckconditions()) {
            Checkcondition checkcondition = (Checkcondition)entry.getValue();
            try {
                expressions.add(ExpressionFactory.createExpression((java.lang.String)checkcondition.getExpression()));
            }
            catch (Exception exception) {
                throw new ResultCheckerValidationException("Error in creating Expression '" + checkcondition.getExpression() + "'");
            }
        }
        return expressions;
    }

    public Map<java.lang.String, Object> getInput() {
        return this.input;
    }

    public Map<java.lang.String, Object> getOutput() {
        return this.output;
    }

    public Map<java.lang.String, Object> getResult() {
        return this.result;
    }

    public Map<java.lang.String, Object> getProperties() {
        return this.properties;
    }

    public Map<java.lang.String, Object> getVars() {
        return this.vars;
    }

    public Testcase getTestcase() {
        return this.testcase;
    }

    public void print() {
        if (SavvytestSettings.INSTANCE.getLogLevel().ordinal() > LogLevel.DEBUG.ordinal()) {
            return;
        }
        StringBuilder builder = new StringBuilder(8192);
        builder.append("\n=== INPUT ===\n\n");
        this.printMap(this.input, "", builder);
        builder.append("\n");
        builder.append("=== OUTPUT ===\n\n");
        this.printMap(this.output, "", builder);
        builder.append("\n");
        builder.append("=== RESULT ===\n\n");
        this.printMap(this.result, "", builder);
        builder.append("\n");
        builder.append("=== VARS ===\n\n");
        this.printMap(this.vars, "", builder);
        builder.append("\n");
        SavvytestSettings.INSTANCE.getLogger().log(builder.toString(), LogLevel.DEBUG, (Object)this);
    }

    private void printMap(Map<java.lang.String, Object> map, java.lang.String indent, StringBuilder builder) {
        for (java.lang.String key : map.keySet()) {
            builder.append(indent);
            builder.append(key);
            builder.append(": ");
            Object value = map.get(key);
            if (value instanceof Map) {
                builder.append("\n");
                this.printMap((Map)value, java.lang.String.valueOf(indent) + "  ", builder);
                continue;
            }
            if (value instanceof List) {
                builder.append("\n");
                this.printList((List)value, java.lang.String.valueOf(indent) + "  ", builder);
                continue;
            }
            if (value != null) {
                builder.append(value);
                builder.append(" <");
                builder.append(value.getClass().getSimpleName());
                builder.append(">\n");
                continue;
            }
            builder.append("<NULL>\n");
        }
    }

    private void printList(List<Object> list, java.lang.String indent, StringBuilder builder) {
        int i = 0;
        while (i < list.size()) {
            Object element = list.get(i);
            builder.append(indent);
            builder.append("[");
            builder.append(i);
            builder.append("]:\n");
            if (element instanceof Map) {
                this.printMap((Map)element, java.lang.String.valueOf(indent) + "  ", builder);
            } else if (element instanceof List) {
                this.printList((List)element, java.lang.String.valueOf(indent) + "  ", builder);
            } else if (element != null) {
                builder.append(element);
                builder.append(" <");
                builder.append(element.getClass().getSimpleName());
                builder.append(">\n");
            } else {
                builder.append("<NULL>\n");
            }
            ++i;
        }
    }
}

