/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.model.wadl.util;

import com.savvytest.eclipse.wadl.model.wadl.ApplicationType;
import com.savvytest.eclipse.wadl.model.wadl.DocType;
import com.savvytest.eclipse.wadl.model.wadl.DocumentRoot;
import com.savvytest.eclipse.wadl.model.wadl.GrammarsType;
import com.savvytest.eclipse.wadl.model.wadl.HTTPMethods;
import com.savvytest.eclipse.wadl.model.wadl.IncludeType;
import com.savvytest.eclipse.wadl.model.wadl.LinkType;
import com.savvytest.eclipse.wadl.model.wadl.MethodType;
import com.savvytest.eclipse.wadl.model.wadl.OptionType;
import com.savvytest.eclipse.wadl.model.wadl.ParamStyle;
import com.savvytest.eclipse.wadl.model.wadl.ParamType;
import com.savvytest.eclipse.wadl.model.wadl.RepresentationType;
import com.savvytest.eclipse.wadl.model.wadl.RequestType;
import com.savvytest.eclipse.wadl.model.wadl.ResourceType;
import com.savvytest.eclipse.wadl.model.wadl.ResourceTypeType;
import com.savvytest.eclipse.wadl.model.wadl.ResourcesType;
import com.savvytest.eclipse.wadl.model.wadl.ResponseType;
import com.savvytest.eclipse.wadl.model.wadl.WadlPackage;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

public class WadlValidator
extends EObjectValidator {
    public static final WadlValidator INSTANCE = new WadlValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.savvytest.eclipse.wadl.model.wadl";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return WadlPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateApplicationType((ApplicationType)value, diagnostics, context);
            }
            case 1: {
                return this.validateDocType((DocType)value, diagnostics, context);
            }
            case 2: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 3: {
                return this.validateGrammarsType((GrammarsType)value, diagnostics, context);
            }
            case 4: {
                return this.validateIncludeType((IncludeType)value, diagnostics, context);
            }
            case 5: {
                return this.validateLinkType((LinkType)value, diagnostics, context);
            }
            case 6: {
                return this.validateMethodType((MethodType)value, diagnostics, context);
            }
            case 7: {
                return this.validateOptionType((OptionType)value, diagnostics, context);
            }
            case 8: {
                return this.validateParamType((ParamType)value, diagnostics, context);
            }
            case 9: {
                return this.validateRepresentationType((RepresentationType)value, diagnostics, context);
            }
            case 10: {
                return this.validateRequestType((RequestType)value, diagnostics, context);
            }
            case 11: {
                return this.validateResourcesType((ResourcesType)value, diagnostics, context);
            }
            case 12: {
                return this.validateResourceType((ResourceType)value, diagnostics, context);
            }
            case 13: {
                return this.validateResourceTypeType((ResourceTypeType)value, diagnostics, context);
            }
            case 14: {
                return this.validateResponseType((ResponseType)value, diagnostics, context);
            }
            case 15: {
                return this.validateHTTPMethods((HTTPMethods)((Object)value), diagnostics, context);
            }
            case 16: {
                return this.validateParamStyle((ParamStyle)((Object)value), diagnostics, context);
            }
            case 17: {
                return this.validateHTTPMethodsObject((HTTPMethods)((Object)value), diagnostics, context);
            }
            case 18: {
                return this.validateMethod(value, diagnostics, context);
            }
            case 19: {
                return this.validateParamStyleObject((ParamStyle)((Object)value), diagnostics, context);
            }
            case 20: {
                return this.validateResourceTypeList((List)value, diagnostics, context);
            }
            case 21: {
                return this.validateStatusCodeList((List)value, diagnostics, context);
            }
            case 22: {
                return this.validateUriList((List)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateApplicationType(ApplicationType applicationType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(applicationType, diagnostics, context);
    }

    public boolean validateDocType(DocType docType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(docType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateGrammarsType(GrammarsType grammarsType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(grammarsType, diagnostics, context);
    }

    public boolean validateIncludeType(IncludeType includeType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(includeType, diagnostics, context);
    }

    public boolean validateLinkType(LinkType linkType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(linkType, diagnostics, context);
    }

    public boolean validateMethodType(MethodType methodType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(methodType, diagnostics, context);
    }

    public boolean validateOptionType(OptionType optionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(optionType, diagnostics, context);
    }

    public boolean validateParamType(ParamType paramType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(paramType, diagnostics, context);
    }

    public boolean validateRepresentationType(RepresentationType representationType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(representationType, diagnostics, context);
    }

    public boolean validateRequestType(RequestType requestType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(requestType, diagnostics, context);
    }

    public boolean validateResourcesType(ResourcesType resourcesType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(resourcesType, diagnostics, context);
    }

    public boolean validateResourceType(ResourceType resourceType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(resourceType, diagnostics, context);
    }

    public boolean validateResourceTypeType(ResourceTypeType resourceTypeType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(resourceTypeType, diagnostics, context);
    }

    public boolean validateResponseType(ResponseType responseType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(responseType, diagnostics, context);
    }

    public boolean validateHTTPMethods(HTTPMethods httpMethods, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateParamStyle(ParamStyle paramStyle, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateHTTPMethodsObject(HTTPMethods httpMethodsObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateMethod(Object method, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateMethod_MemberTypes(method, diagnostics, context);
        return result;
    }

    public boolean validateMethod_MemberTypes(Object method, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (WadlPackage.Literals.HTTP_METHODS.isInstance(method) && this.validateHTTPMethods((HTTPMethods)((Object)method), (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.NMTOKEN.isInstance(method) && this.xmlTypeValidator.validateNMTOKEN((String)method, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (WadlPackage.Literals.HTTP_METHODS.isInstance(method) && this.validateHTTPMethods((HTTPMethods)((Object)method), null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.NMTOKEN.isInstance(method) && this.xmlTypeValidator.validateNMTOKEN((String)method, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateParamStyleObject(ParamStyle paramStyleObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateResourceTypeList(List<?> resourceTypeList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateResourceTypeList_ItemType(resourceTypeList, diagnostics, context);
        return result;
    }

    public boolean validateResourceTypeList_ItemType(List<?> resourceTypeList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = resourceTypeList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.ANY_URI.isInstance(item)) {
                result &= this.xmlTypeValidator.validateAnyURI((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.ANY_URI, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateStatusCodeList(List<?> statusCodeList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStatusCodeList_ItemType(statusCodeList, diagnostics, context);
        return result;
    }

    public boolean validateStatusCodeList_ItemType(List<?> statusCodeList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = statusCodeList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.UNSIGNED_INT.isInstance(item)) {
                result &= this.xmlTypeValidator.validateUnsignedInt(((Long)item).longValue(), diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.UNSIGNED_INT, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateUriList(List<?> uriList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateUriList_ItemType(uriList, diagnostics, context);
        return result;
    }

    public boolean validateUriList_ItemType(List<?> uriList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = uriList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.ANY_URI.isInstance(item)) {
                result &= this.xmlTypeValidator.validateAnyURI((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.ANY_URI, item, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

