/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard.page;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.page.ListructureContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public abstract class AbstractImportInfoPage
extends SavvytestFileSelectionPage {
    private final ImportInfo info;
    private final Listructure originalListructure;
    private boolean inactive;

    protected static final String createDefaultFilename(ImportInfo info, String suffix) {
        StringBuilder builder = new StringBuilder(100);
        if (info.relativePath != null) {
            int index = info.relativePath.indexOf(47);
            if (index != -1) {
                builder.append(info.relativePath, 0, index);
            } else {
                builder.append(info.relativePath);
            }
        }
        if (builder.length() == 0) {
            builder.append("undefinedPathName");
        }
        if (builder.charAt(0) == '{') {
            builder.deleteCharAt(0);
        }
        if (builder.charAt(builder.length() - 1) == '}') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append('.');
        if (info.methodId != null && !info.methodId.isEmpty()) {
            builder.append(info.methodId);
        } else {
            builder.append((Object)info.methodType);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }

    protected static final TreeViewer createListructureViewer(Composite parent, Font font, Color color) {
        TreeViewer listructureViewer = new TreeViewer(parent, 2560);
        listructureViewer.setAutoExpandLevel(-1);
        Tree listructureTree = listructureViewer.getTree();
        listructureTree.setFont(font);
        listructureTree.setForeground(color);
        ListructureContentProvider contentProvider = new ListructureContentProvider();
        listructureViewer.setContentProvider((IContentProvider)contentProvider);
        listructureViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(contentProvider.getAdapterFactory()){

            public String getText(Object object) {
                return this.getColumnText(object, 0);
            }
        });
        return listructureViewer;
    }

    protected static final Button createCreationButton(Composite parent, final ImportInfo.DefaultInfo info, final Listructure listructure, String text, Font font, Color color) {
        final Button button = new Button(parent, 32);
        button.setText(text);
        button.setSelection(info.create);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                info.create = button.getSelection();
                if (info.create && listructure != null) {
                    info.listructure = listructure;
                    info.listructure.setId(EditingUtility.getIdForFile((IFile)info.parametersFile));
                } else {
                    info.listructure = null;
                }
            }
        });
        return button;
    }

    protected AbstractImportInfoPage(ImportInfo info, String pageName, String initialFilename) {
        super(String.valueOf(pageName) + " " + info.getMethodDescription(), 8192);
        this.info = info;
        this.originalListructure = this.getSubInfo() == null ? null : this.getSubInfo().listructure;
        this.getFileSelectionComponent().setTypes(new SavvytestTypeEnum[]{this.getType()});
        this.getFileSelectionComponent().setInitialFilename(initialFilename);
    }

    protected abstract SavvytestTypeEnum getType();

    protected abstract ImportInfo.DefaultInfo getSubInfo();

    protected String checkFileOverwrite(IFile file) {
        if (this.getSubInfo() != null && !this.getSubInfo().create) {
            return null;
        }
        return super.checkFileOverwrite(file);
    }

    protected String checkFileExistence(IFile file) {
        if (this.getSubInfo() != null && !this.getSubInfo().create) {
            if (file == null) {
                return Savvytest.getString((String)"com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage.errors.null", (Object[])new Object[0]);
            }
            if (!file.exists()) {
                return Savvytest.getString((String)"com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage.errors.exists", (Object[])new Object[]{file.getFullPath()});
            }
        }
        return super.checkFileExistence(file);
    }

    public boolean isPageComplete() {
        return this.inactive || super.isPageComplete();
    }

    private IFolder adaptSelection(ISelection selection, SavvytestTypeEnum type) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            IFolder folder;
            IResource resource = (IResource)obj;
            switch (resource.getType()) {
                case 1: {
                    folder = type.isType(resource) ? (IFolder)((IFile)resource).getParent() : type.getDefaultFolder(resource);
                    break;
                }
                case 2: {
                    folder = type.isType(resource) ? (IFolder)resource : type.getDefaultFolder(resource);
                    break;
                }
                case 4: {
                    folder = type.getDefaultFolder(resource);
                    break;
                }
                default: {
                    folder = null;
                }
            }
            return folder;
        }
        return null;
    }

    public void setSelection(ISelection selection) {
        IFolder folder = this.adaptSelection(selection, this.getType());
        SavvytestFileSelection component = this.getFileSelectionComponent();
        if (component.getControl() == null) {
            if (folder != null) {
                component.setProjectRestriction(folder.getProject());
                component.setInitialSelection((IResource)folder);
            } else {
                component.setProjectRestriction(null);
                component.setInitialSelection(null);
            }
        } else if (folder != null) {
            component.setProjectRestriction(folder.getProject());
            component.setSelection((ISelection)new StructuredSelection((Object)folder));
        } else {
            component.setProjectRestriction(null);
            component.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public ImportInfo getInfo() {
        return this.info;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    protected Listructure getOriginalListructure() {
        return this.originalListructure;
    }
}

