/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard.page;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.TableLabelProvider;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.wadl.WadlPlugin;
import com.savvytest.eclipse.wadl.model.wadl.DocumentRoot;
import com.savvytest.eclipse.wadl.model.wadl.ResourcesType;
import com.savvytest.eclipse.wadl.model.wadl.WadlPackage;
import com.savvytest.eclipse.wadl.model.wadl.util.WadlResourceImpl;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.ImportWadlVisitor;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ImportWadlWizardPage
extends WizardPage {
    private static final String PREF_WADL_PATH = "ImportWadlWizardPage.WADLPath";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wadl.wizard.page.ImportWadlWizardPage.";
    private WizardPageValidator validator;
    private final List<ImportInfo> availableInfos = new ArrayList<ImportInfo>();
    private final List<ImportInfo> selectedInfos = new ArrayList<ImportInfo>();
    private CheckboxTableViewer methodViewer;
    private URI wadlUri;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WadlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public ImportWadlWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public ImportWadlWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        this.validator = new WizardPageValidator(this){

            protected String internalValidate() {
                if (ImportWadlWizardPage.this.selectedInfos.isEmpty()) {
                    return ImportWadlWizardPage.getClassString("errors.selectmethod", new Object[0]);
                }
                return null;
            }
        };
        Font font = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
        Color color = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        Composite mainComp = new Composite(parent, 0);
        this.setControl((Control)mainComp);
        mainComp.setLayout((Layout)new GridLayout());
        Text wadlFileText = this.createWadlSelection(mainComp, font, color);
        this.createWadlViewer(mainComp, font, color);
        if (this.wadlUri != null) {
            if (this.wadlUri.isPlatform()) {
                wadlFileText.setText(this.wadlUri.toPlatformString(true));
            } else {
                wadlFileText.setText(this.wadlUri.toFileString());
            }
            this.extractAvailableMethods();
        } else {
            this.validator.validate();
            this.validator.setDisplayError(true);
        }
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{mainComp});
    }

    private void createWadlViewer(Composite parent, Font font, Color color) {
        Group methodGroup = new Group(parent, 0);
        Table methodTable = new Table((Composite)methodGroup, 2848);
        methodGroup.setText(ImportWadlWizardPage.getClassString("methodselection", new Object[0]));
        methodGroup.setLayout((Layout)new GridLayout());
        methodGroup.setLayoutData((Object)GridDataCreator.heightHint((GridData)GridDataCreator.fill(), (int)500));
        methodGroup.setFont(font);
        methodGroup.setForeground(color);
        methodTable.setLayoutData((Object)GridDataCreator.fill());
        methodTable.setHeaderVisible(true);
        this.methodViewer = new CheckboxTableViewer(methodTable);
        this.methodViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.methodViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        this.methodViewer.setInput(this.availableInfos);
        this.methodViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                ImportInfo info = (ImportInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return info.relativePath;
                    }
                    case 1: {
                        return info.methodType == null ? null : info.methodType.toString();
                    }
                    case 2: {
                        return info.methodId;
                    }
                }
                return null;
            }
        });
        this.methodViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ImportWadlWizardPage.this.selectedInfos.add((ImportInfo)event.getElement());
                } else {
                    ImportWadlWizardPage.this.selectedInfos.remove(event.getElement());
                }
                ImportWadlWizardPage.this.validator.validate();
            }
        });
        TableColumn pathColumn = new TableColumn(methodTable, 0);
        pathColumn.setResizable(true);
        pathColumn.setText(ImportWadlWizardPage.getClassString("columns.path", new Object[0]));
        pathColumn.setWidth(300);
        TableColumn typeColumn = new TableColumn(methodTable, 0);
        typeColumn.setResizable(true);
        typeColumn.setText(ImportWadlWizardPage.getClassString("columns.type", new Object[0]));
        typeColumn.setWidth(100);
        TableColumn idColumn = new TableColumn(methodTable, 0);
        idColumn.setResizable(true);
        idColumn.setText(ImportWadlWizardPage.getClassString("columns.name", new Object[0]));
        idColumn.setWidth(250);
        RowLayout methodButtonCompLayout = new RowLayout();
        methodButtonCompLayout.pack = false;
        Composite methodButtonComp = new Composite((Composite)methodGroup, 0);
        methodButtonComp.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        methodButtonComp.setLayout((Layout)methodButtonCompLayout);
        Button methodSelectAllButton = new Button(methodButtonComp, 0x1000000);
        methodSelectAllButton.setText(ImportWadlWizardPage.getClassString("selectAllButton", new Object[0]));
        methodSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWadlWizardPage.this.selectedInfos.clear();
                ImportWadlWizardPage.this.selectedInfos.addAll(ImportWadlWizardPage.this.availableInfos);
                ImportWadlWizardPage.this.methodViewer.setCheckedElements(ImportWadlWizardPage.this.availableInfos.toArray());
                ImportWadlWizardPage.this.validator.validate();
            }
        });
        Button methodDeselectAllButton = new Button(methodButtonComp, 0x1000000);
        methodDeselectAllButton.setText(ImportWadlWizardPage.getClassString("deselectAllButton", new Object[0]));
        methodDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportWadlWizardPage.this.selectedInfos.clear();
                ImportWadlWizardPage.this.methodViewer.setCheckedElements(new Object[0]);
                ImportWadlWizardPage.this.validator.validate();
            }
        });
    }

    private Text createWadlSelection(Composite parent, Font font, Color color) {
        Group wadlGroup = new Group(parent, 0);
        final Button wadlFileButton = new Button((Composite)wadlGroup, 16);
        final Text wadlFileText = new Text((Composite)wadlGroup, 2056);
        final Button wadlFileSelectButton = new Button((Composite)wadlGroup, 8);
        final Button wadlUriButton = new Button((Composite)wadlGroup, 16);
        final Text wadlUriText = new Text((Composite)wadlGroup, 2048);
        Button wadlUriSelectButton = new Button((Composite)wadlGroup, 8);
        wadlGroup.setText(ImportWadlWizardPage.getClassString("wadlgroup", new Object[0]));
        wadlGroup.setLayout((Layout)new GridLayout(3, false));
        wadlGroup.setLayoutData((Object)GridDataCreator.horizontalFill());
        wadlGroup.setFont(font);
        wadlGroup.setForeground(color);
        wadlFileButton.setLayoutData((Object)GridDataCreator.normal());
        wadlFileButton.setText(ImportWadlWizardPage.getClassString("wadlfile", new Object[0]));
        wadlFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (wadlFileButton.getSelection()) {
                    ImportWadlWizardPage.this.wadlUri = null;
                    String file = wadlFileText.getText();
                    if (!file.isEmpty()) {
                        ImportWadlWizardPage.this.wadlUri = URI.createFileURI((String)file);
                    }
                    ImportWadlWizardPage.this.extractAvailableMethods();
                }
            }
        });
        wadlFileText.setLayoutData((Object)GridDataCreator.horizontalFill());
        wadlFileText.setFont(font);
        wadlFileText.setForeground(color);
        wadlFileSelectButton.setText(ImportWadlWizardPage.getClassString("opendialog", new Object[0]));
        wadlFileSelectButton.setLayoutData((Object)GridDataCreator.normal());
        wadlFileSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            final IPreferenceStore preferenceStore = WadlPlugin.getPreferenceStore();

            public void widgetSelected(SelectionEvent e) {
                String[] extensions = new String[]{"*.wadl", "*.*"};
                String[] filternames = new String[]{ImportWadlWizardPage.getClassString("filtername.0", new Object[0]), ImportWadlWizardPage.getClassString("filtername.1", new Object[0])};
                filternames[0] = MessageFormat.format(filternames[0], extensions[0]);
                filternames[1] = MessageFormat.format(filternames[1], extensions[1]);
                FileDialog dialog = new FileDialog(wadlFileSelectButton.getShell(), 4098);
                dialog.setText(ImportWadlWizardPage.getClassString("dialogtitle", new Object[0]));
                dialog.setFilterExtensions(extensions);
                dialog.setFilterNames(filternames);
                dialog.setFilterPath(this.preferenceStore.getString(ImportWadlWizardPage.PREF_WADL_PATH));
                String wadl = dialog.open();
                if (wadl != null) {
                    this.preferenceStore.setValue(ImportWadlWizardPage.PREF_WADL_PATH, dialog.getFilterPath());
                    wadlFileText.setText(wadl);
                    wadlUriButton.setSelection(false);
                    wadlFileButton.setSelection(true);
                    wadlFileButton.notifyListeners(13, new Event());
                }
            }
        });
        wadlUriButton.setLayoutData((Object)GridDataCreator.normal());
        wadlUriButton.setText(ImportWadlWizardPage.getClassString("wadlurl", new Object[0]));
        wadlUriButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (wadlUriButton.getSelection()) {
                    ImportWadlWizardPage.this.wadlUri = null;
                    String uri = wadlUriText.getText();
                    if (!uri.isEmpty()) {
                        if (!uri.startsWith("http://")) {
                            uri = "http://" + uri;
                        }
                        try {
                            ImportWadlWizardPage.this.wadlUri = URI.createURI((String)uri);
                        }
                        catch (IllegalArgumentException e) {
                            ImportWadlWizardPage.this.wadlUri = null;
                            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                            MessageDialog.openError((Shell)ImportWadlWizardPage.this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)ImportWadlWizardPage.getClassString("errors.parseurl", new Object[]{e.getLocalizedMessage()}));
                        }
                    }
                    ImportWadlWizardPage.this.extractAvailableMethods();
                }
            }
        });
        wadlUriText.setLayoutData((Object)GridDataCreator.horizontalFill());
        wadlUriText.setFont(font);
        wadlUriText.setForeground(color);
        wadlUriText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    wadlFileButton.setSelection(false);
                    wadlUriButton.setSelection(true);
                    wadlUriButton.notifyListeners(13, new Event());
                }
            }
        });
        wadlUriSelectButton.setText(ImportWadlWizardPage.getClassString("openurl", new Object[0]));
        wadlUriSelectButton.setLayoutData((Object)GridDataCreator.normal());
        wadlUriSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                wadlFileButton.setSelection(false);
                wadlUriButton.setSelection(true);
                wadlUriButton.notifyListeners(13, new Event());
            }
        });
        return wadlFileText;
    }

    public List<ImportInfo> getInfos() {
        return Collections.unmodifiableList(this.selectedInfos);
    }

    private void refreshViewer() {
        if (this.methodViewer != null) {
            this.validator.setDisplayError(false);
            this.validator.validate();
            this.validator.setDisplayError(true);
            this.methodViewer.refresh();
        }
    }

    public void setSelection(ISelection selection) {
        IFile file;
        String extension;
        this.wadlUri = null;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IFile && (extension = (file = (IFile)obj).getFileExtension()) != null && extension.equalsIgnoreCase("wadl")) {
            this.wadlUri = URI.createPlatformResourceURI((String)file.getFullPath().toPortableString(), (boolean)true);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void extractAvailableMethods() {
        this.availableInfos.clear();
        this.selectedInfos.clear();
        if (this.wadlUri == null) {
            this.refreshViewer();
            return;
        }
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)new EPackageRegistryImpl(EPackage.Registry.INSTANCE));
        extendedMetaData.putPackage(null, (EPackage)WadlPackage.eINSTANCE);
        HashMap<String, BasicExtendedMetaData> wadlLoadOptions = new HashMap<String, BasicExtendedMetaData>();
        wadlLoadOptions.put("EXTENDED_META_DATA", extendedMetaData);
        SavvytestSettings.INSTANCE.getLogger().log("Opening WADL file from URL: " + this.wadlUri, LogLevel.DEBUG, (Object)this);
        WadlResourceImpl resource = new WadlResourceImpl(this.wadlUri);
        try {
            resource.load(wadlLoadOptions);
        }
        catch (IOException exception) {
            SavvytestSettings.INSTANCE.getLogger().log((Exception)exception, (Object)this);
            MessageDialog.openError((Shell)this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)ImportWadlWizardPage.getClassString("errors.loadwadl", exception.getLocalizedMessage()));
            this.refreshViewer();
            return;
        }
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        SavvytestSettings.INSTANCE.getLogger().log("Visiting WADL.", LogLevel.DEBUG, (Object)this);
        ImportWadlVisitor visitor = new ImportWadlVisitor();
        for (ResourcesType resources : root.getApplication().getResources()) {
            this.availableInfos.addAll(visitor.visitResources(resources));
        }
        SavvytestSettings.INSTANCE.getLogger().log("Found methods: " + this.availableInfos, LogLevel.DEBUG, (Object)this);
        this.refreshViewer();
        if (this.availableInfos.isEmpty()) {
            String message = ImportWadlWizardPage.getClassString("errors.nomethodsfound", new Object[0]);
            SavvytestSettings.INSTANCE.getLogger().log(message, LogLevel.DEBUG, (Object)this);
            MessageDialog.openError((Shell)this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)message);
        }
    }
}

