/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard.page;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.GridDataCreator;
import com.savvytest.eclipse.common.util.WizardPageValidator;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.wadl.WadlPlugin;
import com.savvytest.eclipse.wadl.wizard.ImportInfo;
import com.savvytest.eclipse.wadl.wizard.page.AbstractImportInfoPage;
import com.savvytest.eclipse.wadl.wizard.page.ListructureBuilder;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputParametersPage
extends AbstractImportInfoPage {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.wadl.wizard.page.InputParametersPage.";
    private WizardPageValidator validator = new SavvytestFileSelectionPage.FileSelectionValidator(this){

        protected String internalValidate() {
            if (InputParametersPage.this.getSubInfo().listructure == null && InputParametersPage.this.getSubInfo().create) {
                return InputParametersPage.getClassString("errors.listructure", new Object[0]);
            }
            return super.internalValidate();
        }
    };

    private static String getClassString(String key, Object ... substitutes) {
        String translation = WadlPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public InputParametersPage(ImportInfo info, String pageName) {
        super(info, pageName, InputParametersPage.createDefaultFilename(info, ".input." + SavvytestTypeEnum.LISTRUCTURE.fileextension));
        this.getFileSelectionComponent().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportInfo.InputInfo inputInfo = InputParametersPage.this.getSubInfo();
                inputInfo.parametersFile = InputParametersPage.this.getFileSelectionComponent().getSelectedFile();
                if (inputInfo.listructure != null && inputInfo.create) {
                    inputInfo.listructure.setId(EditingUtility.getIdForFile((IFile)inputInfo.parametersFile));
                }
                InputParametersPage.this.validator.validate();
            }
        });
    }

    @Override
    protected SavvytestTypeEnum getType() {
        return SavvytestTypeEnum.LISTRUCTURE;
    }

    @Override
    protected ImportInfo.InputInfo getSubInfo() {
        return this.getInfo().inputInfo;
    }

    public void createControl(Composite parent) {
        Color color = this.getSavvytestColor();
        Font font = this.getSavvytestFont();
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new FillLayout(512));
        this.setControl((Control)body);
        Group selectionGroup = new Group(body, 0);
        selectionGroup.setLayout((Layout)new FillLayout());
        selectionGroup.setText(InputParametersPage.getClassString("selectionGroup", new Object[0]));
        selectionGroup.setFont(font);
        this.getFileSelectionComponent().createControl((Composite)selectionGroup, 8192);
        this.getFileSelectionComponent().setColor(color);
        this.getFileSelectionComponent().setFont(font);
        Group jsonGroup = new Group(body, 0);
        jsonGroup.setText(InputParametersPage.getClassString("inputGroup", new Object[0]));
        jsonGroup.setLayout((Layout)new GridLayout());
        jsonGroup.setFont(font);
        if ("application/json".equals(this.getSubInfo().mediaType)) {
            Button createButton = InputParametersPage.createCreationButton((Composite)jsonGroup, this.getSubInfo(), this.getOriginalListructure(), InputParametersPage.getClassString("createJsonButton", new Object[0]), font, color);
            createButton.setLayoutData((Object)GridDataCreator.normal());
            Composite jsonComp = this.createJsonComp((Composite)jsonGroup, createButton, color, font);
            jsonComp.setLayoutData((Object)GridDataCreator.fill());
        } else if ("text/plain".equals(this.getSubInfo().mediaType)) {
            Button createButton = InputParametersPage.createCreationButton((Composite)jsonGroup, this.getSubInfo(), this.getOriginalListructure(), InputParametersPage.getClassString("createTextButton", new Object[0]), font, color);
            createButton.setLayoutData((Object)GridDataCreator.normal());
            createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputParametersPage.this.validator.validate();
                }
            });
            TreeViewer listructureViewer = InputParametersPage.createListructureViewer((Composite)jsonGroup, font, color);
            listructureViewer.getTree().setLayoutData((Object)GridDataCreator.fill());
            listructureViewer.setInput((Object)this.getSubInfo().listructure);
        } else {
            throw new IllegalArgumentException("Unknown media type to handle: " + this.getSubInfo().mediaType);
        }
        this.validator.validate();
        this.validator.setDisplayError(true);
    }

    private Composite createJsonComp(Composite parentGroup, Button createButton, Color color, Font font) {
        Composite jsonComp = new Composite(parentGroup, 0);
        GridLayout jsonCompLayout = new GridLayout(3, false);
        jsonCompLayout.marginHeight = 0;
        jsonCompLayout.marginWidth = 0;
        jsonComp.setLayout((Layout)jsonCompLayout);
        Label jsonStructureLabel = new Label(jsonComp, 0);
        jsonStructureLabel.setLayoutData((Object)GridDataCreator.horizontalSpan((GridData)GridDataCreator.normal(), (int)2));
        jsonStructureLabel.setText(InputParametersPage.getClassString("jsonStructureLabel", new Object[0]));
        Label generatedListructureLabel = new Label(jsonComp, 0);
        generatedListructureLabel.setLayoutData((Object)GridDataCreator.normal());
        generatedListructureLabel.setText(InputParametersPage.getClassString("generatedListructureLabel", new Object[0]));
        final Text jsonStructureText = new Text(jsonComp, 2626);
        jsonStructureText.setLayoutData((Object)GridDataCreator.fill());
        Button parseButton = new Button(jsonComp, 8);
        parseButton.setLayoutData((Object)GridDataCreator.center());
        parseButton.setText(InputParametersPage.getClassString("parseButton", new Object[0]));
        parseButton.setForeground(color);
        parseButton.setFont(font);
        final TreeViewer listructureViewer = InputParametersPage.createListructureViewer(jsonComp, font, color);
        listructureViewer.getTree().setLayoutData((Object)GridDataCreator.fill());
        parseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputParametersPage.this.getSubInfo().listructure = null;
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode node = mapper.readTree(jsonStructureText.getText());
                    ListructureBuilder.JsonType jsonType = this.visit(node);
                    ListructureBuilder builder = new ListructureBuilder();
                    builder.setUsage(UsageType.IN);
                    Listructure listructure = builder.buildListructure(jsonStructureText.getText(), jsonType);
                    listructure.setId(EditingUtility.getIdForFile((IFile)InputParametersPage.this.getSubInfo().parametersFile));
                    InputParametersPage.this.getSubInfo().listructure = listructure;
                }
                catch (IOException e) {
                    SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                    String message = InputParametersPage.getClassString("errors.jsonparse", new Object[]{e.getLocalizedMessage()});
                    InputParametersPage.this.setErrorMessage(message);
                    InputParametersPage.this.setPageComplete(false);
                    MessageDialog.openError((Shell)InputParametersPage.this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)message);
                }
                listructureViewer.setInput((Object)InputParametersPage.this.getSubInfo().listructure);
                if (InputParametersPage.this.getSubInfo().listructure != null) {
                    InputParametersPage.this.validator.validate();
                }
            }

            private ListructureBuilder.JsonType visit(JsonNode node) {
                switch (node.getNodeType()) {
                    case ARRAY: {
                        if (node.elements().hasNext()) {
                            JsonNode arrayChildNode = (JsonNode)node.elements().next();
                            return this.visit(arrayChildNode);
                        }
                        return ListructureBuilder.JsonType.MODEL;
                    }
                    case OBJECT: {
                        Iterator elements = node.elements();
                        while (elements.hasNext()) {
                            if (this.visit((JsonNode)elements.next()) != ListructureBuilder.JsonType.DATA) continue;
                            return ListructureBuilder.JsonType.DATA;
                        }
                        return ListructureBuilder.JsonType.MODEL;
                    }
                    case STRING: {
                        String stringValue = node.textValue();
                        if ("boolean".equalsIgnoreCase(stringValue) || "number".equalsIgnoreCase(stringValue) || "string".equalsIgnoreCase(stringValue)) {
                            return ListructureBuilder.JsonType.MODEL;
                        }
                        return ListructureBuilder.JsonType.DATA;
                    }
                }
                return ListructureBuilder.JsonType.DATA;
            }
        });
        createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputParametersPage.this.getSubInfo().listructure = null;
                listructureViewer.setInput(null);
                InputParametersPage.this.validator.validate();
            }
        });
        return jsonComp;
    }
}

