/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.wadl.wizard.page;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.core.model.xml.listructure.ArrayType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructureFactory;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.wadl.wizard.ListructureCreator;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;

public class ListructureBuilder
extends ListructureCreator {
    public Listructure buildListructure(String json, JsonType type) throws JsonProcessingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(json);
        BaseType root = this.visitNode(node, type);
        if (root.getName() == null) {
            root.setName("root");
        }
        return this.createListructure(root);
    }

    private BaseType visitNode(JsonNode node, JsonType type) {
        switch (node.getNodeType()) {
            case ARRAY: {
                ArrayType array = this.insertDefaults(ListructureFactory.eINSTANCE.createArrayType(), node);
                array.setLength(BigInteger.valueOf(Integer.MAX_VALUE));
                array.getProperties().getProperties().add((Object)PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.OCCURS, (String)String.valueOf(Integer.MAX_VALUE)));
                if (node.elements().hasNext()) {
                    JsonNode arrayChildNode = (JsonNode)node.elements().next();
                    BaseType arrayChild = this.visitNode(arrayChildNode, type);
                    array.getElements().add(this.getFeature(arrayChild, false), (Object)arrayChild);
                }
                return array;
            }
            case OBJECT: {
                StructType struct = this.insertDefaults(ListructureFactory.eINSTANCE.createStructType(), node);
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    BaseType structChild = this.visitNode((JsonNode)field.getValue(), type);
                    structChild.setName((String)field.getKey());
                    struct.getElements().add(this.getFeature(structChild, false), (Object)structChild);
                }
                return struct;
            }
            case STRING: {
                switch (type) {
                    case DATA: {
                        return this.insertDefaults(ListructureFactory.eINSTANCE.createStringType(), node);
                    }
                    case MODEL: {
                        return this.createAtomicForValue(node.textValue());
                    }
                }
                throw new IllegalArgumentException("Unknown JSON type: " + (Object)((Object)type));
            }
            case BOOLEAN: {
                return this.insertDefaults(ListructureFactory.eINSTANCE.createBooleanType(), node);
            }
            case NUMBER: {
                return this.insertDefaults(ListructureFactory.eINSTANCE.createNumberType(), node);
            }
        }
        SavvytestSettings.INSTANCE.getLogger().log("Unknown node type to parse: " + node.getNodeType() + ". Node will be skipped.", LogLevel.WARNING, (Object)this);
        return null;
    }

    private <T extends BaseType> T insertDefaults(T baseType, JsonNode node) {
        this.insertDefaults(baseType);
        baseType.setName(node.getNodeType().name().toLowerCase());
        return baseType;
    }

    public static enum JsonType {
        DATA,
        MODEL;

    }
}

