/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.delete;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;

public abstract class AbstractSavvytestDeleteParticipant
extends DeleteParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.delete.AbstractSavvytestDeleteParticipant.";
    protected final SavvytestTypeEnum deletedType;
    protected final SavvytestTypeEnum[] changingTypes;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected AbstractSavvytestDeleteParticipant(SavvytestTypeEnum deletedType, SavvytestTypeEnum[] changingTypes) {
        this.deletedType = deletedType;
        this.changingTypes = changingTypes;
    }

    public String getName() {
        return String.valueOf(this.deletedType.fileextension) + " delete participant.";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        HashSet<IFile> affected = new HashSet<IFile>();
        SavvytestTypeEnum[] savvytestTypeEnumArray = this.changingTypes;
        int n = this.changingTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum type = savvytestTypeEnumArray[n2];
            this.removeReference(type, affected, pm);
            ++n2;
        }
        String label = this.getFiles().length == 1 ? AbstractSavvytestDeleteParticipant.getClassString("referenceLabelSingle", this.getFiles()[0].getFullPath()) : AbstractSavvytestDeleteParticipant.getClassString("referenceLabelMulti", new Object[0]);
        return this.wrapIntoCompositeChange(affected, label);
    }

    private Change wrapIntoCompositeChange(Set<IFile> changes, String label) {
        if (changes.isEmpty()) {
            return null;
        }
        ArrayList<NullChange> nullChanges = new ArrayList<NullChange>(changes.size());
        for (IFile file : changes) {
            nullChanges.add(new NullChange(file.getFullPath().toString()));
        }
        Collections.sort(nullChanges, new Comparator<NullChange>(){
            private final Collator collator = Collator.getInstance();

            @Override
            public int compare(NullChange o1, NullChange o2) {
                return this.collator.compare(o1.getName(), o2.getName());
            }
        });
        return new CompositeChange(label, nullChanges.toArray(new Change[changes.size()]));
    }

    private void removeReference(SavvytestTypeEnum type, final Set<IFile> affected, IProgressMonitor monitor) {
        IResource[] roots = new IResource[]{type.getDefaultFolder((IResource)this.getProject())};
        String[] fileNamePatterns = new String[]{"*." + type.fileextension};
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern searchPattern = this.createSearchPattern();
        TextSearchRequestor requestor = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                affected.add(matchAccess.getFile());
                return false;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)searchScope, requestor, searchPattern, monitor);
    }

    private Pattern createSearchPattern() {
        IFile[] files = this.getFiles();
        StringBuilder builder = new StringBuilder(files.length * 50 + 200);
        int i = 0;
        while (i < files.length) {
            String fileId = URI.encodeOpaquePart((String)files[i].getProjectRelativePath().toString(), (boolean)true);
            if (i != 0) {
                builder.append('|');
            }
            builder.append("(?:");
            builder.append(Pattern.quote(String.valueOf(fileId) + '#' + fileId));
            builder.append(')');
            ++i;
        }
        return Pattern.compile(builder.toString());
    }

    protected abstract IFile[] getFiles();

    protected abstract IProject getProject();
}

