/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.refactor.rename;

import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.refactor.Activator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public abstract class AbstractSavvytestRenameParticipant
extends RenameParticipant {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.refactor.rename.AbstractSavvytestRenameParticipant.";
    protected final SavvytestTypeEnum renamedType;
    protected final SavvytestTypeEnum[] changingTypes;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    protected AbstractSavvytestRenameParticipant(SavvytestTypeEnum renamedType, SavvytestTypeEnum[] changingTypes) {
        this.renamedType = renamedType;
        this.changingTypes = changingTypes;
    }

    public String getName() {
        return String.valueOf(this.renamedType.fileextension) + " rename participant.";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.referenceUpdate(new SavvytestTypeEnum[]{this.renamedType}, (IResource[])this.getFiles(), AbstractSavvytestRenameParticipant.getClassString("idLabel", new Object[0]), pm);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.referenceUpdate(this.changingTypes, null, AbstractSavvytestRenameParticipant.getClassString("referenceLabel", new Object[0]), pm);
    }

    private Change referenceUpdate(SavvytestTypeEnum[] types, IResource[] roots, String label, IProgressMonitor monitor) {
        ArrayList<Change> changes = new ArrayList<Change>(types.length);
        SavvytestTypeEnum[] savvytestTypeEnumArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            SavvytestTypeEnum type = savvytestTypeEnumArray[n2];
            if (roots == null) {
                IResource[] defaultRoots = new IResource[]{type.getDefaultFolder((IResource)this.getProject())};
                changes.addAll(this.getIdChange(type, defaultRoots, monitor));
            } else {
                changes.addAll(this.getIdChange(this.renamedType, roots, monitor));
            }
            ++n2;
        }
        if (changes.isEmpty()) {
            return null;
        }
        return new CompositeChange(label, changes.toArray(new Change[changes.size()]));
    }

    private List<Change> getIdChange(SavvytestTypeEnum type, IResource[] roots, IProgressMonitor monitor) {
        final Map<String, String> replacementMap = this.getIdReplacementMap();
        String[] fileNamePatterns = new String[]{"*." + type.fileextension};
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern searchPattern = this.createSearchPattern(replacementMap.keySet());
        final HashMap changes = new HashMap();
        TextSearchRequestor requestor = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
                IFile file = matchAccess.getFile();
                TextFileChange change = (TextFileChange)changes.get(file);
                if (change == null) {
                    if (AbstractSavvytestRenameParticipant.this.getTextChange(file) != null) {
                        return false;
                    }
                    change = new TextFileChange(file.getName(), file);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    changes.put(file, change);
                }
                String replacementString = (String)replacementMap.get(matchAccess.getFileContent(matchAccess.getMatchOffset(), matchAccess.getMatchLength()));
                ReplaceEdit edit = new ReplaceEdit(matchAccess.getMatchOffset(), matchAccess.getMatchLength(), replacementString);
                change.addEdit((TextEdit)edit);
                change.addTextEditGroup(new TextEditGroup(AbstractSavvytestRenameParticipant.getClassString("updateLabel", new Object[0]), (TextEdit)edit));
                return true;
            }
        };
        TextSearchEngine.create().search((TextSearchScope)searchScope, requestor, searchPattern, monitor);
        return new ArrayList<Change>(changes.values());
    }

    private Pattern createSearchPattern(Collection<String> searchFor) {
        StringBuilder builder = new StringBuilder(searchFor.size() * 50);
        Iterator<String> iter = searchFor.iterator();
        while (iter.hasNext()) {
            builder.append('(');
            builder.append(Pattern.quote(iter.next()));
            builder.append(')');
            if (!iter.hasNext()) continue;
            builder.append('|');
        }
        return Pattern.compile(builder.toString());
    }

    protected abstract Map<String, String> getIdReplacementMap();

    protected abstract IFile[] getFiles();

    protected abstract IProject getProject();
}

