/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.actions;

import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfaceFactory;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUi;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;

public class AddListructureCommand
extends AbstractOverrideableCommand {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.actions.AddListructureCommand.";
    private static final String LABEL = AddListructureCommand.getClassString("label");
    private static final String DESCRIPTION = AddListructureCommand.getClassString("description");
    private final SavvytestInterfaceEditor editor;
    private final Listructure listructure;
    private int index;
    private Interface iface;
    private InterfaceUi ifaceUi;
    private Map<Listructure, Map<String, BaseType>> map;
    private Listructure liStructureCopy;

    private static String getClassString(String key) {
        return InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
    }

    public AddListructureCommand(SavvytestInterfaceEditor editor, Listructure listructure) {
        this(editor, listructure, -1);
    }

    public AddListructureCommand(SavvytestInterfaceEditor editor, Listructure arg, int index) {
        super(editor.getEditingDomain(), LABEL, DESCRIPTION);
        this.editor = editor;
        this.listructure = arg;
        this.index = index;
    }

    protected boolean prepare() {
        Resource resource = (Resource)this.getDomain().getResourceSet().getResources().get(0);
        DocumentRoot doc = (DocumentRoot)resource.getContents().get(0);
        this.iface = doc.getInterface();
        this.ifaceUi = (InterfaceUi)resource.getContents().get(1);
        this.map = this.editor.getArgumentsMap();
        return this.iface != null && this.ifaceUi != null && this.index <= this.iface.getArguments().size();
    }

    private Argument createArgument(Listructure li) {
        Argument arg = InterfaceFactory.eINSTANCE.createArgument();
        arg.setListructure(li);
        ArrayList baseTypeExtensions = new ArrayList();
        for (FeatureMap.Entry entry : li.getElements()) {
            BaseType baseType = (BaseType)entry.getValue();
            InterfaceUtils.createBaseTypeExtension((BaseType)baseType, baseTypeExtensions);
        }
        arg.getBaseTypeExtensions().addAll(baseTypeExtensions);
        return arg;
    }

    private Listructure copyListructure(Argument arg) {
        Map baseTypeExtensionMap = InterfaceUtils.createBaseTypeExtensionMap((Collection)arg.getBaseTypeExtensions());
        this.liStructureCopy = (Listructure)EcoreUtil.copy((EObject)arg.getListructure());
        ListructureUtils.clearInitialValue((Listructure)this.liStructureCopy);
        InterfaceUtils.updateListrucure((Listructure)this.liStructureCopy, (Map)baseTypeExtensionMap, (boolean)true, (boolean)true);
        return this.liStructureCopy;
    }

    public void doExecute() {
        if (this.index < 0) {
            this.index = this.iface.getArguments().size();
        }
        Argument arg = this.createArgument(this.listructure);
        this.iface.getArguments().add(this.index, (Object)arg);
        this.liStructureCopy = this.copyListructure(arg);
        this.ifaceUi.getArgumentsUi().add(this.index, (Object)this.liStructureCopy);
        if (this.map != null) {
            Map baseTypeMap = ListructureUtils.createBaseTypeMap((Listructure)arg.getListructure());
            this.map.put(this.liStructureCopy, baseTypeMap);
        }
    }

    public void doUndo() {
        this.iface.getArguments().remove(this.index);
        this.ifaceUi.getArgumentsUi().remove(this.index);
        if (this.map != null) {
            this.map.remove(this.liStructureCopy);
        }
    }

    public void doRedo() {
        this.doExecute();
    }

    public Collection<?> doGetAffectedObjects() {
        ArrayList<Object> objList = new ArrayList<Object>(3);
        objList.add(this.iface);
        objList.add(this.ifaceUi);
        objList.add(this.map);
        return objList;
    }

    public Collection<?> doGetResult() {
        ArrayList<Object> objList = new ArrayList<Object>(2);
        objList.add(this.iface);
        objList.add(this.ifaceUi);
        return objList;
    }
}

