/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.gui;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.actions.CollapseAction;
import com.savvytest.eclipse.common.actions.ExpandAction;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.logging.LogLevel;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.util.MissingResourceUtil;
import com.savvytest.eclipse.common.util.ToolTipHandler;
import com.savvytest.eclipse.common.util.UtilityFunctions;
import com.savvytest.eclipse.common.util.editing.CheckingPropertyEditingSupport;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.util.editing.TreePropertyEditingSupport;
import com.savvytest.eclipse.core.model.xml.data.provider.DataEditPlugin;
import com.savvytest.eclipse.core.model.xml.iface.Argument;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.DocumentRoot;
import com.savvytest.eclipse.core.model.xml.iface.Interface;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUi;
import com.savvytest.eclipse.core.model.xml.iface.ui.InterfaceUiFactory;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceElementMigrationInfo;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceUtils;
import com.savvytest.eclipse.core.model.xml.listructure.AtomicType;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.ContainerType;
import com.savvytest.eclipse.core.model.xml.listructure.Listructure;
import com.savvytest.eclipse.core.model.xml.listructure.ListructurePackage;
import com.savvytest.eclipse.core.model.xml.listructure.StringType;
import com.savvytest.eclipse.core.model.xml.listructure.StructType;
import com.savvytest.eclipse.core.model.xml.listructure.impl.BaseTypeVisitorImpl;
import com.savvytest.eclipse.core.model.xml.listructure.util.ListructureUtils;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesFactory;
import com.savvytest.eclipse.core.model.xml.properties.PropertiesPackage;
import com.savvytest.eclipse.core.model.xml.properties.Property;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import com.savvytest.eclipse.editor.iface.gui.AdditionalInterfaceInformation;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditor;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.migration.InterfaceElementMigration;
import com.savvytest.eclipse.editor.iface.migration.InterfaceElementMigrationDialog;
import com.savvytest.eclipse.editor.iface.preferences.SavvytestPreferencesPage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class SavvytestInterfaceEditor
extends InterfaceEditor {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.gui.SavvytestInterfaceEditor.";
    private final Color colorForeground;
    private final Color colorError;
    private final Color colorDefault;
    private final Color colorIrrelevant;
    private final Font fontForeground;
    private final Map<Listructure, Map<String, BaseType>> argumentMap = new HashMap<Listructure, Map<String, BaseType>>();
    protected Map<ColumnViewer, IToolBarManager> toolbars = new HashMap<ColumnViewer, IToolBarManager>(5);
    private boolean selectionRecursionPreventer = false;
    private boolean readOnly;
    protected TreeViewer editParametersTreeViewer;
    private int interfacePageIndex = -1;
    private int infoPageIndex = -1;

    private static String getClassString(String key, Object ... substitutes) {
        String translation = InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    private static final Argument getArgument(Listructure li) {
        InterfaceUi ui = (InterfaceUi)li.eContainer();
        int index = ui.getArgumentsUi().indexOf((Object)li);
        Argument arg = (Argument)ui.getArguments().get(index);
        return arg;
    }

    private static final Listructure getListructure(Argument arg) {
        Interface iface = (Interface)arg.eContainer();
        int index = iface.getArguments().indexOf((Object)arg);
        InterfaceUi ifaceUi = (InterfaceUi)arg.eResource().getContents().get(1);
        Listructure li = (Listructure)ifaceUi.getArgumentsUi().get(index);
        return li;
    }

    public SavvytestInterfaceEditor() {
        this.colorForeground = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground");
        this.colorError = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorConflicting");
        this.colorDefault = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorInherited");
        this.colorIrrelevant = SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorIrrelevant");
        this.fontForeground = SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal");
    }

    @Override
    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        this.readOnly = file != null && file.isReadOnly();
        IStatus licenseErrorMessage = License.getInstance().getLicenseStatus();
        if (!licenseErrorMessage.isOK()) {
            this.getActionBarContributor().getActionBars().getStatusLineManager().setErrorMessage(licenseErrorMessage.getMessage());
        }
    }

    @Override
    public void createModel() {
        super.createModel();
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        this.updateManager(resource);
        this.checkMissingResources(root.getInterface());
        boolean doMigration = true;
        InterfaceUi uiInterface = InterfaceUiFactory.eINSTANCE.createInterfaceUi();
        uiInterface.setInterface(root.getInterface());
        for (Argument argument : root.getInterface().getArguments()) {
            InterfaceElementMigrationInfo migrationInfo = new InterfaceElementMigrationInfo(argument);
            Listructure liStructureCopy = InterfaceUtils.createListructureUi((Argument)argument, (InterfaceElementMigrationInfo)migrationInfo);
            if (doMigration && !migrationInfo.isEmpty()) {
                doMigration = this.handleMigration(migrationInfo, argument.getListructure().getName(), resource);
            }
            uiInterface.getArgumentsUi().add((Object)liStructureCopy);
            Map baseTypeMap = ListructureUtils.createBaseTypeMap((Listructure)argument.getListructure());
            this.argumentMap.put(liStructureCopy, baseTypeMap);
        }
        resource.getContents().add((Object)uiInterface);
    }

    private boolean handleMigration(InterfaceElementMigrationInfo info, String listructureName, final Resource resource) {
        if (this.isReadOnly()) {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)SavvytestInterfaceEditor.getClassString("migrationInfoTitle", new Object[0]), (String)SavvytestInterfaceEditor.getClassString("migrationInfoMessage", new Object[0]));
            SavvytestSettings.INSTANCE.getLogger().log("Migration detected. Found editor in read only state.", LogLevel.DEBUG, (Object)this);
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            IStatus status = EditingUtility.checkEditing((IFile)file, (Shell)this.getSite().getShell());
            if (status.getSeverity() == 8 || status.getSeverity() == 4) {
                SavvytestSettings.INSTANCE.getLogger().log("Migration aborted. Status: " + status, LogLevel.DEBUG, (Object)this);
                return false;
            }
            this.getSite().getShell().getDisplay().timerExec(200, new Runnable(){

                @Override
                public void run() {
                    if (!SavvytestInterfaceEditor.this.changedResources.contains(resource)) {
                        SavvytestInterfaceEditor.this.changedResources.add(resource);
                    }
                    SavvytestSettings.INSTANCE.getLogger().log("Running delayed handleActivate because of migration.", LogLevel.DEBUG, (Object)this);
                    SavvytestInterfaceEditor.this.handleActivate();
                }
            });
            return false;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Doing migration for " + listructureName + ". Migration info: " + info, LogLevel.DEBUG, (Object)this);
        InterfaceElementMigration migration = new InterfaceElementMigration(info);
        migration.compute();
        if (!migration.migrationMap.isEmpty()) {
            InterfaceElementMigrationDialog dialog = new InterfaceElementMigrationDialog(this.getSite().getShell(), listructureName, migration);
            dialog.open();
        }
        migration.applyMap(this.getEditingDomain());
        return true;
    }

    @Override
    protected void handleActivate() {
        boolean oldReadOnly = this.readOnly;
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        boolean bl = this.readOnly = file != null && file.isReadOnly();
        if (oldReadOnly != this.readOnly) {
            SavvytestSettings.INSTANCE.getLogger().log("Read only status changed to: " + this.readOnly, LogLevel.DEBUG, (Object)this);
        }
        super.handleActivate();
    }

    @Override
    protected void handleChangedResources() {
        super.handleChangedResources();
        if (!this.changedResources.isEmpty()) {
            this.createModel();
            Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
            InterfaceUi iface = (InterfaceUi)resource.getContents().get(1);
            InterfaceUi oldIface = (InterfaceUi)this.editParametersTreeViewer.getInput();
            final HashMap<Listructure, Integer> listructureIndexMap = new HashMap<Listructure, Integer>();
            int index = 0;
            for (Listructure listructure : iface.getArgumentsUi()) {
                listructureIndexMap.put(listructure, index++);
            }
            index = 0;
            for (Listructure listructure : oldIface.getArgumentsUi()) {
                listructureIndexMap.put(listructure, index++);
            }
            IElementComparer expandedComparer = new IElementComparer(){

                public int hashCode(Object element) {
                    Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)element);
                    if (unwrapped instanceof BaseType) {
                        return ((BaseType)unwrapped).computeId().hashCode();
                    }
                    if (unwrapped instanceof Listructure) {
                        return ((Listructure)unwrapped).getId().hashCode();
                    }
                    return element.hashCode();
                }

                public boolean equals(Object a, Object b) {
                    Object ea = AdapterFactoryEditingDomain.unwrap((Object)a);
                    Object eb = AdapterFactoryEditingDomain.unwrap((Object)b);
                    if (ea.getClass() != eb.getClass()) {
                        return false;
                    }
                    if (ea instanceof BaseType) {
                        BaseType bta = (BaseType)ea;
                        BaseType btb = (BaseType)eb;
                        if (!bta.getId().equals(btb.getId())) {
                            return false;
                        }
                        return this.equals(bta.eContainer(), btb.eContainer());
                    }
                    if (ea instanceof Listructure) {
                        Listructure la = (Listructure)ea;
                        Listructure lb = (Listructure)eb;
                        if (!((Integer)listructureIndexMap.get(la)).equals(listructureIndexMap.get(lb))) {
                            return false;
                        }
                        return la.getId().equals(lb.getId());
                    }
                    return a.equals(b);
                }
            };
            TreePath[] expandedTreePaths = this.editParametersTreeViewer.getExpandedTreePaths();
            IElementComparer oldComparer = this.editParametersTreeViewer.getComparer();
            this.editParametersTreeViewer.setComparer(expandedComparer);
            this.editParametersTreeViewer.setInput((Object)iface);
            this.editParametersTreeViewer.setExpandedTreePaths(expandedTreePaths);
            this.editParametersTreeViewer.setSelection(this.editParametersTreeViewer.getSelection(), true);
            this.editParametersTreeViewer.setComparer(oldComparer);
            if (this.infoPageIndex != -1) {
                ((AdditionalInterfaceInformation)this.getControl(this.infoPageIndex)).refresh();
            }
            this.pageChange(this.getActivePage());
        }
    }

    protected boolean checkEditing() {
        IFile file;
        IStatus status;
        if (this.isReadOnly() && (status = EditingUtility.checkEditing((IFile)(file = (IFile)this.getEditorInput().getAdapter(IFile.class)), (Shell)this.getSite().getShell())) != null) {
            if (status.getSeverity() != 8 && status.getSeverity() != 4) {
                this.handleActivate();
            }
            return false;
        }
        return true;
    }

    protected IToolBarManager getToolBarManager(ColumnViewer viewer) {
        Control bar;
        Composite parent;
        IToolBarManager manager = this.toolbars.get(viewer);
        if (manager == null && (parent = viewer.getControl().getParent()) instanceof ViewForm && (bar = ((ViewForm)parent).getTopRight()) instanceof ToolBar) {
            manager = new ToolBarManager((ToolBar)bar);
            this.toolbars.put(viewer, manager);
        }
        return manager;
    }

    @Override
    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.createPageInterface();
            this.createPageInformation();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SavvytestInterfaceEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    SavvytestInterfaceEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SavvytestInterfaceEditor.this.updateProblemIndication();
            }
        });
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getContainer()});
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkMissingResources(Interface iface) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for missing resources in interface: " + iface.getId(), LogLevel.DEBUG, SavvytestInterfaceEditor.class);
        Map missingResources = MissingResourceUtil.checkMissingResourcesForInterface((Interface)iface);
        if (missingResources.isEmpty()) {
            SavvytestSettings.INSTANCE.getLogger().log("All resources are present.", LogLevel.DEBUG, SavvytestInterfaceEditor.class);
            return;
        }
        String missingResourcesString = MissingResourceUtil.buildMissingResourcesString((Map)missingResources, (String)"\n");
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), SavvytestInterfaceEditor.getClassString("missingresourcetitle", new Object[0]), null, MessageFormat.format(SavvytestInterfaceEditor.getClassString("missingresourcemessage", new Object[0]), missingResourcesString), 1, new String[]{Savvytest.getGlobalString((String)"yes", (Object[])new Object[0]), Savvytest.getGlobalString((String)"no", (Object[])new Object[0])}, 0);
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0) {
            SavvytestSettings.INSTANCE.getLogger().log("User chose to not remove missing resources.", LogLevel.DEBUG, (Object)this);
            String msg = SavvytestInterfaceEditor.getClassString("error.missingresource", missingResourcesString.toString());
            MissingResourceException e = new MissingResourceException(msg, null, null);
            SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
            if (Savvytest.getEclipseVersion().getMajor() != 4) throw e;
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)msg);
            throw e;
        }
        SavvytestSettings.INSTANCE.getLogger().log("User chose to remove missing resources.", LogLevel.DEBUG, (Object)this);
        Iterator iter = this.resourceToDiagnosticMap.keySet().iterator();
        while (iter.hasNext()) {
            URI uri = ((Resource)iter.next()).getURI();
            for (EObject impl : missingResources.keySet()) {
                URI compare = ((BasicEObjectImpl)impl).eProxyURI();
                if (!uri.devicePath().equalsIgnoreCase(compare.devicePath())) continue;
                iter.remove();
            }
        }
        CompoundCommand cc = new CompoundCommand(){

            public boolean canUndo() {
                return false;
            }
        };
        for (Argument arg : iface.getArguments()) {
            if (!missingResources.containsKey(arg.getListructure())) continue;
            RemoveCommand cmd = new RemoveCommand(this.getEditingDomain(), (EObject)iface, (EStructuralFeature)InterfacePackage.Literals.INTERFACE__ARGUMENTS, (Object)arg);
            cc.append((Command)cmd);
        }
        if (cc.canExecute()) {
            this.editingDomain.getCommandStack().execute((Command)cc);
            this.updateProblemIndication();
            if (!this.resourceToDiagnosticMap.isEmpty()) return;
            this.removePage(this.getPageCount() - 1);
            return;
        }
        String msg = MessageFormat.format(SavvytestInterfaceEditor.getClassString("error.commandmissingresource", new Object[0]), missingResourcesString.toString());
        RuntimeException e = new RuntimeException(msg);
        SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
        throw e;
    }

    protected void createPageInterface() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return new TreeViewer(composite, 65536);
            }

            public void requestActivation() {
                super.requestActivation();
                SavvytestInterfaceEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        final IPreferenceStore prefStore = InterfaceEditorPlugin.getPreferenceStore();
        this.editParametersTreeViewer = (TreeViewer)viewerPane.getViewer();
        this.editParametersTreeViewer.setAutoExpandLevel(3);
        this.editParametersTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SavvytestInterfaceEditor.this.selectionRecursionPreventer || SavvytestInterfaceEditor.this.contentOutlineViewer == null) {
                    return;
                }
                if (!SavvytestInterfaceEditor.this.contentOutlineViewer.getSelection().equals(event.getSelection())) {
                    SavvytestInterfaceEditor.this.selectionRecursionPreventer = true;
                    SavvytestInterfaceEditor.this.contentOutlineViewer.setSelection(event.getSelection(), true);
                    SavvytestInterfaceEditor.this.selectionRecursionPreventer = false;
                }
            }
        });
        Tree tree = this.editParametersTreeViewer.getTree();
        tree.setLayoutData((Object)new FillLayout());
        tree.setFont(this.fontForeground);
        tree.setForeground(this.colorForeground);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        final TreeViewerColumn treeColumn = new TreeViewerColumn(this.editParametersTreeViewer, 0);
        treeColumn.getColumn().setText(SavvytestInterfaceEditor.getClassString("column.structure", new Object[0]));
        treeColumn.getColumn().setResizable(true);
        treeColumn.getColumn().setWidth(prefStore.getInt(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[0]));
        treeColumn.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                prefStore.setValue(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[0], treeColumn.getColumn().getWidth());
            }
        });
        ExposingEditingSupport usageEditingSupport = new ExposingEditingSupport((ColumnViewer)this.editParametersTreeViewer, (IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory), ListructurePackage.Literals.BASE_TYPE__USAGE.getName()){

            @Override
            public boolean canEdit(Object object) {
                if (!super.canEdit(object)) {
                    return false;
                }
                return SavvytestInterfaceEditor.this.checkEditing();
            }
        };
        if (this.isRestProject()) {
            final ExposingEditingSupport defaultEditingSupport = usageEditingSupport;
            usageEditingSupport = new EditingSupport((ColumnViewer)this.editParametersTreeViewer){

                private boolean isUpdateNeeded(Object object, Object value) {
                    Object currentValue = this.getValue(object);
                    if (currentValue == null) {
                        return currentValue != value;
                    }
                    return !currentValue.equals(value);
                }

                protected void setValue(Object element, Object value) {
                    if (element instanceof Listructure) {
                        if (this.isUpdateNeeded(element, value)) {
                            Listructure li = (Listructure)element;
                            Argument arg = SavvytestInterfaceEditor.getArgument(li);
                            CompoundCommand cc = SavvytestInterfaceEditor.this.createPropCommand(arg, PropertiesUtils.PropertyEnum.USAGE_TARGET, value);
                            SavvytestInterfaceEditor.this.getEditingDomain().getCommandStack().execute((Command)cc);
                        }
                    } else {
                        defaultEditingSupport.setValue(element, value);
                    }
                }

                protected Object getValue(Object element) {
                    if (element instanceof Listructure) {
                        return PropertiesUtils.getStringProperty((Properties)SavvytestInterfaceEditor.getArgument((Listructure)element).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET);
                    }
                    return defaultEditingSupport.getValue(element);
                }

                protected CellEditor getCellEditor(Object element) {
                    if (element instanceof Listructure) {
                        ComboBoxViewerCellEditor editor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl(), 12);
                        editor.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                        editor.setInput((Object)new String[]{"TARGET", "INPUT", "RESPONSE", "OUTPUT"});
                        return editor;
                    }
                    return defaultEditingSupport.getCellEditor(element);
                }

                protected boolean canEdit(Object element) {
                    if (element instanceof Listructure) {
                        return SavvytestInterfaceEditor.this.checkEditing();
                    }
                    return defaultEditingSupport.canEdit(element);
                }
            };
        }
        final TreeViewerColumn usageColumn = new TreeViewerColumn(this.editParametersTreeViewer, 0);
        usageColumn.getColumn().setText(SavvytestInterfaceEditor.getClassString("column.usage", new Object[0]));
        usageColumn.getColumn().setResizable(true);
        usageColumn.getColumn().setWidth(prefStore.getInt(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[1]));
        usageColumn.setEditingSupport((EditingSupport)usageEditingSupport);
        usageColumn.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                prefStore.setValue(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[1], usageColumn.getColumn().getWidth());
            }
        });
        final TreeViewerColumn valueInputColumn = new TreeViewerColumn(this.editParametersTreeViewer, 0);
        valueInputColumn.getColumn().setText(SavvytestInterfaceEditor.getClassString("column.defaultvalue", new Object[0]));
        valueInputColumn.getColumn().setResizable(true);
        valueInputColumn.getColumn().setWidth(prefStore.getInt(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[2]));
        valueInputColumn.getColumn().addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                prefStore.setValue(SavvytestPreferencesPage.INTERFACE_EDITOR_MAINEDIT_COLUMNS_PREFERENCES[2], valueInputColumn.getColumn().getWidth());
            }
        });
        this.editParametersTreeViewer.setColumnProperties(new String[]{"ColumnStructure", "ColumnUsage", "ColumnInput"});
        this.editParametersTreeViewer.setContentProvider((IContentProvider)new InterfaceContentProvider((AdapterFactory)this.adapterFactory));
        this.editParametersTreeViewer.setLabelProvider((IBaseLabelProvider)new InterfaceLabelProvider((AdapterFactory)this.adapterFactory));
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        InterfaceUi uiInterface = (InterfaceUi)resource.getContents().get(1);
        this.editParametersTreeViewer.setInput((Object)uiInterface);
        this.editParametersTreeViewer.expandToLevel(3);
        TreePropertyEditingSupport treeEditor = new TreePropertyEditingSupport(this.editParametersTreeViewer, (AdapterFactory)this.adapterFactory, ListructurePackage.Literals.BASE_TYPE__ALIAS.getName()){

            protected boolean canEdit(Object object) {
                if (!super.canEdit(object)) {
                    return false;
                }
                return SavvytestInterfaceEditor.this.checkEditing();
            }

            protected String displayItemText(Object object) {
                if (object instanceof Listructure) {
                    Listructure li = (Listructure)object;
                    Argument arg = SavvytestInterfaceEditor.getArgument(li);
                    String alias = PropertiesUtils.getStringProperty((Properties)arg.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
                    if (alias != null && !alias.isEmpty()) {
                        return alias;
                    }
                    return li.getName();
                }
                String alias = super.displayItemText(object);
                if (alias != null && !alias.isEmpty()) {
                    return alias;
                }
                EObject eobject = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                Object name = eobject.eGet((EStructuralFeature)ListructurePackage.Literals.BASE_TYPE__NAME);
                return name.toString();
            }

            protected void updateItemText(Object object, String orgText) {
                String text = orgText.trim();
                if (!this.isUpdatedNeeded(object, text)) {
                    return;
                }
                EObject obj = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                if (obj instanceof Listructure) {
                    Listructure li = (Listructure)obj;
                    Argument arg = SavvytestInterfaceEditor.getArgument(li);
                    CompoundCommand cc = SavvytestInterfaceEditor.this.createPropCommand(arg, PropertiesUtils.PropertyEnum.ALIAS, text.isEmpty() ? null : text);
                    SavvytestInterfaceEditor.this.getEditingDomain().getCommandStack().execute((Command)cc);
                    return;
                }
                if (text.isEmpty()) {
                    super.updateItemText(object, "");
                    return;
                }
                Object name = obj.eGet((EStructuralFeature)ListructurePackage.Literals.BASE_TYPE__NAME);
                if (name != null && text.equals(name.toString())) {
                    super.updateItemText(object, "");
                    return;
                }
                super.updateItemText(object, text);
            }
        };
        TreePropertyEditingSupport valueEditor = new TreePropertyEditingSupport(this.editParametersTreeViewer, (AdapterFactory)this.adapterFactory, ListructurePackage.Literals.BASE_TYPE__INITIAL.getName()){

            private String formatText(String text) {
                String retString = UtilityFunctions.rightTrim((String)text);
                if (retString.length() == 0 && text.length() > 0) {
                    retString = " ";
                }
                return retString;
            }

            protected String displayItemText(Object object) {
                String text = super.displayItemText(object);
                if (text == null || text.length() == 0) {
                    AdapterFactoryLabelProvider labelProvider = (AdapterFactoryLabelProvider)valueInputColumn.getViewer().getLabelProvider();
                    text = labelProvider.getColumnText(object, this.getColumn());
                }
                return text;
            }

            protected void updateItemText(Object object, String text) {
                AdapterFactoryLabelProvider labelProvider;
                if (this.handleStruct(object, text)) {
                    return;
                }
                if (!this.isUpdatedNeeded(object, text)) {
                    return;
                }
                if (text == null || text.length() == 0) {
                    super.updateItemText(object, null);
                    return;
                }
                String formattedText = this.formatText(text);
                if (formattedText.equals((labelProvider = (AdapterFactoryLabelProvider)valueInputColumn.getViewer().getLabelProvider()).getColumnText(object, this.getColumn()))) {
                    return;
                }
                EObject unwrap = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                EReference ref = unwrap.eContainmentFeature();
                if (ref == ListructurePackage.Literals.CONTAINER_TYPE__NUMBER || ref == ListructurePackage.Literals.LISTRUCTURE__NUMBER) {
                    try {
                        new BigDecimal(formattedText);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                SavvytestSettings.INSTANCE.getLogger().log("Updating item. Dirty: " + SavvytestInterfaceEditor.this.isDirty(), LogLevel.DEBUG, (Object)this);
                super.updateItemText(object, formattedText);
                SavvytestSettings.INSTANCE.getLogger().log("Finished updating item. Dirty: " + SavvytestInterfaceEditor.this.isDirty(), LogLevel.DEBUG, (Object)this);
            }

            protected boolean canEdit(Object object) {
                AtomicType atomic;
                Boolean bool;
                if (!super.canEdit(object)) {
                    return false;
                }
                EObject unwrapped = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                EReference ref = unwrapped.eContainmentFeature();
                if (ref == ListructurePackage.Literals.CONTAINER_TYPE__ARRAY || ref == ListructurePackage.Literals.LISTRUCTURE__ARRAY) {
                    return false;
                }
                if ((ref == ListructurePackage.Literals.CONTAINER_TYPE__NUMBER || ref == ListructurePackage.Literals.CONTAINER_TYPE__STRING || ref == ListructurePackage.Literals.LISTRUCTURE__NUMBER || ref == ListructurePackage.Literals.LISTRUCTURE__STRING) && (bool = PropertiesUtils.getBooleanProperty((Properties)(atomic = (AtomicType)unwrapped).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER)) != null && bool.booleanValue()) {
                    return false;
                }
                return SavvytestInterfaceEditor.this.checkEditing();
            }

            private boolean handleStruct(Object object, String text) {
                EObject unwrapped = (EObject)AdapterFactoryEditingDomain.unwrap((Object)object);
                EReference ref = unwrapped.eContainmentFeature();
                if (ref == ListructurePackage.Literals.CONTAINER_TYPE__STRUCT || ref == ListructurePackage.Literals.LISTRUCTURE__STRUCT) {
                    final CompoundCommand cc = new CompoundCommand();
                    StructType struct = (StructType)unwrapped;
                    BaseTypeVisitorImpl visitor = new BaseTypeVisitorImpl(text){
                        private String remainingText;
                        {
                            this.remainingText = string;
                        }

                        public Object visitAtomic(AtomicType atomic) throws Exception {
                            String textSegment = this.getTextSegment((BaseType)atomic);
                            if (textSegment == null) {
                                return null;
                            }
                            cc.append(SetCommand.create((EditingDomain)(this).SavvytestInterfaceEditor.this.editingDomain, (Object)atomic, (Object)ListructurePackage.Literals.BASE_TYPE__INITIAL, (Object)textSegment));
                            return null;
                        }

                        public Object visit(FeatureMap.Entry entry) throws Exception {
                            if (this.remainingText == null || this.remainingText.isEmpty()) {
                                return null;
                            }
                            return super.visit(entry);
                        }

                        private String getTextSegment(BaseType bt) {
                            String segment;
                            if (bt == null) {
                                return null;
                            }
                            BigInteger biLength = bt.getLength();
                            if (biLength == null) {
                                return null;
                            }
                            int length = biLength.intValue();
                            if (length >= this.remainingText.length()) {
                                segment = this.remainingText;
                                this.remainingText = null;
                            } else {
                                segment = this.remainingText.substring(0, length);
                                this.remainingText = this.remainingText.substring(length);
                            }
                            return segment;
                        }
                    };
                    try {
                        visitor.visit(struct);
                    }
                    catch (Exception e) {
                        SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
                    }
                    if (!cc.isEmpty()) {
                        SavvytestInterfaceEditor.this.getEditingDomain().getCommandStack().execute((Command)cc);
                    }
                    return true;
                }
                return false;
            }
        };
        treeEditor.grabHorizontal = true;
        treeEditor.setColumn(0);
        treeEditor.setPreviousNext(valueEditor, valueEditor);
        treeEditor.setFirstLast(true, false);
        valueEditor.grabHorizontal = true;
        valueEditor.setColumn(2);
        valueEditor.setPreviousNext(treeEditor, treeEditor);
        valueEditor.setFirstLast(false, true);
        IToolBarManager manager = this.getToolBarManager((ColumnViewer)this.editParametersTreeViewer);
        ExpandAction expandAllAction = new ExpandAction(this.editParametersTreeViewer, true);
        expandAllAction.setId("expandAll");
        manager.add((IAction)expandAllAction);
        CollapseAction collapseAllAction = new CollapseAction(this.editParametersTreeViewer, true);
        collapseAllAction.setId("collapseAll");
        manager.add((IAction)collapseAllAction);
        manager.update(true);
        ExpandAction expandAction = new ExpandAction(this.editParametersTreeViewer, false);
        CollapseAction collapseAction = new CollapseAction(this.editParametersTreeViewer, false);
        Action copyAction = new Action(SavvytestInterfaceEditor.getClassString("copyaction", new Object[0])){
            private final Transfer[] transfer;
            {
                this.transfer = new Transfer[]{TextTransfer.getInstance()};
            }

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)SavvytestInterfaceEditor.this.editParametersTreeViewer.getSelection();
                if (selection.size() == 1) {
                    Object element = selection.getFirstElement();
                    InterfaceLabelProvider labelProvider = (InterfaceLabelProvider)SavvytestInterfaceEditor.this.editParametersTreeViewer.getLabelProvider();
                    String text = labelProvider.getColumnText(element, 2);
                    if (text != null && !text.isEmpty()) {
                        Clipboard clipboard = new Clipboard(SavvytestInterfaceEditor.this.editParametersTreeViewer.getControl().getDisplay());
                        clipboard.setContents((Object[])new String[]{text}, this.transfer);
                        clipboard.dispose();
                    }
                }
            }
        };
        this.createContextMenu((Viewer)this.editParametersTreeViewer, new IAction[]{expandAction, collapseAction, copyAction});
        ToolTipHandler toolTipHandler = new ToolTipHandler(tree.getShell()){

            public String getHoverText(Object object, int column) {
                Object unwrapped;
                String hoverText = null;
                if (column == 0) {
                    Object unwrapped2 = AdapterFactoryEditingDomain.unwrap((Object)object);
                    if (unwrapped2 instanceof AtomicType) {
                        AtomicType atomic = (AtomicType)unwrapped2;
                        hoverText = MessageFormat.format(SavvytestInterfaceEditor.getClassString("tooltipid", new Object[0]), atomic.getId());
                    }
                } else if (column == 2 && (unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof AtomicType) {
                    AtomicType atomic = (AtomicType)unwrapped;
                    String liType = PropertiesUtils.getStringProperty((Properties)atomic.getProperties(), (String)"liType");
                    if (liType != null) {
                        liType = MessageFormat.format(SavvytestInterfaceEditor.getClassString("tooltiplistructure", new Object[0]), liType);
                    }
                    String maxLength = null;
                    BigInteger length = atomic.getLength();
                    BigDecimal scale = PropertiesUtils.getNumberProperty((Properties)atomic.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.SCALE);
                    if (length != null) {
                        if (scale != null) {
                            int scaleDigits = scale.toPlainString().length();
                            BigDecimal value = new BigDecimal(length.intValue() - scale.intValue());
                            value = value.scaleByPowerOfTen(scaleDigits);
                            value = value.add(scale);
                            value = value.scaleByPowerOfTen(-scaleDigits);
                            maxLength = MessageFormat.format(SavvytestInterfaceEditor.getClassString("tooltiplength", new Object[0]), value);
                        } else {
                            maxLength = MessageFormat.format(SavvytestInterfaceEditor.getClassString("tooltiplength", new Object[0]), length);
                        }
                    }
                    if (liType != null && maxLength != null) {
                        hoverText = String.valueOf(liType) + '\n' + maxLength;
                    } else if (liType != null) {
                        hoverText = liType;
                    } else if (maxLength != null) {
                        hoverText = maxLength;
                    }
                }
                return hoverText;
            }

            public Image getHoverImage(Object object, int column) {
                Image hoverImage = null;
                if ((column == 0 || column == 2) && AdapterFactoryEditingDomain.unwrap((Object)object) instanceof AtomicType) {
                    InterfaceLabelProvider labelProvider = (InterfaceLabelProvider)SavvytestInterfaceEditor.this.editParametersTreeViewer.getLabelProvider();
                    hoverImage = labelProvider.getImage(object);
                }
                return hoverImage;
            }
        };
        toolTipHandler.activateHoverHelp((Control)tree);
        this.interfacePageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(this.interfacePageIndex, SavvytestInterfaceEditor.getClassString("pagetitle", new Object[0]));
    }

    private CompoundCommand createPropCommand(Argument arg, PropertiesUtils.PropertyEnum type, Object value) {
        Property prop;
        CompoundCommand cc = new CompoundCommand();
        Properties props = arg.getProperties();
        if (props == null) {
            props = PropertiesFactory.eINSTANCE.createProperties();
            cc.append(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)arg, (Object)InterfacePackage.eINSTANCE.getArgument_Properties(), (Object)props));
        }
        if ((prop = PropertiesUtils.getProperty((Properties)props, (PropertiesUtils.PropertyEnum)type)) == null) {
            prop = PropertiesFactory.eINSTANCE.createProperty();
            prop.setName(type.getName());
            prop.setType(type.getType());
            cc.append(AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)props, (Object)PropertiesPackage.eINSTANCE.getProperties_Properties(), (Object)prop));
        }
        cc.append(SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)prop, (Object)PropertiesPackage.eINSTANCE.getProperty_Value(), (Object)value));
        return cc;
    }

    private void createPageInformation() {
        AdditionalInterfaceInformation info = new AdditionalInterfaceInformation(this, this.getContainer(), 0);
        info.init();
        this.infoPageIndex = this.addPage((Control)info);
        this.setPageText(this.infoPageIndex, SavvytestInterfaceEditor.getClassString("infopagetitle", new Object[0]));
    }

    @Override
    public void doSave(IProgressMonitor progressMonitor) {
        Resource resource = (Resource)this.editingDomain.getResourceSet().getResources().get(0);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        Interface iface = root.getInterface();
        InterfaceUi interfaceUi = (InterfaceUi)resource.getContents().get(1);
        int i = 0;
        while (i < interfaceUi.getArgumentsUi().size()) {
            Listructure listructure = (Listructure)interfaceUi.getArgumentsUi().get(i);
            final EList baseTypeExtensions = ((Argument)iface.getArguments().get(i)).getBaseTypeExtensions();
            final Map map = InterfaceUtils.createBaseTypeExtensionMap((Collection)baseTypeExtensions);
            BaseTypeVisitorImpl visitor = new BaseTypeVisitorImpl(){

                protected Object visitAtomic(AtomicType atomic) throws Exception {
                    this.updateProperties((BaseType)atomic);
                    return super.visitAtomic(atomic);
                }

                protected Object visitContainer(ContainerType container) throws Exception {
                    if (this.updateProperties((BaseType)container)) {
                        return super.visitContainer(container);
                    }
                    return null;
                }

                private boolean updateProperties(BaseType base) {
                    BaseTypeExtension bte = (BaseTypeExtension)map.get(base.getId());
                    if (bte == null) {
                        InterfaceUtils.createBaseTypeExtension((BaseType)base, (Collection)baseTypeExtensions, EnumSet.of(PropertiesUtils.PropertyEnum.ALIAS, PropertiesUtils.PropertyEnum.USAGE, PropertiesUtils.PropertyEnum.VALUE));
                        return false;
                    }
                    this.updateProperty(base.getAlias(), base, bte, PropertiesUtils.PropertyEnum.ALIAS);
                    this.updateProperty(base.getUsage().getName(), base, bte, PropertiesUtils.PropertyEnum.USAGE);
                    this.updateProperty(base.getInitial(), base, bte, PropertiesUtils.PropertyEnum.VALUE);
                    return true;
                }

                private void updateProperty(String value, BaseType bt, BaseTypeExtension bte, PropertiesUtils.PropertyEnum propEnum) {
                    Property property = PropertiesUtils.getProperty((Properties)bte.getProperties(), (PropertiesUtils.PropertyEnum)propEnum);
                    if (UtilityFunctions.isEmpty((String)value)) {
                        if (property != null) {
                            bte.getProperties().getProperties().remove((Object)property);
                        }
                    } else if (property == null) {
                        property = PropertiesUtils.PropertyEnum.VALUE == propEnum ? ListructureUtils.createInitialProperty((BaseType)bt) : PropertiesUtils.createProperty((PropertiesUtils.PropertyEnum)propEnum, (String)value);
                        bte.getProperties().getProperties().add((Object)property);
                    } else {
                        property.setValue(value);
                    }
                }
            };
            try {
                visitor.visit(listructure);
            }
            catch (Exception e) {
                SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            }
            ++i;
        }
        super.doSave(progressMonitor);
    }

    @Override
    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    SavvytestInterfaceEditor.this.contentOutlineViewer = this.getTreeViewer();
                    SavvytestInterfaceEditor.this.contentOutlineViewer.getTree().setFont(SavvytestSettings.INSTANCE.getFont("com.savvytest.eclipse.common.fontNormal"));
                    SavvytestInterfaceEditor.this.contentOutlineViewer.getTree().setForeground(SavvytestSettings.INSTANCE.getColor("com.savvytest.eclipse.common.colorForeground"));
                    SavvytestInterfaceEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    SavvytestInterfaceEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)SavvytestInterfaceEditor.this.editParametersTreeViewer.getLabelProvider(0));
                    SavvytestInterfaceEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new InterfaceContentProvider((AdapterFactory)SavvytestInterfaceEditor.this.adapterFactory));
                    SavvytestInterfaceEditor.this.contentOutlineViewer.setFilters(SavvytestInterfaceEditor.this.editParametersTreeViewer.getFilters());
                    SavvytestInterfaceEditor.this.contentOutlineViewer.setInput(SavvytestInterfaceEditor.this.editParametersTreeViewer.getInput());
                    ExpandAction expandAction = new ExpandAction(SavvytestInterfaceEditor.this.contentOutlineViewer, false);
                    CollapseAction collapseAction = new CollapseAction(SavvytestInterfaceEditor.this.contentOutlineViewer, false);
                    SavvytestInterfaceEditor.this.createContextMenu((Viewer)SavvytestInterfaceEditor.this.contentOutlineViewer, new IAction[]{expandAction, collapseAction});
                    if (!SavvytestInterfaceEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        SavvytestInterfaceEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(SavvytestInterfaceEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    SavvytestInterfaceEditor.this.contentOutlineStatusLineManager = statusLineManager;
                    ExpandAction expandAllAction = new ExpandAction(SavvytestInterfaceEditor.this.contentOutlineViewer, true);
                    expandAllAction.setId("expandAll");
                    toolBarManager.add((IAction)expandAllAction);
                    CollapseAction collapseAllAction = new CollapseAction(SavvytestInterfaceEditor.this.contentOutlineViewer, true);
                    collapseAllAction.setId("collapseAll");
                    toolBarManager.add((IAction)collapseAllAction);
                    toolBarManager.update(true);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    SavvytestInterfaceEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SavvytestInterfaceEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    @Override
    public void handleContentOutlineSelection(ISelection selection) {
        if (this.selectionRecursionPreventer) {
            return;
        }
        try {
            this.selectionRecursionPreventer = true;
            if (selection instanceof IStructuredSelection && !this.editParametersTreeViewer.getSelection().equals(selection)) {
                this.editParametersTreeViewer.setSelection(selection, true);
            }
        }
        finally {
            this.selectionRecursionPreventer = false;
        }
    }

    @Override
    protected void pageChange(int pageIndex) {
        if (this.contentOutlineViewer != null) {
            this.contentOutlineViewer.setInput(null);
            switch (pageIndex) {
                case 0: {
                    this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)this.editParametersTreeViewer.getLabelProvider(0));
                    this.contentOutlineViewer.setContentProvider((IContentProvider)new InterfaceContentProvider((AdapterFactory)this.adapterFactory));
                    this.contentOutlineViewer.setFilters(this.editParametersTreeViewer.getFilters());
                    this.contentOutlineViewer.setInput(this.editParametersTreeViewer.getInput());
                    break;
                }
                case 1: {
                    this.contentOutlineViewer.setInput(null);
                    break;
                }
                default: {
                    SavvytestSettings.INSTANCE.getLogger().log("Unkown page index: " + pageIndex, LogLevel.WARNING, (Object)this);
                    this.contentOutlineViewer.setInput(null);
                }
            }
        }
        super.pageChange(pageIndex);
    }

    private void createContextMenu(Viewer viewer, IAction ... actions) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            contextMenu.add(action);
            ++n2;
        }
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    public Map<Listructure, Map<String, BaseType>> getArgumentsMap() {
        return this.argumentMap;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRestProject() {
        return true;
    }

    protected void updateManager(Resource resource) {
        if (this.isReadOnly()) {
            SavvytestSettings.INSTANCE.getLogger().log("Editor read only. No update.", LogLevel.DEBUG, (Object)this);
            return;
        }
        SavvytestSettings.INSTANCE.getLogger().log("Checking for updates.", LogLevel.DEBUG, (Object)this);
        CompoundCommand cc = new CompoundCommand();
        cc.appendIfCanExecute(this.checkId(resource));
        if (cc.canExecute()) {
            SavvytestSettings.INSTANCE.getLogger().log("Executing updates for: " + resource, LogLevel.INFO, (Object)this);
            this.getEditingDomain().getCommandStack().execute((Command)cc);
            SavvytestSettings.INSTANCE.getLogger().log("Updates successfully finished.", LogLevel.INFO, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("No updates needed.", LogLevel.DEBUG, (Object)this);
        }
    }

    private Command checkId(Resource resource) {
        SavvytestSettings.INSTANCE.getLogger().log("Checking for update of interface ID.", LogLevel.DEBUG, (Object)this);
        DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            String currentId;
            IFile file = ((FileEditorInput)input).getFile();
            String filepath = URI.encodeOpaquePart((String)file.getProjectRelativePath().toString(), (boolean)true);
            if (!filepath.equals(currentId = root.getInterface().getId())) {
                SavvytestSettings.INSTANCE.getLogger().log("Filename: " + filepath + ". Interface ID: " + currentId + ". Need to update.", LogLevel.DEBUG, (Object)this);
                return new SetCommand(this.getEditingDomain(), (EObject)root.getInterface(), (EStructuralFeature)InterfacePackage.Literals.INTERFACE__ID, (Object)filepath);
            }
            SavvytestSettings.INSTANCE.getLogger().log("No update needed.", LogLevel.DEBUG, (Object)this);
        } else {
            SavvytestSettings.INSTANCE.getLogger().log("Editor input is not a file, can't check for change.", LogLevel.DEBUG, (Object)this);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static class ExposingEditingSupport
    extends CheckingPropertyEditingSupport {
        public ExposingEditingSupport(ColumnViewer viewer, IPropertySourceProvider propertySourceProvider, Object propertyID) {
            super(viewer, propertySourceProvider, propertyID);
        }

        public CellEditor getCellEditor(Object element) {
            return super.getCellEditor(element);
        }

        public boolean canEdit(Object element) {
            return super.canEdit(element);
        }

        public Object getValue(Object element) {
            return super.getValue(element);
        }

        public void setValue(Object element, Object value) {
            super.setValue(element, value);
        }
    }

    private static class InterfaceContentProvider
    extends AdapterFactoryContentProvider {
        public InterfaceContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public boolean hasChildren(Object object) {
            if (!(object instanceof DelegatingWrapperItemProvider)) {
                return super.hasChildren(object);
            }
            for (Object obj : ((DelegatingWrapperItemProvider)object).getElements(object)) {
                if (obj instanceof Properties) continue;
                return true;
            }
            return false;
        }

        public Object[] getChildren(Object object) {
            Object[] objects = super.getChildren(object);
            ArrayList<Object> list = new ArrayList<Object>(objects.length);
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (!(AdapterFactoryEditingDomain.unwrap((Object)obj) instanceof Properties)) {
                    list.add(obj);
                }
                ++n2;
            }
            if (list.size() != objects.length) {
                return list.toArray();
            }
            return objects;
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == PropertiesPackage.eINSTANCE.getProperty_Value()) {
                EObject eObj = ((EObject)notification.getNotifier()).eContainer().eContainer();
                if (eObj instanceof Argument) {
                    Argument arg = (Argument)eObj;
                    Listructure li = SavvytestInterfaceEditor.getListructure(arg);
                    super.notifyChanged((Notification)new ViewerNotification(notification, (Object)li, false, true));
                }
            } else {
                super.notifyChanged(notification);
            }
        }
    }

    private class InterfaceLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableColorProvider {
        private final ImageDescriptor redefineDescriptor;
        private final ArrayList<Image> createdImages;
        private final HashSet<EReference> allowedReferences;

        public InterfaceLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.redefineDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(InterfaceEditorPlugin.INSTANCE.getImage("overlay/RedefinedOverlay.png"));
            this.createdImages = new ArrayList();
            this.allowedReferences = new HashSet(4);
            this.allowedReferences.add(ListructurePackage.Literals.CONTAINER_TYPE__NUMBER);
            this.allowedReferences.add(ListructurePackage.Literals.CONTAINER_TYPE__STRING);
            this.allowedReferences.add(ListructurePackage.Literals.LISTRUCTURE__NUMBER);
            this.allowedReferences.add(ListructurePackage.Literals.LISTRUCTURE__STRING);
        }

        public void dispose() {
            super.dispose();
            for (Image img : this.createdImages) {
                if (img.isDisposed()) continue;
                img.dispose();
            }
        }

        public Color getForeground(Object object, int columnIndex) {
            if (columnIndex == 0) {
                Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (obj instanceof BaseType && PropertiesUtils.getBooleanProperty((Properties)((BaseType)obj).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER, (boolean)false)) {
                    return SavvytestInterfaceEditor.this.colorIrrelevant;
                }
            } else if (columnIndex == 2) {
                Matcher hex;
                String text;
                StringType type;
                BigInteger length;
                Object obj = AdapterFactoryEditingDomain.unwrap((Object)object);
                if (obj instanceof StringType && (length = (type = (StringType)obj).getLength()) != null && (text = this.getColumnText(object, columnIndex)) != null && ((hex = Savvytest.HEX_NUMBER.matcher(text)).matches() ? hex.group(1).length() / 2 > length.intValue() : text.length() > length.intValue())) {
                    return SavvytestInterfaceEditor.this.colorError;
                }
                String value = super.getColumnText(object, columnIndex);
                if (value == null || value.length() == 0) {
                    return SavvytestInterfaceEditor.this.colorDefault;
                }
            }
            return super.getForeground(object, columnIndex);
        }

        public String getColumnText(Object object, int columnIndex) {
            if (columnIndex == 0) {
                if (object instanceof Listructure) {
                    Listructure li = (Listructure)object;
                    InterfaceUi ui = (InterfaceUi)li.eContainer();
                    int index = ui.getArgumentsUi().indexOf((Object)li);
                    Argument arg = (Argument)ui.getArguments().get(index);
                    String alias = PropertiesUtils.getStringProperty((Properties)arg.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
                    if (alias != null && !alias.isEmpty()) {
                        return String.valueOf(DataEditPlugin.INSTANCE.getString("_UI_Listructure_type")) + " " + alias;
                    }
                } else {
                    BaseType baseType;
                    Object unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object);
                    if (unwrapped instanceof BaseType && PropertiesUtils.getBooleanProperty((Properties)(baseType = (BaseType)unwrapped).getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.FILLER, (boolean)false) && baseType.getAlias() == null) {
                        return "FILLER";
                    }
                }
            } else if (columnIndex == 1) {
                if (object instanceof Listructure && SavvytestInterfaceEditor.this.isRestProject()) {
                    Argument arg = SavvytestInterfaceEditor.getArgument((Listructure)object);
                    String usageTarget = PropertiesUtils.getStringProperty((Properties)arg.getProperties(), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE_TARGET);
                    return usageTarget == null ? SavvytestInterfaceEditor.getClassString("undefined", new Object[0]) : usageTarget;
                }
            } else if (columnIndex == 2 && object instanceof DelegatingWrapperItemProvider) {
                BaseType bt;
                String defaultValue = super.getColumnText(object, columnIndex);
                if (defaultValue == null && this.allowedReferences.contains((bt = (BaseType)((DelegatingWrapperItemProvider)object).getEditableValue(object)).eContainmentFeature())) {
                    Listructure li = this.getListructure((EObject)bt);
                    BaseType liBT = (BaseType)((Map)SavvytestInterfaceEditor.this.argumentMap.get(li)).get(bt.getId());
                    return liBT.getInitial();
                }
                return defaultValue;
            }
            return super.getColumnText(object, columnIndex);
        }

        private Listructure getListructure(EObject object) {
            EObject obj = object;
            while (obj != null) {
                if (obj instanceof Listructure) {
                    return (Listructure)obj;
                }
                obj = obj.eContainer();
            }
            return null;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            Properties props;
            Object unwrapped;
            Image image = super.getColumnImage(object, columnIndex);
            if (columnIndex == 0 && image != null && (unwrapped = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof BaseType && (PropertiesUtils.hasProperty((Properties)(props = ((BaseType)unwrapped).getProperties()), (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.REDEFINES) || PropertiesUtils.getBooleanProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.REDEFINED, (boolean)false))) {
                image = this.spliceRedefinedImage(image);
            }
            return image;
        }

        private Image spliceRedefinedImage(Image image) {
            Image spliceImg = this.redefineDescriptor.createImage((Device)SavvytestInterfaceEditor.this.getSite().getShell().getDisplay());
            if (spliceImg != null) {
                Image img = new Image(image.getDevice(), image.getImageData());
                GC gc = new GC((Drawable)img);
                gc.drawImage(spliceImg, image.getBounds().width - spliceImg.getBounds().width, image.getBounds().height - spliceImg.getBounds().height);
                gc.dispose();
                spliceImg.dispose();
                this.createdImages.add(img);
                return img;
            }
            System.err.println("Could not splice redefine image onto base type image.");
            return image;
        }
    }
}

