/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.migration;

import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.iface.InterfacePackage;
import com.savvytest.eclipse.core.model.xml.iface.util.InterfaceElementMigrationInfo;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.UsageType;
import com.savvytest.eclipse.core.model.xml.listructure.impl.BaseTypeImpl;
import com.savvytest.eclipse.core.model.xml.properties.Properties;
import com.savvytest.eclipse.core.model.xml.properties.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class InterfaceElementMigration {
    public final Map<BaseTypeExtension, BaseTypeExtension> migrationMap = new HashMap<BaseTypeExtension, BaseTypeExtension>();
    private HashMap<BaseTypeExtension, String[]> mapBTE2String;
    private InterfaceElementMigrationInfo iemi;

    public InterfaceElementMigration() {
        this(null);
    }

    public InterfaceElementMigration(InterfaceElementMigrationInfo info) {
        this.iemi = info;
    }

    public void prepare() {
        this.prepare(true);
    }

    protected void prepare(boolean overwrite) {
        if (overwrite || this.mapBTE2String == null) {
            this.mapBTE2String = new HashMap(this.iemi.addedElements.size() + this.iemi.unusedElements.size());
            Set[] setArray = new Set[]{this.iemi.addedElements, this.iemi.unusedElements};
            int n = setArray.length;
            int n2 = 0;
            while (n2 < n) {
                Set set = setArray[n2];
                for (BaseTypeExtension bte : set) {
                    BaseType bt = bte.getBaseType();
                    String id = bt.eIsProxy() ? ((BaseTypeImpl)bt).eProxyURI().fragment() : bt.getId();
                    String[] tokenized = id.split("\\.");
                    this.mapBTE2String.put(bte, tokenized);
                }
                ++n2;
            }
        }
    }

    public void compute() {
        this.computeSameName();
    }

    public void computeSameName() {
        this.prepare(false);
        for (BaseTypeExtension addedBTE : this.iemi.addedElements) {
            int matchCount = 0;
            BaseTypeExtension matched = null;
            String[] added = this.mapBTE2String.get(addedBTE);
            for (BaseTypeExtension unusedBTE : this.iemi.unusedElements) {
                String[] compare = this.mapBTE2String.get(unusedBTE);
                int minSize = Math.min(added.length, compare.length);
                int i = 1;
                while (i <= minSize) {
                    if (!added[added.length - i].equalsIgnoreCase(compare[compare.length - i])) break;
                    ++i;
                }
                if (i - 1 <= matchCount) continue;
                matchCount = i - 1;
                matched = unusedBTE;
                if (matchCount == added.length) break;
            }
            if (matched == null) continue;
            this.migrationMap.put(matched, addedBTE);
        }
    }

    public void applyMap(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand(){

            public boolean canUndo() {
                return false;
            }
        };
        InterfaceElementMigrationInfo workingCopy = this.iemi.clone();
        for (Map.Entry<BaseTypeExtension, BaseTypeExtension> entry : this.migrationMap.entrySet()) {
            Properties props = entry.getKey().getProperties();
            BaseType baseType = (BaseType)workingCopy.mapExtension2UIBaseType.get(entry.getValue());
            UsageType usage = null;
            if (PropertiesUtils.hasProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.USAGE)) {
                usage = PropertiesUtils.getUsage((Properties)props);
            }
            if (usage == null) {
                usage = this.getParentUsage(baseType);
            }
            String fixedValue = PropertiesUtils.getPropertyValue((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.VALUE);
            String aliasValue = PropertiesUtils.getStringProperty((Properties)props, (PropertiesUtils.PropertyEnum)PropertiesUtils.PropertyEnum.ALIAS);
            entry.getValue().setProperties(props);
            baseType.setAlias(aliasValue);
            baseType.setInitial(fixedValue);
            if (usage == null) continue;
            baseType.setUsage(usage);
        }
        for (BaseTypeExtension removeData : workingCopy.unusedElements) {
            cc.append(RemoveCommand.create((EditingDomain)editingDomain, (Object)removeData));
        }
        for (BaseTypeExtension addData : workingCopy.addedElements) {
            BaseType baseType = (BaseType)workingCopy.mapExtension2UIBaseType.get(addData);
            if (!baseType.isSetUsage()) {
                UsageType usage = this.getParentUsage(baseType);
                baseType.setUsage(usage);
            }
            cc.append(AddCommand.create((EditingDomain)editingDomain, (Object)workingCopy.argument, (Object)InterfacePackage.Literals.ARGUMENT__BASE_TYPE_EXTENSIONS, (Object)addData));
        }
        if (!cc.isEmpty()) {
            if (cc.canExecute()) {
                editingDomain.getCommandStack().execute((Command)cc);
            } else {
                BasicDiagnostic diagnostic = new BasicDiagnostic(4, this.getClass().toString(), 0, "Migration failed because command couldn't be executed: " + cc, null);
                DiagnosticException diagnosticException = new DiagnosticException((Diagnostic)diagnostic);
                throw new WrappedException((Exception)diagnosticException);
            }
        }
    }

    private UsageType getParentUsage(BaseType baseType) {
        if (baseType != null) {
            EObject obj = baseType.eContainer();
            while (obj instanceof BaseType) {
                if (((BaseType)obj).getUsage() != null) {
                    return ((BaseType)obj).getUsage();
                }
                obj = obj.eContainer();
            }
        }
        return null;
    }

    public void setElementMigrationInfo(InterfaceElementMigrationInfo iemi) {
        this.iemi = iemi;
        this.mapBTE2String = null;
        this.migrationMap.clear();
    }

    public InterfaceElementMigrationInfo getElementMigrationInfo() {
        return this.iemi;
    }
}

