/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.editor.iface.migration;

import com.savvytest.eclipse.common.util.ScrollableDialog;
import com.savvytest.eclipse.core.model.xml.iface.BaseTypeExtension;
import com.savvytest.eclipse.core.model.xml.listructure.BaseType;
import com.savvytest.eclipse.core.model.xml.listructure.impl.BaseTypeImpl;
import com.savvytest.eclipse.editor.iface.gui.InterfaceEditorPlugin;
import com.savvytest.eclipse.editor.iface.migration.InterfaceElementMigration;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;

public class InterfaceElementMigrationDialog
extends ScrollableDialog {
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.editor.iface.migration.InterfaceElementMigrationDialog.";

    private static String getClassString(String key, Object ... substitutes) {
        String translation = InterfaceEditorPlugin.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    private static String prepareMessage(InterfaceElementMigration iem) {
        HashSet added = new HashSet(iem.getElementMigrationInfo().addedElements);
        HashSet unused = new HashSet(iem.getElementMigrationInfo().unusedElements);
        StringBuilder builder = new StringBuilder(iem.migrationMap.size() * 120);
        String pattern = InterfaceElementMigrationDialog.getClassString("message.migration", new Object[0]);
        for (Map.Entry<BaseTypeExtension, BaseTypeExtension> entry : iem.migrationMap.entrySet()) {
            builder.append(MessageFormat.format(pattern, InterfaceElementMigrationDialog.getId(entry.getKey()), InterfaceElementMigrationDialog.getId(entry.getValue())));
            unused.remove(entry.getKey());
            added.remove(entry.getValue());
        }
        String migrationString = builder.toString();
        if (migrationString.length() == 0) {
            migrationString = InterfaceElementMigrationDialog.getClassString("message.empty", new Object[0]);
        }
        builder.setLength(0);
        pattern = InterfaceElementMigrationDialog.getClassString("message.new", new Object[0]);
        for (BaseTypeExtension pd : added) {
            builder.append(MessageFormat.format(pattern, InterfaceElementMigrationDialog.getId(pd)));
        }
        String newString = builder.toString();
        if (newString.length() == 0) {
            newString = InterfaceElementMigrationDialog.getClassString("message.empty", new Object[0]);
        }
        builder.setLength(0);
        pattern = InterfaceElementMigrationDialog.getClassString("message.unused", new Object[0]);
        for (BaseTypeExtension pd : unused) {
            builder.append(MessageFormat.format(pattern, InterfaceElementMigrationDialog.getId(pd)));
        }
        String unusedString = builder.toString();
        if (unusedString.length() == 0) {
            unusedString = InterfaceElementMigrationDialog.getClassString("message.empty", new Object[0]);
        }
        return MessageFormat.format(InterfaceElementMigrationDialog.getClassString("message.body", new Object[0]), migrationString, newString, unusedString);
    }

    private static String getId(BaseTypeExtension bte) {
        BaseType bt = bte.getBaseType();
        String id = bt == null ? null : (bt.eIsProxy() ? ((BaseTypeImpl)bt).eProxyURI().fragment() : bt.getId());
        return id;
    }

    public InterfaceElementMigrationDialog(Shell parentShell, String listructureName, InterfaceElementMigration iem) {
        super(parentShell, InterfaceElementMigrationDialog.getClassString("title", new Object[0]), InterfaceElementMigrationDialog.getClassString("messageShort", listructureName), InterfaceElementMigrationDialog.prepareMessage(iem), 1);
    }
}

