/*
 * Decompiled with CFR 0.152.
 */
package com.savvytest.eclipse.excel.importexport;

import com.savvytest.eclipse.common.Savvytest;
import com.savvytest.eclipse.common.components.selection.SavvytestFileSelection;
import com.savvytest.eclipse.common.license.License;
import com.savvytest.eclipse.common.license.NotLicensedPage;
import com.savvytest.eclipse.common.preferences.SavvytestSettings;
import com.savvytest.eclipse.common.savvytestnature.SavvytestTypeEnum;
import com.savvytest.eclipse.common.util.editing.EditingUtility;
import com.savvytest.eclipse.common.wizards.SavvytestFileSelectionPage;
import com.savvytest.eclipse.core.model.xml.testscenario.Testscenario;
import com.savvytest.eclipse.excel.Activator;
import com.savvytest.eclipse.excel.importexport.ExcelSheetSelectionPage;
import com.savvytest.eclipse.excel.importexport.visitors.ExportCheckconditionsVisitor;
import com.savvytest.eclipse.excel.importexport.visitors.ExportVisitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class ExcelExportWizard
extends Wizard
implements IExportWizard {
    private static final String NOT_OPEN_EXCEL_AFTER_EXPORT = "NotOpenExcelAfterExport";
    private static final String TRANSLATION_PREFIX = "com.savvytest.eclipse.excel.importexport.ExcelExportWizard.";
    private ExcelSheetSelectionPage excelPage;
    private SavvytestFileSelectionPage testscenarioPage;
    private IWorkbenchPage page;

    protected static String getClassString(String key, Object ... substitutes) {
        String translation = Activator.INSTANCE.getString(TRANSLATION_PREFIX + key);
        if (substitutes.length > 0) {
            translation = MessageFormat.format(translation, substitutes);
        }
        return translation;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page = workbench.getActiveWorkbenchWindow().getActivePage();
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(Activator.INSTANCE.getImage("ExcelExportWiz")));
        if (License.getInstance().isOptionExcelIoLicensed()) {
            this.createPages();
            this.applySelection(selection);
        }
    }

    private void createPages() {
        this.testscenarioPage = new SavvytestFileSelectionPage("TestscenarioPage", 4096);
        this.testscenarioPage.setTitle(ExcelExportWizard.getClassString("testscenarioPage.title", new Object[0]));
        this.testscenarioPage.setDescription(ExcelExportWizard.getClassString("testscenarioPage.description", new Object[0]));
        final SavvytestFileSelection fileSelectionComponent = this.testscenarioPage.getFileSelectionComponent();
        fileSelectionComponent.setTypes(new SavvytestTypeEnum[]{SavvytestTypeEnum.TESTSCENARIO});
        fileSelectionComponent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IFile file = fileSelectionComponent.getSelectedFile();
                if (file == null || !file.exists()) {
                    ExcelExportWizard.this.testscenarioPage.setMessage(ExcelExportWizard.getClassString("testscenarioPage.error.chooseFile", new Object[0]), 3);
                } else {
                    ExcelExportWizard.this.testscenarioPage.setMessage(null);
                }
                ExcelExportWizard.this.testscenarioPage.setPageComplete(ExcelExportWizard.this.testscenarioPage.getMessage() == null);
            }
        });
        this.testscenarioPage.setPageComplete(false);
        this.excelPage = new ExcelSheetSelectionPage("ExcelPage", 8192);
        this.excelPage.setTitle(ExcelExportWizard.getClassString("excelPage.title", new Object[0]));
        this.excelPage.setDescription(ExcelExportWizard.getClassString("excelPage.description", new Object[0]));
        this.excelPage.setOpenAfterSave(!Activator.getPreferenceStore().getBoolean(NOT_OPEN_EXCEL_AFTER_EXPORT));
    }

    private void applySelection(IStructuredSelection selection) {
        Object selectedElement;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IResource) {
            IResource resource = (IResource)selectedElement;
            this.testscenarioPage.getFileSelectionComponent().setInitialSelection(resource);
            if (resource.getType() == 1) {
                this.excelPage.setProposedFilename(resource.getFullPath().removeFileExtension().lastSegment());
            }
        }
    }

    public boolean performFinish() {
        if (!License.getInstance().isOptionExcelIoLicensed()) {
            return true;
        }
        IFile testscenarioFile = this.testscenarioPage.getFileSelectionComponent().getSelectedFile();
        String excelFile = this.excelPage.getExcelFilename();
        boolean openAfterExport = this.excelPage.isOpenAfterSave();
        Activator.getPreferenceStore().setValue(NOT_OPEN_EXCEL_AFTER_EXPORT, !openAfterExport);
        XSSFWorkbook wb = new XSSFWorkbook();
        try {
            AdapterFactoryEditingDomain editingDomain = EditingUtility.createDefaultEditingDomain();
            Testscenario testscenario = EditingUtility.loadTestscenario((IFile)testscenarioFile, (EditingDomain)editingDomain);
            ExportVisitor visitor = new ExportVisitor(testscenario, wb);
            visitor.setEditingDomain((EditingDomain)editingDomain);
            visitor.visit();
            ExportCheckconditionsVisitor checkconditionsVisitor = new ExportCheckconditionsVisitor(testscenario, wb);
            checkconditionsVisitor.setEditingDomain((EditingDomain)editingDomain);
            checkconditionsVisitor.visit();
            int testcaseSize = testscenario.getTestcases().getTestcases().size();
            int i = 0;
            while (i < testcaseSize) {
                wb.setSheetOrder(wb.getSheetName(testcaseSize + i), 2 * i + 1);
                ++i;
            }
            wb.lockStructure();
        }
        catch (Exception e) {
            SavvytestSettings.INSTANCE.getLogger().log(e, (Object)this);
            MessageDialog.openError((Shell)this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)ExcelExportWizard.getClassString("error.export", e.getLocalizedMessage()));
            return false;
        }
        final File file = new File(excelFile);
        FileOutputStream fileOut = null;
        try {
            try {
                fileOut = new FileOutputStream(file);
                wb.write((OutputStream)fileOut);
            }
            catch (IOException e) {
                SavvytestSettings.INSTANCE.getLogger().log((Exception)e, (Object)this);
                MessageDialog.openError((Shell)this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)ExcelExportWizard.getClassString("error.write", e.getLocalizedMessage()));
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileOut != null) {
            try {
                fileOut.close();
            }
            catch (IOException iOException) {}
        }
        if (openAfterExport) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(file);
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)ExcelExportWizard.this.page, (IFileStore)fileStore);
                    }
                    catch (PartInitException e) {
                        SavvytestSettings.INSTANCE.getLogger().log((Exception)((Object)e), (Object)this);
                        MessageDialog.openError((Shell)ExcelExportWizard.this.getShell(), (String)Savvytest.getGlobalString((String)"error", (Object[])new Object[0]), (String)ExcelExportWizard.getClassString("error.openExcel", file, e.getLocalizedMessage()));
                    }
                }
            });
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Savvytest.setDynamicHelp((String)"com.savvytest.eclipse.help.DefaultContextHelp", (Control[])new Control[]{this.getShell()});
    }

    public void addPages() {
        if (!License.getInstance().isOptionExcelIoLicensed()) {
            this.addPage((IWizardPage)new NotLicensedPage("NotLicensedPage", 1));
            return;
        }
        this.addPage((IWizardPage)this.testscenarioPage);
        this.addPage((IWizardPage)this.excelPage);
    }
}

